/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.utilities;

import com.philips.lighting.hue.sdk.utilities.impl.Color;
import com.philips.lighting.hue.sdk.utilities.impl.PHHueHelper;
import com.philips.lighting.hue.sdk.utilities.impl.PointF;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class PHUtilities {
    private static final int CPT_RED = 0;
    private static final int CPT_GREEN = 1;
    private static final int CPT_BLUE = 2;

    public static int colorFromXY(float[] points, String model) {
        if (points == null || model == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PointF xy = new PointF(points[0], points[1]);
        List<PointF> colorPoints = PHUtilities.colorPointsForModel(model);
        boolean inReachOfLamps = PHUtilities.checkPointInLampsReach(xy, colorPoints);
        if (!inReachOfLamps) {
            PointF pAB = PHUtilities.getClosestPointToPoints(colorPoints.get(0), colorPoints.get(1), xy);
            PointF pAC = PHUtilities.getClosestPointToPoints(colorPoints.get(2), colorPoints.get(0), xy);
            PointF pBC = PHUtilities.getClosestPointToPoints(colorPoints.get(1), colorPoints.get(2), xy);
            float dAB = PHUtilities.getDistanceBetweenTwoPoints(xy, pAB);
            float dAC = PHUtilities.getDistanceBetweenTwoPoints(xy, pAC);
            float dBC = PHUtilities.getDistanceBetweenTwoPoints(xy, pBC);
            float lowest = dAB;
            PointF closestPoint = pAB;
            if (dAC < lowest) {
                lowest = dAC;
                closestPoint = pAC;
            }
            if (dBC < lowest) {
                lowest = dBC;
                closestPoint = pBC;
            }
            xy.x = closestPoint.x;
            xy.y = closestPoint.y;
        }
        float x = xy.x;
        float y = xy.y;
        float z = 1.0f - x - y;
        float y2 = 1.0f;
        float x2 = y2 / y * x;
        float z2 = y2 / y * z;
        float r = x2 * 3.2406f - y2 * 1.5372f - z2 * 0.4986f;
        float g = -x2 * 0.9689f + y2 * 1.8758f + z2 * 0.0415f;
        float b = x2 * 0.0557f - y2 * 0.204f + z2 * 1.057f;
        if (r > b && r > g && r > 1.0f) {
            g /= r;
            b /= r;
            r = 1.0f;
        } else if (g > b && g > r && g > 1.0f) {
            r /= g;
            b /= g;
            g = 1.0f;
        } else if (b > r && b > g && b > 1.0f) {
            r /= b;
            g /= b;
            b = 1.0f;
        }
        r = r <= 0.0031308f ? 12.92f * r : 1.055f * (float)Math.pow(r, 0.4166666567325592) - 0.055f;
        g = g <= 0.0031308f ? 12.92f * g : 1.055f * (float)Math.pow(g, 0.4166666567325592) - 0.055f;
        float f = b = b <= 0.0031308f ? 12.92f * b : 1.055f * (float)Math.pow(b, 0.4166666567325592) - 0.055f;
        if (r > b && r > g) {
            if (r > 1.0f) {
                g /= r;
                b /= r;
                r = 1.0f;
            }
        } else if (g > b && g > r) {
            if (g > 1.0f) {
                r /= g;
                b /= g;
                g = 1.0f;
            }
        } else if (b > r && b > g && b > 1.0f) {
            r /= b;
            g /= b;
            b = 1.0f;
        }
        if (r < 0.0f) {
            r = 0.0f;
        }
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (b < 0.0f) {
            b = 0.0f;
        }
        int r1 = (int)(r * 255.0f);
        int g1 = (int)(g * 255.0f);
        int b1 = (int)(b * 255.0f);
        return Color.rgb(r1, g1, b1);
    }

    public static float[] calculateXY(int color, String model) {
        List<PointF> colorPoints;
        PointF xyPoint;
        boolean inReachOfLamps;
        float z;
        float y;
        float b;
        float g;
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        red = (float)Color.red(color) / 255.0f;
        float r = red > 0.04045f ? (float)Math.pow((red + 0.055f) / 1.055f, 2.4f) : red / 12.92f;
        float x = r * 0.649926f + (g = (green = (float)Color.green(color) / 255.0f) > 0.04045f ? (float)Math.pow((green + 0.055f) / 1.055f, 2.4f) : green / 12.92f) * 0.103455f + (b = (blue = (float)Color.blue(color) / 255.0f) > 0.04045f ? (float)Math.pow((blue + 0.055f) / 1.055f, 2.4f) : blue / 12.92f) * 0.197109f;
        float[] xy = new float[]{x / (x + (y = r * 0.234327f + g * 0.743075f + b * 0.022598f) + (z = r * 0.0f + g * 0.053077f + b * 1.035763f)), y / (x + y + z)};
        if (Float.isNaN(xy[0])) {
            xy[0] = 0.0f;
        }
        if (Float.isNaN(xy[1])) {
            xy[1] = 0.0f;
        }
        if (!(inReachOfLamps = PHUtilities.checkPointInLampsReach(xyPoint = new PointF(xy[0], xy[1]), colorPoints = PHUtilities.colorPointsForModel(model)))) {
            PointF pAB = PHUtilities.getClosestPointToPoints(colorPoints.get(0), colorPoints.get(1), xyPoint);
            PointF pAC = PHUtilities.getClosestPointToPoints(colorPoints.get(2), colorPoints.get(0), xyPoint);
            PointF pBC = PHUtilities.getClosestPointToPoints(colorPoints.get(1), colorPoints.get(2), xyPoint);
            float dAB = PHUtilities.getDistanceBetweenTwoPoints(xyPoint, pAB);
            float dAC = PHUtilities.getDistanceBetweenTwoPoints(xyPoint, pAC);
            float dBC = PHUtilities.getDistanceBetweenTwoPoints(xyPoint, pBC);
            float lowest = dAB;
            PointF closestPoint = pAB;
            if (dAC < lowest) {
                lowest = dAC;
                closestPoint = pAC;
            }
            if (dBC < lowest) {
                lowest = dBC;
                closestPoint = pBC;
            }
            xy[0] = closestPoint.x;
            xy[1] = closestPoint.y;
        }
        xy[0] = PHHueHelper.precision(4, xy[0]);
        xy[1] = PHHueHelper.precision(4, xy[1]);
        return xy;
    }

    public static float[] calculateXYFromRGB(int red, int green, int blue, String model) {
        int rgb = Color.rgb(red, green, blue);
        return PHUtilities.calculateXY(rgb, model);
    }

    private static boolean checkPointInLampsReach(PointF point, List<PointF> colorPoints) {
        if (point == null || colorPoints == null) {
            return false;
        }
        PointF red = colorPoints.get(0);
        PointF green = colorPoints.get(1);
        PointF blue = colorPoints.get(2);
        PointF v1 = new PointF(green.x - red.x, green.y - red.y);
        PointF v2 = new PointF(blue.x - red.x, blue.y - red.y);
        PointF q = new PointF(point.x - red.x, point.y - red.y);
        float s = PHUtilities.crossProduct(q, v2) / PHUtilities.crossProduct(v1, v2);
        float t = PHUtilities.crossProduct(v1, q) / PHUtilities.crossProduct(v1, v2);
        return s >= 0.0f && t >= 0.0f && s + t <= 1.0f;
    }

    private static float getDistanceBetweenTwoPoints(PointF one, PointF two) {
        float dx = one.x - two.x;
        float dy = one.y - two.y;
        float dist = (float)Math.sqrt(dx * dx + dy * dy);
        return dist;
    }

    private static float crossProduct(PointF point1, PointF point2) {
        return point1.x * point2.y - point1.y * point2.x;
    }

    private static List<PointF> colorPointsForModel(String model) {
        if (model == null) {
            model = " ";
        }
        ArrayList<PointF> colorPoints = new ArrayList<PointF>();
        ArrayList<String> hueBulbs = new ArrayList<String>();
        hueBulbs.add("LCT001");
        hueBulbs.add("LCT002");
        hueBulbs.add("LCT003");
        ArrayList<String> livingColors = new ArrayList<String>();
        livingColors.add("LLC001");
        livingColors.add("LLC005");
        livingColors.add("LLC006");
        livingColors.add("LLC007");
        livingColors.add("LLC010");
        livingColors.add("LLC011");
        livingColors.add("LLC012");
        livingColors.add("LLC014");
        livingColors.add("LLC013");
        livingColors.add("LST001");
        if (hueBulbs.contains(model)) {
            colorPoints.add(new PointF(0.674f, 0.322f));
            colorPoints.add(new PointF(0.408f, 0.517f));
            colorPoints.add(new PointF(0.168f, 0.041f));
        } else if (livingColors.contains(model)) {
            colorPoints.add(new PointF(0.703f, 0.296f));
            colorPoints.add(new PointF(0.214f, 0.709f));
            colorPoints.add(new PointF(0.139f, 0.081f));
        } else {
            colorPoints.add(new PointF(1.0f, 0.0f));
            colorPoints.add(new PointF(0.0f, 1.0f));
            colorPoints.add(new PointF(0.0f, 0.0f));
        }
        return colorPoints;
    }

    private static PointF getClosestPointToPoints(PointF pointA, PointF pointB, PointF pointP) {
        if (pointA == null || pointB == null || pointP == null) {
            return null;
        }
        PointF pointAP = new PointF(pointP.x - pointA.x, pointP.y - pointA.y);
        PointF pointAB = new PointF(pointB.x - pointA.x, pointB.y - pointA.y);
        float apAb = pointAP.x * pointAB.x + pointAP.y * pointAB.y;
        float ab2 = pointAB.x * pointAB.x + pointAB.y * pointAB.y;
        float t = apAb / ab2;
        if (t < 0.0f) {
            t = 0.0f;
        } else if (t > 1.0f) {
            t = 1.0f;
        }
        PointF newPoint = new PointF(pointA.x + pointAB.x * t, pointA.y + pointAB.y * t);
        return newPoint;
    }

    public static Date stringToDate(String dateString) {
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", new Locale("nl_NL"));
        dateFormate.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = null;
        try {
            date = dateFormate.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
        return date;
    }

    public static Date stringToDateForTime(String dateString) {
        SimpleDateFormat dateFormate = new SimpleDateFormat("HH:mm:ss", new Locale("nl_NL"));
        dateFormate.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = null;
        try {
            date = dateFormate.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
        return date;
    }
}

