/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.model;

public class PHSoftwareUpdateStatus {
    private String releaseNotesUrl;
    private String updateText;
    private PHStateType state;
    private boolean notify;

    public PHSoftwareUpdateStatus() {
    }

    public PHSoftwareUpdateStatus(PHSoftwareUpdateStatus softwareUpdateStatus) {
        if (softwareUpdateStatus == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.releaseNotesUrl = softwareUpdateStatus.releaseNotesUrl;
        this.state = softwareUpdateStatus.state;
        this.updateText = softwareUpdateStatus.updateText;
    }

    public String getReleaseNotesUrl() {
        return this.releaseNotesUrl;
    }

    public void setReleaseNotesUrl(String url) {
        this.releaseNotesUrl = this.state == PHStateType.UPDATE_DOWNLOADING || this.state == PHStateType.UPDATE_READY_FOR_INSTALL ? (url != null && url.length() != 0 ? url : null) : url;
    }

    public String getUpdateText() {
        return this.updateText;
    }

    public void setUpdateText(String updateText) {
        this.updateText = this.state == PHStateType.UPDATE_DOWNLOADING || this.state == PHStateType.UPDATE_READY_FOR_INSTALL ? (updateText != null && updateText.length() != 0 ? updateText : null) : updateText;
    }

    public PHStateType getState() {
        return this.state;
    }

    public void setState(PHStateType state) {
        this.state = state;
    }

    public void setState(int value) {
        switch (value) {
            case 1: {
                this.state = PHStateType.UPDATE_DOWNLOADING;
                break;
            }
            case 2: {
                this.state = PHStateType.UPDATE_READY_FOR_INSTALL;
                break;
            }
            default: {
                this.state = PHStateType.NO_UPDATE;
            }
        }
    }

    public boolean isSoftwareUpdateAvailable() {
        return this.state == PHStateType.UPDATE_READY_FOR_INSTALL;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.releaseNotesUrl == null ? 0 : this.releaseNotesUrl.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.updateText == null ? 0 : this.updateText.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PHSoftwareUpdateStatus)) {
            return false;
        }
        PHSoftwareUpdateStatus other = (PHSoftwareUpdateStatus)obj;
        if (this.releaseNotesUrl == null ? other.releaseNotesUrl != null : !this.releaseNotesUrl.equals(other.releaseNotesUrl)) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (this.notify != other.notify) {
            return false;
        }
        return !(this.updateText == null ? other.updateText != null : !this.updateText.equals(other.updateText));
    }

    public static enum PHStateType {
        NO_UPDATE,
        UPDATE_DOWNLOADING,
        UPDATE_READY_FOR_INSTALL,
        UPDATE_INSTALLED;

    }
}

