/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.bridge.impl;

import com.philips.lighting.hue.listener.PHBridgeConfigurationListener;
import com.philips.lighting.hue.listener.PHGroupListener;
import com.philips.lighting.hue.listener.PHLightListener;
import com.philips.lighting.hue.listener.PHSceneListener;
import com.philips.lighting.hue.listener.PHScheduleListener;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeDelegator;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeResourcesCacheImpl;
import com.philips.lighting.hue.sdk.exception.PHHueInvalidAPIException;
import com.philips.lighting.model.PHBridge;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHBridgeResourcesCache;
import com.philips.lighting.model.PHGroup;
import com.philips.lighting.model.PHHueError;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHLightState;
import com.philips.lighting.model.PHScene;
import com.philips.lighting.model.PHSchedule;
import java.util.Hashtable;
import java.util.List;

public class PHBridgeImpl
implements PHBridge {
    private PHBridgeDelegator delegator;
    private PHBridgeResourcesCacheImpl cacheImpl;
    private boolean isPortal;

    public PHBridgeImpl(PHBridgeDelegator delegator) {
        this.delegator = delegator;
        this.cacheImpl = new PHBridgeResourcesCacheImpl();
    }

    public PHBridgeImpl(PHBridgeDelegator delegator, boolean isPortal) {
        this(delegator);
        this.isPortal = isPortal;
    }

    public PHBridgeDelegator getBridgeDelegator() {
        return this.delegator;
    }

    @Override
    public PHBridgeResourcesCache getResourceCache() {
        return this.cacheImpl;
    }

    @Override
    public void findNewLights(PHLightListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        this.delegator.findNewLights(listener);
    }

    @Override
    public void updateLight(PHLight light, PHLightListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (light == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.updateLight(light, listener, this);
    }

    @Override
    public void updateLightState(String lightIdentifier, PHLightState lightState, PHLightListener listener) {
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (lightIdentifier == null || lightState == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.updateLightState(lightIdentifier, lightState, listener, this);
    }

    @Override
    public void createGroup(String name, String[] lightIdentifiers, PHGroupListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (lightIdentifiers == null || name == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.createGroup(name, lightIdentifiers, listener, this);
    }

    @Override
    public void updateGroup(PHGroup group, PHGroupListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.updateGroup(group, listener, this);
    }

    @Override
    public void deleteGroup(String groupIdentifier, PHGroupListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (groupIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.deleteGroup(groupIdentifier, listener, this);
    }

    @Override
    public void setLightStateForGroup(String groupIdentifier, PHLightState state, PHGroupListener listener) {
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (groupIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.setLightStateForGroup(groupIdentifier, state, listener, this);
    }

    @Override
    public void updateBridgeConfigurations(PHBridgeConfiguration configuration, PHBridgeConfigurationListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        this.delegator.updateBridgeConfigurations(configuration, listener, this);
    }

    @Override
    public void removeUsername(String username, PHBridgeConfigurationListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.removeUsername(username, listener);
    }

    @Override
    public void createSchedule(PHSchedule schedule, PHScheduleListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (schedule == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.createSchedule(schedule, listener, this);
    }

    @Override
    public void updateSchedule(PHSchedule schedule, PHScheduleListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (schedule == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.updateSchedule(schedule, listener, this);
    }

    @Override
    public void removeSchedule(String scheduleIdentifier, PHScheduleListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (scheduleIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.removeSchedule(scheduleIdentifier, listener, this);
    }

    @Override
    public void updateSoftware(PHBridgeConfigurationListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        this.delegator.updateSoftware(listener, this);
    }

    @Override
    public void getBridgeConfigurations(PHBridgeConfigurationListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        this.delegator.getBridgeConfigurations(listener, this);
    }

    @Override
    public void getAllScenes(PHSceneListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        this.delegator.getAllScenes(listener);
    }

    @Override
    public void saveScene(PHScene scene, PHSceneListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (scene == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.saveScene(scene, listener);
    }

    @Override
    public void activateScene(String sceneIdentifier, String groupIdentifier, PHSceneListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (sceneIdentifier == null || groupIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.activateScene(sceneIdentifier, groupIdentifier, listener);
    }

    @Override
    public void saveSceneWithCurrentLightStates(PHScene scene, PHSceneListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (scene == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.saveScene(scene, listener);
    }

    @Override
    public void findNewLightsWithSerials(List<String> serials, PHLightListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (serials == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.findNewLightsWithSerials(serials, listener);
    }

    @Override
    public void saveLightState(PHLightState lightState, String lightIdentifier, String sceneIdentifier, PHSceneListener listener) throws PHHueInvalidAPIException {
        if (this.isPortal) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (lightState == null || lightIdentifier == null || sceneIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.saveLightState(lightState, lightIdentifier, sceneIdentifier, listener);
    }

    @Override
    public void updateLightState(PHLight light, PHLightState lightState, PHLightListener listener) {
        this.delegator.updateLightState(light.getIdentifier(), lightState, listener, this);
    }

    @Override
    public void updateLightState(PHLight light, PHLightState lightState) {
        PHLightListener listener = new PHLightListener(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onStateUpdate(Hashtable<String, String> successAttribute, List<PHHueError> errorAttribute) {
            }

            @Override
            public void onError(int code, String message) {
            }
        };
        this.delegator.updateLightState(light.getIdentifier(), lightState, listener, this);
    }

    @Override
    public void setLightStateForDefaultGroup(PHLightState state) {
        this.setLightStateForGroup("0", state);
    }

    @Override
    public void setLightStateForGroup(String groupIdentifier, PHLightState state) {
        PHGroupListener groupListener = new PHGroupListener(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onStateUpdate(Hashtable<String, String> successAttribute, List<PHHueError> errorAttribute) {
            }

            @Override
            public void onError(int code, String message) {
            }
        };
        if (this.delegator == null) {
            throw new IllegalArgumentException("Delgator can't be null");
        }
        if (groupIdentifier == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.delegator.setLightStateForGroup(groupIdentifier, state, groupListener, this);
    }
}

