/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip;

import com.philips.lighting.hue.sdk.clip.PHCLIPBuilder;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHGroup;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHLightState;
import com.philips.lighting.model.PHSchedule;
import com.philips.lighting.model.PHSoftwareUpdateStatus;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PHCLIPBuilder1_0
implements PHCLIPBuilder {
    public static final int LOCAL_KEY = 4626;
    public static final int PORTAL_KEY = 13364;

    public static PHCLIPBuilder1_0 getInstance(int key) {
        if (key == 4626 || key == 13364) {
            return new PHCLIPBuilder1_0();
        }
        return null;
    }

    public JSONObject lightStateForIdPacket(PHLightState state) throws JSONException {
        JSONObject toSend = new JSONObject();
        if (state.getHue() != -55) {
            toSend.putOpt("hue", state.getHue());
        }
        if (state.isOn() != null) {
            toSend.putOpt("on", state.isOn());
        }
        if (state.getBrightness() != -55) {
            toSend.putOpt("bri", state.getBrightness());
        }
        if (state.getSaturation() != -55) {
            toSend.putOpt("sat", state.getSaturation());
        }
        if (state.getTransitionTime() != -55) {
            toSend.putOpt("transitiontime", state.getTransitionTime());
        }
        if (state.getCt() != -55) {
            toSend.putOpt("ct", state.getCt());
        }
        if (state.getX() != -55.0f && state.getY() != -55.0f) {
            JSONArray xyArray = new JSONArray();
            JSONObject tempX = new JSONObject(String.format(Locale.ENGLISH, "{\"tempX\": %.4f}", Float.valueOf(state.getX())));
            JSONObject tempY = new JSONObject(String.format(Locale.ENGLISH, "{\"tempY\": %.4f}", Float.valueOf(state.getY())));
            xyArray.put(tempX.get("tempX"));
            xyArray.put(tempY.get("tempY"));
            toSend.putOpt("xy", xyArray);
        }
        if (state.getAlertMode() != null) {
            String alert = null;
            if (state.getAlertMode() == PHLight.PHLightAlertMode.ALERT_NONE) {
                alert = "none";
            } else if (state.getAlertMode() == PHLight.PHLightAlertMode.ALERT_LSELECT) {
                alert = "lselect";
            } else if (state.getAlertMode() == PHLight.PHLightAlertMode.ALERT_SELECT) {
                alert = "select";
            }
            if (alert != null) {
                toSend.putOpt("alert", alert);
            }
        }
        if (state.getEffectMode() != null) {
            String effect = null;
            if (state.getEffectMode() == PHLight.PHLightEffectMode.EFFECT_COLORLOOP) {
                effect = "colorloop";
            } else if (state.getEffectMode() == PHLight.PHLightEffectMode.EFFECT_NONE) {
                effect = "none";
            }
            if (effect != null) {
                toSend.putOpt("effect", effect);
            }
        }
        return toSend;
    }

    @Override
    public String updateLightStateForIdPacket(PHLightState state) throws JSONException {
        JSONObject toSend = this.lightStateForIdPacket(state);
        if (toSend != null) {
            return toSend.toString();
        }
        return null;
    }

    @Override
    public String createGroupPacket(String name, String[] lightIdentifiers) throws JSONException {
        JSONObject toSend = new JSONObject();
        JSONArray array = new JSONArray();
        int i = 0;
        while (i < lightIdentifiers.length) {
            array.put(i, lightIdentifiers[i]);
            ++i;
        }
        toSend.putOpt("name", name);
        toSend.putOpt("lights", array);
        return toSend.toString();
    }

    @Override
    public String createUpdateGroup(PHGroup group) throws JSONException {
        JSONObject toSend = new JSONObject();
        toSend.put("name", group.getName());
        if (group.getLightIdentifiers() != null) {
            JSONArray array = new JSONArray();
            int i = 0;
            while (i < group.getLightIdentifiers().length) {
                array.put(i, group.getLightIdentifiers()[i]);
                ++i;
            }
            toSend.putOpt("lights", array);
        }
        return toSend.toString();
    }

    @Override
    public String createUpdateLightPacket(PHLight light) throws JSONException {
        JSONObject toSend = new JSONObject();
        toSend.putOpt("name", light.getName());
        return toSend.toString();
    }

    @Override
    public String createUpdateBridge(PHBridgeConfiguration bridgeConfig) throws JSONException {
        PHSoftwareUpdateStatus status;
        JSONObject toSend = new JSONObject();
        if (bridgeConfig.getName() != null && bridgeConfig.getName().length() > 0) {
            toSend.putOpt("name", bridgeConfig.getName());
        }
        if (bridgeConfig.getTime() != null && bridgeConfig.getTime().length() > 0) {
            toSend.putOpt("UTC", bridgeConfig.getTime());
        }
        if (bridgeConfig.getProxy() != null && bridgeConfig.getProxy().length() > 0) {
            toSend.putOpt("proxyaddress", bridgeConfig.getProxy());
        }
        if (bridgeConfig.getProxyPort() != -55) {
            toSend.putOpt("proxyport", bridgeConfig.getProxyPort());
        }
        if (bridgeConfig.getDhcpEnabled() != null) {
            toSend.putOpt("dhcp", bridgeConfig.getDhcpEnabled());
        }
        if (bridgeConfig.getIpAddress() != null && bridgeConfig.getIpAddress().length() > 0) {
            toSend.putOpt("ipaddress", bridgeConfig.getIpAddress());
        }
        if (bridgeConfig.getNetmask() != null && bridgeConfig.getNetmask().length() > 0) {
            toSend.putOpt("netmask", bridgeConfig.getNetmask());
        }
        if (bridgeConfig.getGateway() != null && bridgeConfig.getGateway().length() > 0) {
            toSend.putOpt("gateway", bridgeConfig.getGateway());
        }
        if (bridgeConfig.getPortalServicesEnabled() != null) {
            toSend.putOpt("portalservices", bridgeConfig.getPortalServicesEnabled());
        }
        if ((status = bridgeConfig.getSoftwareStatus()) != null) {
            JSONObject swUpdateJson = new JSONObject();
            PHSoftwareUpdateStatus.PHStateType state = status.getState();
            if (state != null) {
                if (state == PHSoftwareUpdateStatus.PHStateType.NO_UPDATE) {
                    swUpdateJson.putOpt("notify", false);
                } else {
                    swUpdateJson.putOpt("updatestate", state.ordinal());
                }
            }
            toSend.putOpt("swupdate", swUpdateJson);
        }
        return toSend.toString();
    }

    @Override
    public String createSchedulePacket(PHSchedule timer, String cmdAddress, String method, String timeZone) throws JSONException {
        Date date;
        JSONObject cmd = new JSONObject();
        if (cmdAddress != null) {
            cmd.putOpt("address", cmdAddress);
        }
        if (method != null) {
            cmd.putOpt("method", method);
        }
        if (timer.getLightState() != null) {
            cmd.putOpt("body", this.lightStateForIdPacket(timer.getLightState()));
        }
        JSONObject toSend = new JSONObject();
        if (timer.getName() != null) {
            toSend.putOpt("name", timer.getName());
        }
        if (timer.getDescription() != null && timer.getDescription().length() != 0) {
            toSend.putOpt("description", timer.getDescription());
        }
        if (cmd != null) {
            toSend.putOpt("command", cmd);
        }
        if ((date = timer.getDate()) != null) {
            SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", new Locale("nl_NL"));
            if (timeZone == null || timeZone.length() == 0) {
                timeZone = "UTC";
            }
            dateFormate.setTimeZone(TimeZone.getTimeZone(timeZone));
            String timerTime = dateFormate.format(date);
            toSend.putOpt("time", timerTime);
        }
        return toSend.toString();
    }

    @Override
    public String createSchedulePacket(PHSchedule timer, String cmdAddress, String method) throws JSONException {
        return this.createSchedulePacket(timer, cmdAddress, method, "UTC");
    }

    @Override
    public String updateSchedulePacket(PHSchedule timer, String cmdAddress, String method, String timeZone) throws JSONException {
        return null;
    }

    @Override
    public String updateSchedulePacket(PHSchedule timer, String cmdAddress, String method) throws JSONException {
        return null;
    }

    @Override
    public String createScenePacket(String name, String[] lightIdentifiers) throws JSONException {
        return null;
    }

    @Override
    public String createActivateScenePacket(String sceneId) throws JSONException {
        return null;
    }

    @Override
    public String createFindLightSerialsPacket(List<String> serials) throws JSONException {
        return null;
    }
}

