/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip;

import com.philips.lighting.hue.sdk.clip.PHCLIPParser;
import com.philips.lighting.hue.sdk.utilities.PHUtilities;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHBridgeResource;
import com.philips.lighting.model.PHGroup;
import com.philips.lighting.model.PHHueError;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHLightState;
import com.philips.lighting.model.PHScene;
import com.philips.lighting.model.PHSchedule;
import com.philips.lighting.model.PHSoftwareUpdateStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PHCLIPParser1_0
implements PHCLIPParser {
    public static final int LOCAL_KEY = 4626;
    public static final int PORTAL_KEY = 13364;
    private static final String TAG = "PHCLIPParser1_0";
    public String errorMassage;

    public static PHCLIPParser1_0 getInstance(int key) {
        if (key == 4626 || key == 13364) {
            return new PHCLIPParser1_0();
        }
        return null;
    }

    public List<PHBridgeResource> parseGetAllGroup(String response) {
        ArrayList<PHBridgeResource> list = new ArrayList<PHBridgeResource>();
        try {
            JSONArray arrays;
            JSONObject jObject = new JSONObject(response);
            if (jObject != null && (arrays = jObject.names()) != null) {
                int i = 0;
                while (i < arrays.length()) {
                    String identifier = arrays.optString(i);
                    JSONObject obj = jObject.optJSONObject(identifier);
                    if (obj != null) {
                        String name = obj.optString("name");
                        PHBridgeResource newHeader = new PHBridgeResource(name, identifier);
                        list.add(newHeader);
                    }
                    ++i;
                }
            }
            return list;
        }
        catch (JSONException e) {
            if (PHLog.isLoggable()) {
                PHLog.e(TAG, "JSONException: " + e);
            }
            return null;
        }
    }

    public PHGroup parseGetGroupDetails(String response, String groupIdentifier) {
        block4: {
            JSONObject jObject = null;
            try {
                jObject = new JSONObject(response);
                if (jObject != null) {
                    String name = jObject.optString("name");
                    JSONArray lights = jObject.optJSONArray("lights");
                    String[] strLights = new String[lights.length()];
                    int i = 0;
                    while (i < lights.length()) {
                        strLights[i] = lights.optString(i);
                        ++i;
                    }
                    PHGroup foundGroup = new PHGroup(name, groupIdentifier);
                    foundGroup.setLightIdentifiers(strLights);
                    return foundGroup;
                }
            }
            catch (JSONException e) {
                if (!PHLog.isLoggable()) break block4;
                PHLog.e(TAG, "JSONException: " + e);
            }
        }
        return null;
    }

    @Override
    public List<PHBridgeResource> parseGetAllLightHeaders(String response) {
        ArrayList<PHBridgeResource> newLightHeaderList = new ArrayList<PHBridgeResource>();
        JSONObject jObject = null;
        try {
            jObject = new JSONObject(response);
            if (jObject != null) {
                JSONArray arrays = jObject.names();
                newLightHeaderList.clear();
                if (arrays != null) {
                    int i = 0;
                    while (i < arrays.length()) {
                        String identifier = arrays.optString(i);
                        JSONObject obj = jObject.optJSONObject(identifier);
                        if (obj != null) {
                            String name = obj.optString("name");
                            PHBridgeResource newHeader = new PHBridgeResource(name, identifier);
                            newLightHeaderList.add(newHeader);
                        }
                        ++i;
                    }
                }
            }
            return newLightHeaderList;
        }
        catch (JSONException e) {
            if (PHLog.isLoggable()) {
                PHLog.e(TAG, "JSONException: " + e);
            }
            return null;
        }
    }

    public PHLight parseLightDetails(String response, String lightIdentifier) {
        block3: {
            JSONObject jObject = null;
            try {
                jObject = new JSONObject(response);
                if (jObject != null) {
                    String name = jObject.optString("name");
                    String type = jObject.optString("type");
                    String modelId = jObject.optString("modelid");
                    String swversion = jObject.optString("swversion");
                    boolean reachable = jObject.optBoolean("reachable");
                    PHLight foundLight = new PHLight(name, lightIdentifier, swversion, modelId);
                    foundLight.setLightType(type);
                    foundLight.setReachable(reachable);
                    return foundLight;
                }
            }
            catch (JSONException e) {
                if (!PHLog.isLoggable()) break block3;
                PHLog.e(TAG, "JSONException: " + e);
            }
        }
        return null;
    }

    @Override
    public PHBridgeConfiguration parseBridgeConfiguration(JSONObject rootObject) {
        PHBridgeConfiguration bridgeConfig = new PHBridgeConfiguration();
        JSONObject config = rootObject.optJSONObject("config");
        if (config == null) {
            config = rootObject;
        }
        if (config != null) {
            Integer proxyPort = 0;
            String ipAddress = config.optString("ipaddress");
            String macAddress = config.optString("mac");
            String name = config.optString("name");
            String proxy = config.optString("proxyaddress");
            String netmask = config.optString("netmask");
            String gateway = config.optString("gateway");
            proxyPort = config.optInt("proxyport");
            Boolean dhcpEnabled = null;
            dhcpEnabled = config.isNull("dhcp") ? null : Boolean.valueOf(config.optBoolean("dhcp"));
            String swversion = config.optString("swversion");
            Boolean portalServiceEnabled = config.isNull("portalservices") ? null : Boolean.valueOf(config.optBoolean("portalservices"));
            String time = config.optString("UTC");
            PHSoftwareUpdateStatus status = new PHSoftwareUpdateStatus();
            JSONObject swconfig = config.optJSONObject("swupdate");
            if (swconfig != null) {
                boolean notified = swconfig.optBoolean("notify");
                if (notified) {
                    status.setState(PHSoftwareUpdateStatus.PHStateType.UPDATE_INSTALLED);
                    status.setNotify(true);
                } else {
                    int swState = swconfig.optInt("updatestate");
                    status.setState(swState);
                    status.setNotify(false);
                }
                status.setReleaseNotesUrl(swconfig.optString("url"));
                status.setUpdateText(swconfig.optString("text"));
            } else {
                status.setNotify(false);
            }
            if (bridgeConfig != null) {
                bridgeConfig.setIpAddress(ipAddress);
                bridgeConfig.setName(name);
                bridgeConfig.setProxy(proxy);
                bridgeConfig.setProxyPort(proxyPort);
                bridgeConfig.setNetmask(netmask);
                bridgeConfig.setGateway(gateway);
                bridgeConfig.setDhcpEnabled(dhcpEnabled);
                bridgeConfig.setSoftwareVersion(swversion);
                bridgeConfig.setPortalServicesEnabled(portalServiceEnabled);
                bridgeConfig.setSoftwareStatus(status);
                bridgeConfig.setTime(time);
                bridgeConfig.setMacAddress(macAddress);
            }
        }
        return bridgeConfig;
    }

    @Override
    public List<PHSchedule> parseSchedules(JSONObject rootObject) {
        JSONArray schedulesArray;
        ArrayList<PHSchedule> schedulesList = new ArrayList<PHSchedule>();
        JSONObject schedules = rootObject.optJSONObject("schedules");
        if (schedules == null) {
            schedules = rootObject;
        }
        if (schedules != null && (schedulesArray = schedules.names()) != null) {
            int i = 0;
            while (i < schedulesArray.length()) {
                String scheduleIdentifier = schedulesArray.optString(i);
                JSONObject scheduleObject = schedules.optJSONObject(scheduleIdentifier);
                if (scheduleObject != null) {
                    String time;
                    String name = scheduleObject.optString("name");
                    if (name == null || name.length() == 0) {
                        this.errorMassage = "JSON is missing key: name";
                        return null;
                    }
                    PHSchedule schedule = new PHSchedule(name);
                    schedule.setIdentifier(scheduleIdentifier);
                    String description = scheduleObject.optString("description");
                    schedule.setDescription(description);
                    JSONObject commandObject = scheduleObject.optJSONObject("command");
                    if (commandObject != null) {
                        PHLightState lightState;
                        ArrayList<String> commandKeysNeeded = new ArrayList<String>();
                        commandKeysNeeded.add("address");
                        commandKeysNeeded.add("body");
                        commandKeysNeeded.add("method");
                        Iterator keyIterator = commandObject.keys();
                        int keyCount = 0;
                        while (keyIterator.hasNext()) {
                            String key = (String)keyIterator.next();
                            if (!commandKeysNeeded.contains(key)) continue;
                            commandKeysNeeded.remove(key);
                            ++keyCount;
                        }
                        if (keyCount != 3) {
                            String missingKey = "";
                            int j = 0;
                            while (j < commandKeysNeeded.size()) {
                                missingKey = String.valueOf(missingKey) + (String)commandKeysNeeded.get(j) + ",";
                                ++j;
                            }
                            missingKey = missingKey.substring(0, missingKey.length() - 1);
                            this.errorMassage = "JSON is missing key : command(" + missingKey + ").";
                            return null;
                        }
                        String address = commandObject.optString("address");
                        JSONObject bodyObject = commandObject.optJSONObject("body");
                        String[] addressComponent = address.split("/");
                        if (addressComponent.length > 4) {
                            if (addressComponent[3].equals("groups")) {
                                String groupIdentifier = addressComponent[4];
                                schedule.setGroupIdentifier(groupIdentifier);
                            } else if (addressComponent[3].equals("lights")) {
                                String lightIdentifier = addressComponent[4];
                                schedule.setLightIdentifier(lightIdentifier);
                            }
                        }
                        if (bodyObject != null && (lightState = this.parseLightState(bodyObject)) != null) {
                            schedule.setLightState(lightState);
                        }
                    }
                    if ((time = scheduleObject.optString("time")) != null) {
                        Date timerTime = PHUtilities.stringToDate(time);
                        schedule.setDate(timerTime);
                    }
                    schedulesList.add(schedule);
                }
                ++i;
            }
        }
        return schedulesList;
    }

    PHLightState parseLightState(JSONObject stateObject) {
        Boolean on = null;
        PHLightState lightState = new PHLightState();
        on = stateObject.isNull("on") ? null : Boolean.valueOf(stateObject.optBoolean("on"));
        Integer brightness = stateObject.optInt("bri");
        Integer hue = stateObject.optInt("hue");
        Integer saturation = stateObject.optInt("sat");
        JSONArray xyArray = stateObject.optJSONArray("xy");
        Float x = null;
        Float y = null;
        if (xyArray != null) {
            x = Float.valueOf((float)xyArray.optDouble(0));
            y = Float.valueOf((float)xyArray.optDouble(1));
        } else {
            x = Float.valueOf(0.0f);
            y = Float.valueOf(0.0f);
        }
        Integer ct = stateObject.optInt("ct");
        String alertType = stateObject.optString("alert");
        String effectMode = stateObject.optString("effect");
        String colorMode = stateObject.optString("colormode");
        lightState.setOn(on);
        lightState.setBrightness(brightness);
        lightState.setHue(hue);
        lightState.setSaturation(saturation);
        lightState.setX(x.floatValue());
        lightState.setY(y.floatValue());
        lightState.setCt(ct);
        lightState.setAlertMode(this.chooseAlertMode(alertType));
        lightState.setEffectMode(this.chooseEffectMode(effectMode));
        lightState.setColorMode(this.chooseColorMode(colorMode));
        return lightState;
    }

    @Override
    public List<PHGroup> parseGroups(JSONObject rootObject) {
        JSONArray groupsArray;
        ArrayList<PHGroup> groupsList = new ArrayList<PHGroup>();
        JSONObject groups = rootObject.optJSONObject("groups");
        if (groups == null) {
            groups = rootObject;
        }
        if (groups != null && (groupsArray = groups.names()) != null) {
            int i = 0;
            while (i < groupsArray.length()) {
                String groupIdentifier = groupsArray.optString(i);
                JSONObject groupObject = groups.optJSONObject(groupIdentifier);
                if (groupObject != null) {
                    JSONArray lightsArray = groupObject.optJSONArray("lights");
                    String name = groupObject.optString("name");
                    PHGroup newPHGroup = new PHGroup(name, groupIdentifier);
                    if (lightsArray != null) {
                        String[] lightsIdentifier = new String[lightsArray.length()];
                        int lightcounter = 0;
                        while (lightcounter < lightsIdentifier.length) {
                            lightsIdentifier[lightcounter] = lightsArray.optString(lightcounter);
                            ++lightcounter;
                        }
                        newPHGroup.setLightIdentifiers(lightsIdentifier);
                    }
                    groupsList.add(newPHGroup);
                }
                ++i;
            }
        }
        return groupsList;
    }

    @Override
    public List<PHLight> parseLights(JSONObject rootObject) {
        JSONArray lightsArray;
        ArrayList<PHLight> lightsList = new ArrayList<PHLight>();
        JSONObject lights = rootObject.optJSONObject("lights");
        if (lights == null) {
            lights = rootObject;
        }
        if (lights != null && (lightsArray = lights.names()) != null) {
            int i = 0;
            while (i < lightsArray.length()) {
                String lightIdentifier = lightsArray.optString(i);
                JSONObject lightObject = lights.optJSONObject(lightIdentifier);
                if (lightObject != null) {
                    String type = lightObject.optString("type");
                    String name = lightObject.optString("name");
                    String modelId = lightObject.optString("modelid");
                    String swversion = lightObject.optString("swversion");
                    JSONObject stateObject = lightObject.optJSONObject("state");
                    PHLight newPHLight = new PHLight(name, lightIdentifier, swversion, modelId);
                    newPHLight.setLightType(type);
                    if (stateObject != null) {
                        boolean reachable = stateObject.optBoolean("reachable");
                        newPHLight.setReachable(reachable);
                        PHLightState phLightState = this.parseLightState(stateObject);
                        if (phLightState != null) {
                            newPHLight.setLastKnownLightState(phLightState);
                        }
                    } else {
                        newPHLight.setLastKnownLightState(null);
                    }
                    lightsList.add(newPHLight);
                }
                ++i;
            }
        }
        return lightsList;
    }

    private PHLight.PHLightAlertMode chooseAlertMode(String alertType) {
        if (alertType != null && alertType.length() != 0) {
            if (alertType.equalsIgnoreCase("select")) {
                return PHLight.PHLightAlertMode.ALERT_SELECT;
            }
            if (alertType.equalsIgnoreCase("lselect")) {
                return PHLight.PHLightAlertMode.ALERT_LSELECT;
            }
            if (alertType.equalsIgnoreCase("none")) {
                return PHLight.PHLightAlertMode.ALERT_NONE;
            }
            return PHLight.PHLightAlertMode.ALERT_UNKNOWN;
        }
        return null;
    }

    private PHLight.PHLightColorMode chooseColorMode(String colorMode) {
        if (colorMode != null && colorMode.length() != 0) {
            if (colorMode.equalsIgnoreCase("ct")) {
                return PHLight.PHLightColorMode.COLORMODE_CT;
            }
            if (colorMode.equalsIgnoreCase("hs")) {
                return PHLight.PHLightColorMode.COLORMODE_HUE_SATURATION;
            }
            if (colorMode.equalsIgnoreCase("xy")) {
                return PHLight.PHLightColorMode.COLORMODE_XY;
            }
            if (colorMode.equalsIgnoreCase("none")) {
                return PHLight.PHLightColorMode.COLORMODE_NONE;
            }
            return PHLight.PHLightColorMode.COLORMODE_UNKNOWN;
        }
        return null;
    }

    private PHLight.PHLightEffectMode chooseEffectMode(String effectMode) {
        if (effectMode != null && effectMode.length() != 0) {
            if (effectMode.equalsIgnoreCase("colorloop")) {
                return PHLight.PHLightEffectMode.EFFECT_COLORLOOP;
            }
            if (effectMode.equalsIgnoreCase("none")) {
                return PHLight.PHLightEffectMode.EFFECT_NONE;
            }
            return PHLight.PHLightEffectMode.EFFECT_UNKNOWN;
        }
        return null;
    }

    public boolean parseIsSuccess(String response) {
        block3: {
            JSONObject jObject = null;
            try {
                String isSucceeded;
                JSONArray jsonArray = new JSONArray(response);
                jObject = jsonArray.optJSONObject(0);
                if (jObject != null && (isSucceeded = jObject.optString("success")) != null) {
                    return true;
                }
            }
            catch (JSONException e) {
                if (!PHLog.isLoggable()) break block3;
                PHLog.e(TAG, "JSONException: " + e);
            }
        }
        return false;
    }

    @Override
    public List<PHHueError> parseError(String response) {
        ArrayList<PHHueError> errorList;
        block4: {
            errorList = new ArrayList<PHHueError>();
            try {
                JSONArray jsonArray = new JSONArray(response);
                int i = 0;
                while (i < jsonArray.length()) {
                    JSONObject errorObject;
                    JSONObject jsonObject = jsonArray.optJSONObject(i);
                    if (jsonObject != null && (errorObject = jsonObject.optJSONObject("error")) != null) {
                        int type = errorObject.optInt("type");
                        String description = errorObject.optString("description");
                        String address = errorObject.optString("address");
                        errorList.add(new PHHueError(type, description, address));
                    }
                    ++i;
                }
            }
            catch (JSONException e) {
                if (!PHLog.isLoggable()) break block4;
                PHLog.e(TAG, "JSONException: " + e);
            }
        }
        return errorList;
    }

    @Override
    public Hashtable<String, String> parseSuccess(String response) {
        Hashtable<String, String> successHashTable;
        block5: {
            successHashTable = new Hashtable<String, String>();
            try {
                JSONArray jsonArray = new JSONArray(response);
                int i = 0;
                while (i < jsonArray.length()) {
                    JSONObject successObj;
                    JSONObject jsonObject = jsonArray.optJSONObject(i);
                    if (jsonObject != null && (successObj = jsonObject.optJSONObject("success")) != null) {
                        Iterator iter = successObj.keys();
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            String value = successObj.optString(key);
                            successHashTable.put(key, value);
                        }
                    }
                    ++i;
                }
            }
            catch (JSONException e) {
                if (!PHLog.isLoggable()) break block5;
                PHLog.e(TAG, "JSONException: " + e);
            }
        }
        return successHashTable;
    }

    @Override
    public List<PHScene> parseScene(JSONObject rootObject) {
        return null;
    }

    @Override
    public String getErrorMassage() {
        return this.errorMassage;
    }
}

