/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.model;

import com.philips.lighting.model.PHBridgeResource;
import com.philips.lighting.model.PHLightState;
import java.util.Locale;

public class PHLight
extends PHBridgeResource {
    private static final String STR_ON_OFF = "on/off light";
    private static final String STR_ON_OFF_PLUGIN = "on/off plug-in unit";
    private static final String STR_DIMABLE = "dimmable light";
    private static final String STR_DIMABLE_PLUGIN = "dimmable plug-in unit";
    private static final String STR_COLOR_LIGHT = "color light";
    private static final String STR_CT_COLOR = "ctcolor light";
    private static final String STR_EXTENDED_COLOR = "extended color light";
    private static final String STR_CT_LIGHT = "ct light";
    private static final String STR_COLOR_TEMPERATURE = "color temperature light";
    private PHLightType type;
    private String versionNumber;
    private String modelNumber;
    private boolean isReachable;
    private PHLightState lastKnownLightState = null;

    public PHLight(String name, String identifier, String versionNumber, String modelNumber) {
        super(name, identifier);
        this.versionNumber = versionNumber;
        this.modelNumber = modelNumber;
    }

    public PHLight(PHLight light) {
        super(PHLight.isNull(light).getName(), PHLight.isNull(light).getIdentifier());
        this.isReachable = light.isReachable;
        this.lastKnownLightState = light.lastKnownLightState;
        this.modelNumber = light.modelNumber;
        this.type = light.type;
        this.versionNumber = light.versionNumber;
    }

    public PHLightType getLightType() {
        return this.type;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public void setModelNumber(String modelNumber) {
        this.modelNumber = modelNumber;
    }

    public PHLightState getLastKnownLightState() {
        return this.lastKnownLightState;
    }

    public void setLastKnownLightState(PHLightState lastKnownLightState) {
        this.lastKnownLightState = lastKnownLightState;
    }

    public boolean isReachable() {
        return this.isReachable;
    }

    public void setReachable(boolean isReachable) {
        this.isReachable = isReachable;
    }

    public boolean supportsColor() {
        switch (this.type) {
            case CT_COLOR_LIGHT: 
            case COLOR_LIGHT: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsCT() {
        switch (this.type) {
            case CT_COLOR_LIGHT: 
            case CT_LIGHT: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsBrightness() {
        switch (this.type) {
            case ON_OFF_LIGHT: {
                return false;
            }
        }
        return true;
    }

    public void setLightType(String lightType) {
        this.type = lightType == null ? PHLightType.CT_COLOR_LIGHT : ((lightType = lightType.toLowerCase(Locale.US)).equals(STR_ON_OFF) || lightType.equals(STR_ON_OFF_PLUGIN) ? PHLightType.ON_OFF_LIGHT : (lightType.equals(STR_DIMABLE) || lightType.equals(STR_DIMABLE_PLUGIN) ? PHLightType.DIM_LIGHT : (lightType.equals(STR_COLOR_LIGHT) ? PHLightType.COLOR_LIGHT : (lightType.equals(STR_CT_COLOR) || lightType.equals(STR_EXTENDED_COLOR) ? PHLightType.CT_COLOR_LIGHT : (lightType.equals(STR_CT_LIGHT) || lightType.equals(STR_COLOR_TEMPERATURE) ? PHLightType.CT_LIGHT : PHLightType.ON_OFF_LIGHT)))));
    }

    public String toString() {
        String light = "Identifier: " + this.getIdentifier() + "\n";
        light = String.valueOf(light) + "Name: " + this.getName() + "\n";
        switch (this.type) {
            case COLOR_LIGHT: {
                light = String.valueOf(light) + "type: COLOR_LIGHT\n";
                break;
            }
            case CT_LIGHT: {
                light = String.valueOf(light) + "type: CT_LIGHT\n";
                break;
            }
            case CT_COLOR_LIGHT: {
                light = String.valueOf(light) + "type: CT_COLOR_LIGHT\n";
                break;
            }
            case DIM_LIGHT: {
                light = String.valueOf(light) + "type: DIM_LIGHT\n";
                break;
            }
            case ON_OFF_LIGHT: {
                light = String.valueOf(light) + "type: ON_OFF_LIGHT\n";
            }
        }
        return light;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isReachable ? 1231 : 1237);
        result = 31 * result + (this.lastKnownLightState == null ? 0 : this.lastKnownLightState.hashCode());
        result = 31 * result + (this.modelNumber == null ? 0 : this.modelNumber.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.versionNumber == null ? 0 : this.versionNumber.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PHLight)) {
            return false;
        }
        PHLight other = (PHLight)obj;
        if (this.isReachable != other.isReachable) {
            return false;
        }
        if (this.lastKnownLightState == null ? other.lastKnownLightState != null : !this.lastKnownLightState.equals(other.lastKnownLightState)) {
            return false;
        }
        if (this.modelNumber == null ? other.modelNumber != null : !this.modelNumber.equals(other.modelNumber)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.versionNumber == null ? other.versionNumber != null : !this.versionNumber.equals(other.versionNumber));
    }

    private static PHLight isNull(PHLight light) {
        if (light == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        return light;
    }

    public static enum PHLightAlertMode {
        ALERT_UNKNOWN,
        ALERT_NONE,
        ALERT_SELECT,
        ALERT_LSELECT;

    }

    public static enum PHLightColorMode {
        COLORMODE_UNKNOWN,
        COLORMODE_NONE,
        COLORMODE_CT,
        COLORMODE_HUE_SATURATION,
        COLORMODE_XY;

    }

    public static enum PHLightEffectMode {
        EFFECT_UNKNOWN,
        EFFECT_NONE,
        EFFECT_COLORLOOP;

    }

    public static enum PHLightType {
        UNKNOWN_LIGHT,
        CT_COLOR_LIGHT,
        COLOR_LIGHT,
        CT_LIGHT,
        DIM_LIGHT,
        ON_OFF_LIGHT;

    }
}

