/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.model;

import com.philips.lighting.model.PHLight;

public class PHLightState {
    public static final int VALUE_NOT_SET = -55;
    private static final int BRIGHTNESS_MAX = 254;
    private static final int BRIGHTNESS_MIN = 0;
    private static final int HUE_MAX = 65535;
    private static final int HUE_MIN = 0;
    private static final int SATURATION_MAX = 254;
    private static final int SATURATION_MIN = 0;
    private static final int CT_MAX = 500;
    private static final int CT_MIN = 153;
    private static final float XY_MAX = 1.0f;
    private static final float XY_MIN = 0.0f;
    private static final int TRANSITION_TIME_MAX = 65535;
    private static final int TRANSITION_TIME_MIN = 0;
    private Boolean on;
    private int brightness = -55;
    private int hue = -55;
    private int saturation = -55;
    private int ct = -55;
    private PHLight.PHLightAlertMode alert;
    private PHLight.PHLightEffectMode effect;
    private int transitionTime = -55;
    private float x = -55.0f;
    private float y = -55.0f;
    private PHLight.PHLightColorMode colormode;

    public PHLightState() {
    }

    public PHLightState(PHLightState lightState) {
        if (lightState == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.alert = lightState.alert;
        this.brightness = lightState.brightness;
        this.colormode = lightState.colormode;
        this.ct = lightState.ct;
        this.effect = lightState.effect;
        this.hue = lightState.hue;
        this.on = lightState.on;
        this.saturation = lightState.saturation;
        this.transitionTime = lightState.transitionTime;
        this.x = lightState.x;
        this.y = lightState.y;
    }

    public Boolean isOn() {
        return this.on;
    }

    public void setOn(Boolean on) {
        this.on = on;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public void setBrightness(int brightness) {
        this.brightness = brightness;
    }

    public int getHue() {
        return this.hue;
    }

    public void setHue(int hue) {
        this.hue = hue;
    }

    public int getSaturation() {
        return this.saturation;
    }

    public void setSaturation(int saturation) {
        this.saturation = saturation;
    }

    public int getCt() {
        return this.ct;
    }

    public void setCt(int ct) {
        this.ct = ct;
    }

    public PHLight.PHLightAlertMode getAlertMode() {
        return this.alert;
    }

    public PHLight.PHLightEffectMode getEffectMode() {
        return this.effect;
    }

    public int getTransitionTime() {
        return this.transitionTime;
    }

    public void setTransitionTime(int transitionTime) {
        this.transitionTime = transitionTime;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public PHLight.PHLightColorMode getColorMode() {
        return this.colormode;
    }

    public void setAlertMode(PHLight.PHLightAlertMode alert) {
        this.alert = alert;
    }

    public void setEffectMode(PHLight.PHLightEffectMode effect) {
        this.effect = effect;
    }

    public void setColorMode(PHLight.PHLightColorMode mode) {
        this.colormode = mode;
    }

    public String validateState() {
        if (this.brightness != -55 && (this.brightness < 0 || this.brightness > 254)) {
            return "brightness should be a value between 0 and 254";
        }
        if (this.hue != -55 && (this.hue < 0 || this.hue > 65535)) {
            return "hue should be a value between 0 and 65535";
        }
        if (this.saturation != -55 && (this.saturation < 0 || this.saturation > 254)) {
            return "saturation should be a value between 0 and 254";
        }
        if (this.ct != -55 && (this.ct < 153 || this.ct > 500)) {
            return "color temperature should be a value between 153 and 500";
        }
        if (this.x != -55.0f && this.y == -55.0f || this.x == -55.0f && this.y != -55.0f) {
            return "x and y need both to be set";
        }
        if (this.x != -55.0f && this.y != -55.0f) {
            if (this.x < 0.0f || this.x > 1.0f) {
                return "x should be a value between 0.0 and1.0";
            }
            if (this.y < 0.0f || this.y > 1.0f) {
                return "y should be a value betwee n0.0 and1.0";
            }
        }
        if (this.alert != null && (this.alert.ordinal() < PHLight.PHLightAlertMode.ALERT_UNKNOWN.ordinal() || this.alert.ordinal() > PHLight.PHLightAlertMode.ALERT_LSELECT.ordinal())) {
            return "alert mode is invalid";
        }
        if (this.effect != null && (this.effect.ordinal() < PHLight.PHLightEffectMode.EFFECT_UNKNOWN.ordinal() || this.effect.ordinal() > PHLight.PHLightEffectMode.EFFECT_COLORLOOP.ordinal())) {
            return "effect mode is invalid";
        }
        if (this.transitionTime != -55 && (this.transitionTime < 0 || this.transitionTime > 65535)) {
            return "transition time should be a value between0 and65535";
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alert == null ? 0 : this.alert.hashCode());
        result = 31 * result + this.brightness;
        result = 31 * result + (this.colormode == null ? 0 : this.colormode.hashCode());
        result = 31 * result + this.ct;
        result = 31 * result + (this.effect == null ? 0 : this.effect.hashCode());
        result = 31 * result + this.hue;
        result = 31 * result + (this.on == null ? 0 : this.on.hashCode());
        result = 31 * result + this.saturation;
        result = 31 * result + this.transitionTime;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PHLightState)) {
            return false;
        }
        PHLightState other = (PHLightState)obj;
        if (this.alert != other.alert) {
            return false;
        }
        if (this.brightness != other.brightness) {
            return false;
        }
        if (this.colormode != other.colormode) {
            return false;
        }
        if (this.ct != other.ct) {
            return false;
        }
        if (this.effect != other.effect) {
            return false;
        }
        if (this.hue != other.hue) {
            return false;
        }
        if (this.on == null ? other.on != null : !this.on.equals(other.on)) {
            return false;
        }
        if (this.saturation != other.saturation) {
            return false;
        }
        if (this.transitionTime != other.transitionTime) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
    }
}

