/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.fuchsia.fake.discovery;

import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.chameleon.fuchsia.core.component.AbstractDiscoveryComponent;
import org.ow2.chameleon.fuchsia.core.component.DiscoveryService;
import org.ow2.chameleon.fuchsia.core.declaration.ImportDeclaration;
import org.ow2.chameleon.fuchsia.core.declaration.ImportDeclarationBuilder;
import org.ow2.chameleon.fuchsia.fake.device.GenericDevice;
import org.ow2.chameleon.fuchsia.fake.discovery.monitor.Deployer;
import org.ow2.chameleon.fuchsia.fake.discovery.monitor.DirectoryMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="Fuchsia-FakeDiscovery-Factory")
@Provides(specifications={DiscoveryService.class, Deployer.class})
@Instantiate(name="Fuchsia-FakeDiscovery")
public class FakeDiscoveryBridge
extends AbstractDiscoveryComponent
implements Deployer,
Pojo {
    private InstanceManager __IM;
    private boolean __Fname;
    @ServiceProperty(name="instance.name")
    private String name;
    private boolean __FmonitoredDirectory;
    @ServiceProperty(name="fuchsia.system.fake.discovery.directory", value="load")
    private String monitoredDirectory;
    private boolean __FpollingTime;
    @ServiceProperty(name="fuchsia.system.fake.discovery.polling", value="2000")
    private Long pollingTime;
    private boolean __FimportDeclarationsFile;
    private final HashMap<String, ImportDeclaration> importDeclarationsFile;
    private boolean __FdevicesManaged;
    private final HashMap<String, InstanceManager> devicesManaged;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MgetLogger;
    private boolean __MgetName;
    private boolean __McreateAndRegisterFakeDevice$java_lang_String;
    private boolean __McreateAndRegisterImportDeclaration$java_util_HashMap;
    private boolean __Maccept$java_io_File;
    private boolean __MparseFile$java_io_File;
    private boolean __MonFileCreate$java_io_File;
    private boolean __MonFileChange$java_io_File;
    private boolean __MonFileDelete$java_io_File;
    private boolean __Mopen$java_util_Collection;
    private boolean __Mclose;

    String __getname() {
        if (!this.__Fname) {
            return this.name;
        }
        return (String)this.__IM.onGet((Object)this, "name");
    }

    void __setname(String string) {
        if (!this.__Fname) {
            this.name = string;
            return;
        }
        this.__IM.onSet((Object)this, "name", (Object)string);
    }

    String __getmonitoredDirectory() {
        if (!this.__FmonitoredDirectory) {
            return this.monitoredDirectory;
        }
        return (String)this.__IM.onGet((Object)this, "monitoredDirectory");
    }

    void __setmonitoredDirectory(String string) {
        if (!this.__FmonitoredDirectory) {
            this.monitoredDirectory = string;
            return;
        }
        this.__IM.onSet((Object)this, "monitoredDirectory", (Object)string);
    }

    Long __getpollingTime() {
        if (!this.__FpollingTime) {
            return this.pollingTime;
        }
        return (Long)this.__IM.onGet((Object)this, "pollingTime");
    }

    void __setpollingTime(Long l) {
        if (!this.__FpollingTime) {
            this.pollingTime = l;
            return;
        }
        this.__IM.onSet((Object)this, "pollingTime", (Object)l);
    }

    HashMap __getimportDeclarationsFile() {
        if (!this.__FimportDeclarationsFile) {
            return this.importDeclarationsFile;
        }
        return (HashMap)this.__IM.onGet((Object)this, "importDeclarationsFile");
    }

    void __setimportDeclarationsFile(HashMap hashMap) {
        if (!this.__FimportDeclarationsFile) {
            this.importDeclarationsFile = hashMap;
            return;
        }
        this.__IM.onSet((Object)this, "importDeclarationsFile", (Object)hashMap);
    }

    HashMap __getdevicesManaged() {
        if (!this.__FdevicesManaged) {
            return this.devicesManaged;
        }
        return (HashMap)this.__IM.onGet((Object)this, "devicesManaged");
    }

    void __setdevicesManaged(HashMap hashMap) {
        if (!this.__FdevicesManaged) {
            this.devicesManaged = hashMap;
            return;
        }
        this.__IM.onSet((Object)this, "devicesManaged", (Object)hashMap);
    }

    public FakeDiscoveryBridge(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private FakeDiscoveryBridge(InstanceManager _manager, BundleContext bundleContext) {
        super(bundleContext);
        this._setInstanceManager(_manager);
        this.__setimportDeclarationsFile(new HashMap());
        this.__setdevicesManaged(new LinkedHashMap());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        super.start();
        try {
            new DirectoryMonitor(new File(this.__getmonitoredDirectory()), this.__getpollingTime()).start(this.getBundleContext());
            this.getLogger().info("Discovery up and running.");
        }
        catch (Exception e) {
            this.getLogger().error("Failed to start {} for the directory {} and polling time {}, with the message '{}'", (Object[])new String[]{DirectoryMonitor.class.getName(), this.__getmonitoredDirectory(), this.__getpollingTime().toString(), e.getMessage()});
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        super.stop();
        this.getLogger().info("Discovery stopped.");
    }

    public Logger getLogger() {
        Logger logger;
        if (!this.__MgetLogger) {
            return this.__M_getLogger();
        }
        try {
            this.__IM.onEntry((Object)this, "getLogger", new Object[0]);
            logger = this.__M_getLogger();
            this.__IM.onExit((Object)this, "getLogger", (Object)logger);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getLogger", throwable);
            throw throwable;
        }
        return logger;
    }

    private Logger __M_getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public String getName() {
        String string;
        if (!this.__MgetName) {
            return this.__M_getName();
        }
        try {
            this.__IM.onEntry((Object)this, "getName", new Object[0]);
            string = this.__M_getName();
            this.__IM.onExit((Object)this, "getName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getName() {
        return this.__getname();
    }

    private InstanceManager createAndRegisterFakeDevice(String deviceId) throws Exception {
        InstanceManager instanceManager;
        if (!this.__McreateAndRegisterFakeDevice$java_lang_String) {
            return this.__M_createAndRegisterFakeDevice(deviceId);
        }
        try {
            this.__IM.onEntry((Object)this, "createAndRegisterFakeDevice$java_lang_String", new Object[]{deviceId});
            instanceManager = this.__M_createAndRegisterFakeDevice(deviceId);
            this.__IM.onExit((Object)this, "createAndRegisterFakeDevice$java_lang_String", (Object)instanceManager);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createAndRegisterFakeDevice$java_lang_String", throwable);
            throw throwable;
        }
        return instanceManager;
    }

    private InstanceManager __M_createAndRegisterFakeDevice(String deviceId) throws Exception {
        try {
            Iterator i$;
            Collection factory = this.getBundleContext().getServiceReferences(Factory.class, String.format("(%s=%s)", "factory.name", "fuchsia.GenericFakeDevice"));
            if (factory.size() == 0) {
                this.getLogger().error("No {} component is available in the platform. Impossible to create a fake device.", (Object)GenericDevice.class.getName());
                throw new Exception(String.format("No %s component is available in the platform. Impossible to create a fake device.", GenericDevice.class.getName()));
            }
            if (factory.size() > 1) {
                this.getLogger().warn("Several components implementing {} were found. One will be picket randomly but this may indicate an issue.", (Object)GenericDevice.class.getName());
            }
            if ((i$ = factory.iterator()).hasNext()) {
                ServiceReference factoryServiceReference = (ServiceReference)i$.next();
                Factory deviceIpojoFactory = (Factory)this.getBundleContext().getService(factoryServiceReference);
                Hashtable<String, String> deviceProperties = new Hashtable<String, String>();
                deviceProperties.put("instance.name", "GenericDeviceInst-" + deviceId);
                deviceProperties.put("device.serialNumber", "SN-" + deviceId);
                InstanceManager deviceInstanceManager = (InstanceManager)deviceIpojoFactory.createComponentInstance(deviceProperties);
                this.__getdevicesManaged().put(deviceId, deviceInstanceManager);
                return deviceInstanceManager;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return null;
    }

    private ImportDeclaration createAndRegisterImportDeclaration(HashMap<String, Object> metadata) {
        ImportDeclaration importDeclaration;
        if (!this.__McreateAndRegisterImportDeclaration$java_util_HashMap) {
            return this.__M_createAndRegisterImportDeclaration(metadata);
        }
        try {
            this.__IM.onEntry((Object)this, "createAndRegisterImportDeclaration$java_util_HashMap", new Object[]{metadata});
            importDeclaration = this.__M_createAndRegisterImportDeclaration(metadata);
            this.__IM.onExit((Object)this, "createAndRegisterImportDeclaration$java_util_HashMap", (Object)importDeclaration);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createAndRegisterImportDeclaration$java_util_HashMap", throwable);
            throw throwable;
        }
        return importDeclaration;
    }

    private ImportDeclaration __M_createAndRegisterImportDeclaration(HashMap<String, Object> metadata) {
        ImportDeclaration declaration = (ImportDeclaration)ImportDeclarationBuilder.fromMetadata(metadata).build();
        this.registerImportDeclaration(declaration);
        return declaration;
    }

    @Override
    public boolean accept(File file) {
        boolean bl;
        if (!this.__Maccept$java_io_File) {
            return this.__M_accept(file);
        }
        try {
            this.__IM.onEntry((Object)this, "accept$java_io_File", new Object[]{file});
            bl = this.__M_accept(file);
            this.__IM.onExit((Object)this, "accept$java_io_File", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "accept$java_io_File", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_accept(File file) {
        return true;
    }

    private Properties parseFile(File file) throws Exception {
        Properties properties;
        if (!this.__MparseFile$java_io_File) {
            return this.__M_parseFile(file);
        }
        try {
            this.__IM.onEntry((Object)this, "parseFile$java_io_File", new Object[]{file});
            properties = this.__M_parseFile(file);
            this.__IM.onExit((Object)this, "parseFile$java_io_File", (Object)properties);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "parseFile$java_io_File", throwable);
            throw throwable;
        }
        return properties;
    }

    private Properties __M_parseFile(File file) throws Exception {
        Properties deviceReificationProperties = new Properties();
        try {
            FileInputStream is = new FileInputStream(file);
            deviceReificationProperties.load(is);
        }
        catch (Exception e) {
            throw new Exception(String.format("Error reading file that represents a device. %s", file.getAbsoluteFile()));
        }
        if (!(deviceReificationProperties.containsKey("id") && deviceReificationProperties.containsKey("deviceType") && deviceReificationProperties.containsKey("deviceSubType"))) {
            throw new Exception(String.format("File cannot represent a device since it does not contain the information base to work as such", file.getAbsoluteFile()));
        }
        return deviceReificationProperties;
    }

    @Override
    public void onFileCreate(File file) {
        if (!this.__MonFileCreate$java_io_File) {
            this.__M_onFileCreate(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "onFileCreate$java_io_File", new Object[]{file});
            this.__M_onFileCreate(file);
            this.__IM.onExit((Object)this, "onFileCreate$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "onFileCreate$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_onFileCreate(File file) {
        this.getLogger().info("File created {}", (Object)file.getAbsolutePath());
        try {
            Properties deviceReificationProperties = this.parseFile(file);
            String deviceId = deviceReificationProperties.getProperty("id");
            this.createAndRegisterFakeDevice(deviceId);
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("id", deviceId);
            for (Map.Entry<Object, Object> element : deviceReificationProperties.entrySet()) {
                Object replacedObject = metadata.put(element.getKey().toString(), element.getValue());
                if (replacedObject == null) continue;
                this.getLogger().warn("ImportationDeclaration: replacing metadata key {}, that contained the value {} by the new value {}", new Object[]{element.getKey(), replacedObject, element.getValue()});
            }
            ImportDeclaration declaration = this.createAndRegisterImportDeclaration(metadata);
            this.__getimportDeclarationsFile().put(file.getAbsolutePath(), declaration);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage());
        }
    }

    @Override
    public void onFileChange(File file) {
        if (!this.__MonFileChange$java_io_File) {
            this.__M_onFileChange(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "onFileChange$java_io_File", new Object[]{file});
            this.__M_onFileChange(file);
            this.__IM.onExit((Object)this, "onFileChange$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "onFileChange$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_onFileChange(File file) {
        this.getLogger().info("File updated {}", (Object)file.getAbsolutePath());
        this.onFileDelete(file);
        this.onFileCreate(file);
    }

    @Override
    public void onFileDelete(File file) {
        if (!this.__MonFileDelete$java_io_File) {
            this.__M_onFileDelete(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "onFileDelete$java_io_File", new Object[]{file});
            this.__M_onFileDelete(file);
            this.__IM.onExit((Object)this, "onFileDelete$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "onFileDelete$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_onFileDelete(File file) {
        this.getLogger().info("File removed {}", (Object)file.getAbsolutePath());
        ImportDeclaration declaration = (ImportDeclaration)this.__getimportDeclarationsFile().get(file.getAbsolutePath());
        if (this.__getimportDeclarationsFile().remove(file.getAbsolutePath()) == null) {
            this.getLogger().error("Failed to unregister device-file mapping ({}),  it did not existed before.", (Object)file.getAbsolutePath());
        } else {
            this.getLogger().info("Device-file mapping removed.");
        }
        try {
            this.unregisterImportDeclaration(declaration);
        }
        catch (IllegalStateException e) {
            this.getLogger().error("Failed to unregister import declaration for the device {},  it did not existed before.", (Object)declaration.getMetadata());
        }
        try {
            String deviceId = (String)declaration.getMetadata().get("id");
            ((InstanceManager)this.__getdevicesManaged().get(deviceId)).dispose();
        }
        catch (NullPointerException e) {
            this.getLogger().error("Failed to disconnect device {}, this device was not registered by this discovery", (Object)((String)declaration.getMetadata().get("id")));
        }
    }

    @Override
    public void open(Collection<File> files) {
        if (!this.__Mopen$java_util_Collection) {
            this.__M_open(files);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "open$java_util_Collection", new Object[]{files});
            this.__M_open(files);
            this.__IM.onExit((Object)this, "open$java_util_Collection", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "open$java_util_Collection", throwable);
            throw throwable;
        }
    }

    private void __M_open(Collection<File> files) {
        for (File file : files) {
            this.onFileChange(file);
        }
    }

    @Override
    public void close() {
        if (!this.__Mclose) {
            this.__M_close();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "close", new Object[0]);
            this.__M_close();
            this.__IM.onExit((Object)this, "close", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "close", throwable);
            throw throwable;
        }
    }

    private void __M_close() {
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("devicesManaged")) {
                this.__FdevicesManaged = true;
            }
            if (set.contains("importDeclarationsFile")) {
                this.__FimportDeclarationsFile = true;
            }
            if (set.contains("monitoredDirectory")) {
                this.__FmonitoredDirectory = true;
            }
            if (set.contains("name")) {
                this.__Fname = true;
            }
            if (set.contains("pollingTime")) {
                this.__FpollingTime = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getLogger")) {
                this.__MgetLogger = true;
            }
            if (set.contains("getName")) {
                this.__MgetName = true;
            }
            if (set.contains("createAndRegisterFakeDevice$java_lang_String")) {
                this.__McreateAndRegisterFakeDevice$java_lang_String = true;
            }
            if (set.contains("createAndRegisterImportDeclaration$java_util_HashMap")) {
                this.__McreateAndRegisterImportDeclaration$java_util_HashMap = true;
            }
            if (set.contains("accept$java_io_File")) {
                this.__Maccept$java_io_File = true;
            }
            if (set.contains("parseFile$java_io_File")) {
                this.__MparseFile$java_io_File = true;
            }
            if (set.contains("onFileCreate$java_io_File")) {
                this.__MonFileCreate$java_io_File = true;
            }
            if (set.contains("onFileChange$java_io_File")) {
                this.__MonFileChange$java_io_File = true;
            }
            if (set.contains("onFileDelete$java_io_File")) {
                this.__MonFileDelete$java_io_File = true;
            }
            if (set.contains("open$java_util_Collection")) {
                this.__Mopen$java_util_Collection = true;
            }
            if (set.contains("close")) {
                this.__Mclose = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

