/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.fuchsia.mdns.discovery;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Set;
import javax.jmdns.JmDNS;
import javax.jmdns.NetworkTopologyDiscovery;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceListener;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.BundleContext;
import org.ow2.chameleon.fuchsia.core.component.AbstractDiscoveryComponent;
import org.ow2.chameleon.fuchsia.core.component.DiscoveryService;
import org.ow2.chameleon.fuchsia.core.declaration.ImportDeclaration;
import org.ow2.chameleon.fuchsia.core.declaration.ImportDeclarationBuilder;
import org.ow2.chameleon.fuchsia.mdns.discovery.topology.NetworkTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="DNSSDDiscoveryFactory")
@Provides(specifications={DiscoveryService.class})
public class DNSSDDiscoveryImpl
extends AbstractDiscoveryComponent
implements NetworkTopologyDiscovery.Factory.ClassDelegate,
ServiceListener,
Pojo {
    private InstanceManager __IM;
    private boolean __FimportDeclarations;
    private final HashMap<String, ImportDeclaration> importDeclarations;
    private boolean __FdnssdServiceType;
    @Property(name="dnssd.service.type", value="_http._tcp.local.")
    private String dnssdServiceType;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MnewNetworkTopologyDiscovery;
    private boolean __MserviceAdded$javax_jmdns_ServiceEvent;
    private boolean __MserviceRemoved$javax_jmdns_ServiceEvent;
    private boolean __MserviceResolved$javax_jmdns_ServiceEvent;
    private boolean __MgetName;
    private boolean __McreateImportationDeclaration$javax_jmdns_ServiceEvent;
    private boolean __MconfigureNetworkCardServiceListener;
    private boolean __MgetLogger;

    HashMap __getimportDeclarations() {
        if (!this.__FimportDeclarations) {
            return this.importDeclarations;
        }
        return (HashMap)this.__IM.onGet((Object)this, "importDeclarations");
    }

    void __setimportDeclarations(HashMap hashMap) {
        if (!this.__FimportDeclarations) {
            this.importDeclarations = hashMap;
            return;
        }
        this.__IM.onSet((Object)this, "importDeclarations", (Object)hashMap);
    }

    String __getdnssdServiceType() {
        if (!this.__FdnssdServiceType) {
            return this.dnssdServiceType;
        }
        return (String)this.__IM.onGet((Object)this, "dnssdServiceType");
    }

    void __setdnssdServiceType(String string) {
        if (!this.__FdnssdServiceType) {
            this.dnssdServiceType = string;
            return;
        }
        this.__IM.onSet((Object)this, "dnssdServiceType", (Object)string);
    }

    protected DNSSDDiscoveryImpl(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private DNSSDDiscoveryImpl(InstanceManager _manager, BundleContext bundleContext) {
        super(bundleContext);
        this._setInstanceManager(_manager);
        this.__setimportDeclarations(new HashMap());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        NetworkTopologyDiscovery.Factory.setClassDelegate((NetworkTopologyDiscovery.Factory.ClassDelegate)this);
        this.configureNetworkCardServiceListener();
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        this.getLogger().info("stopping service of mDNS/DNSsd discovery");
        for (ImportDeclaration declaration : this.__getimportDeclarations().values()) {
            super.unregisterImportDeclaration(declaration);
        }
    }

    public NetworkTopologyDiscovery newNetworkTopologyDiscovery() {
        NetworkTopologyDiscovery networkTopologyDiscovery;
        if (!this.__MnewNetworkTopologyDiscovery) {
            return this.__M_newNetworkTopologyDiscovery();
        }
        try {
            this.__IM.onEntry((Object)this, "newNetworkTopologyDiscovery", new Object[0]);
            networkTopologyDiscovery = this.__M_newNetworkTopologyDiscovery();
            this.__IM.onExit((Object)this, "newNetworkTopologyDiscovery", (Object)networkTopologyDiscovery);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "newNetworkTopologyDiscovery", throwable);
            throw throwable;
        }
        return networkTopologyDiscovery;
    }

    private NetworkTopologyDiscovery __M_newNetworkTopologyDiscovery() {
        return new NetworkTopology();
    }

    public void serviceAdded(ServiceEvent event) {
        if (!this.__MserviceAdded$javax_jmdns_ServiceEvent) {
            this.__M_serviceAdded(event);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "serviceAdded$javax_jmdns_ServiceEvent", new Object[]{event});
            this.__M_serviceAdded(event);
            this.__IM.onExit((Object)this, "serviceAdded$javax_jmdns_ServiceEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "serviceAdded$javax_jmdns_ServiceEvent", throwable);
            throw throwable;
        }
    }

    private void __M_serviceAdded(ServiceEvent event) {
        this.getLogger().info("adding declaration for the mDNS/DNSsd service {}", (Object)event.getName());
        this.createImportationDeclaration(event);
    }

    public void serviceRemoved(ServiceEvent event) {
        if (!this.__MserviceRemoved$javax_jmdns_ServiceEvent) {
            this.__M_serviceRemoved(event);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "serviceRemoved$javax_jmdns_ServiceEvent", new Object[]{event});
            this.__M_serviceRemoved(event);
            this.__IM.onExit((Object)this, "serviceRemoved$javax_jmdns_ServiceEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "serviceRemoved$javax_jmdns_ServiceEvent", throwable);
            throw throwable;
        }
    }

    private void __M_serviceRemoved(ServiceEvent event) {
        this.getLogger().info("removing declaration for the mDNS/DNSsd service {}", (Object)event.getName());
        ImportDeclaration declaration = (ImportDeclaration)this.__getimportDeclarations().remove(event.getName());
        if (declaration != null) {
            this.unregisterImportDeclaration(declaration);
            this.getLogger().info("import declaration removed for the mDNS/DNSsd service {}", (Object)event.getName());
        } else {
            this.getLogger().info("Impossible to remove declaration {}, it was not registered by the discovery", (Object)event.getName());
        }
    }

    public void serviceResolved(ServiceEvent event) {
        if (!this.__MserviceResolved$javax_jmdns_ServiceEvent) {
            this.__M_serviceResolved(event);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "serviceResolved$javax_jmdns_ServiceEvent", new Object[]{event});
            this.__M_serviceResolved(event);
            this.__IM.onExit((Object)this, "serviceResolved$javax_jmdns_ServiceEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "serviceResolved$javax_jmdns_ServiceEvent", throwable);
            throw throwable;
        }
    }

    private void __M_serviceResolved(ServiceEvent event) {
        this.getLogger().info("resolving declaration for the mDNS/DNSsd service {}", (Object)event.getName());
        this.getLogger().warn("no action implemented for this kind of event");
    }

    public String getName() {
        String string;
        if (!this.__MgetName) {
            return this.__M_getName();
        }
        try {
            this.__IM.onEntry((Object)this, "getName", new Object[0]);
            string = this.__M_getName();
            this.__IM.onExit((Object)this, "getName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getName() {
        return "mDNSDiscovery";
    }

    private synchronized void createImportationDeclaration(ServiceEvent event) {
        if (!this.__McreateImportationDeclaration$javax_jmdns_ServiceEvent) {
            this.__M_createImportationDeclaration(event);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createImportationDeclaration$javax_jmdns_ServiceEvent", new Object[]{event});
            this.__M_createImportationDeclaration(event);
            this.__IM.onExit((Object)this, "createImportationDeclaration$javax_jmdns_ServiceEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createImportationDeclaration$javax_jmdns_ServiceEvent", throwable);
            throw throwable;
        }
    }

    private void __M_createImportationDeclaration(ServiceEvent event) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("id", event.getName());
        metadata.put("discovery.mdns.device.name", event.getName());
        ImportDeclaration declaration = (ImportDeclaration)ImportDeclarationBuilder.fromMetadata(metadata).build();
        this.registerImportDeclaration(declaration);
        this.__getimportDeclarations().put(event.getName(), declaration);
    }

    private void configureNetworkCardServiceListener() {
        if (!this.__MconfigureNetworkCardServiceListener) {
            this.__M_configureNetworkCardServiceListener();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configureNetworkCardServiceListener", new Object[0]);
            this.__M_configureNetworkCardServiceListener();
            this.__IM.onExit((Object)this, "configureNetworkCardServiceListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configureNetworkCardServiceListener", throwable);
            throw throwable;
        }
    }

    private void __M_configureNetworkCardServiceListener() {
        for (InetAddress address : NetworkTopologyDiscovery.Factory.getInstance().getInetAddresses()) {
            try {
                JmDNS current = JmDNS.create((InetAddress)address);
                current.addServiceListener(this.__getdnssdServiceType(), (ServiceListener)this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Logger getLogger() {
        Logger logger;
        if (!this.__MgetLogger) {
            return this.__M_getLogger();
        }
        try {
            this.__IM.onEntry((Object)this, "getLogger", new Object[0]);
            logger = this.__M_getLogger();
            this.__IM.onExit((Object)this, "getLogger", (Object)logger);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getLogger", throwable);
            throw throwable;
        }
        return logger;
    }

    private Logger __M_getLogger() {
        return LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("dnssdServiceType")) {
                this.__FdnssdServiceType = true;
            }
            if (set.contains("importDeclarations")) {
                this.__FimportDeclarations = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("newNetworkTopologyDiscovery")) {
                this.__MnewNetworkTopologyDiscovery = true;
            }
            if (set.contains("serviceAdded$javax_jmdns_ServiceEvent")) {
                this.__MserviceAdded$javax_jmdns_ServiceEvent = true;
            }
            if (set.contains("serviceRemoved$javax_jmdns_ServiceEvent")) {
                this.__MserviceRemoved$javax_jmdns_ServiceEvent = true;
            }
            if (set.contains("serviceResolved$javax_jmdns_ServiceEvent")) {
                this.__MserviceResolved$javax_jmdns_ServiceEvent = true;
            }
            if (set.contains("getName")) {
                this.__MgetName = true;
            }
            if (set.contains("createImportationDeclaration$javax_jmdns_ServiceEvent")) {
                this.__McreateImportationDeclaration$javax_jmdns_ServiceEvent = true;
            }
            if (set.contains("configureNetworkCardServiceListener")) {
                this.__MconfigureNetworkCardServiceListener = true;
            }
            if (set.contains("getLogger")) {
                this.__MgetLogger = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

