/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.fuchsia.exporter.cxf;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.ow2.chameleon.fuchsia.core.FuchsiaUtils;
import org.ow2.chameleon.fuchsia.core.component.AbstractExporterComponent;
import org.ow2.chameleon.fuchsia.core.component.ExporterService;
import org.ow2.chameleon.fuchsia.core.declaration.ExportDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="CxfExporterFactory")
@Provides(specifications={ExporterService.class})
public class CxfExporterFactory
extends AbstractExporterComponent
implements Pojo {
    private InstanceManager __IM;
    private boolean __Fcxfbus;
    private Bus cxfbus;
    private boolean __Fcontext;
    private BundleContext context;
    private boolean __Flogger;
    private Logger logger;
    private boolean __FexportedDeclaration;
    private Map<String, Server> exportedDeclaration;
    private boolean __Fhttp;
    @Requires
    HttpService http;
    private boolean __Ffilter;
    @ServiceProperty(name="target")
    private String filter;
    private boolean __MuseExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration;
    private boolean __MdenyExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration;
    private boolean __MgetName;
    private boolean __Mstart;
    private boolean __Mstop;

    Bus __getcxfbus() {
        if (!this.__Fcxfbus) {
            return this.cxfbus;
        }
        return (Bus)this.__IM.onGet((Object)this, "cxfbus");
    }

    void __setcxfbus(Bus bus) {
        if (!this.__Fcxfbus) {
            this.cxfbus = bus;
            return;
        }
        this.__IM.onSet((Object)this, "cxfbus", (Object)bus);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    Map __getexportedDeclaration() {
        if (!this.__FexportedDeclaration) {
            return this.exportedDeclaration;
        }
        return (Map)this.__IM.onGet((Object)this, "exportedDeclaration");
    }

    void __setexportedDeclaration(Map map) {
        if (!this.__FexportedDeclaration) {
            this.exportedDeclaration = map;
            return;
        }
        this.__IM.onSet((Object)this, "exportedDeclaration", (Object)map);
    }

    HttpService __gethttp() {
        if (!this.__Fhttp) {
            return this.http;
        }
        return (HttpService)this.__IM.onGet((Object)this, "http");
    }

    void __sethttp(HttpService httpService) {
        if (!this.__Fhttp) {
            this.http = httpService;
            return;
        }
        this.__IM.onSet((Object)this, "http", (Object)httpService);
    }

    String __getfilter() {
        if (!this.__Ffilter) {
            return this.filter;
        }
        return (String)this.__IM.onGet((Object)this, "filter");
    }

    void __setfilter(String string) {
        if (!this.__Ffilter) {
            this.filter = string;
            return;
        }
        this.__IM.onSet((Object)this, "filter", (Object)string);
    }

    public CxfExporterFactory(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private CxfExporterFactory(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__setlogger(LoggerFactory.getLogger(((Object)((Object)this)).getClass()));
        this.__setexportedDeclaration(new HashMap());
        this.__setcontext(context);
    }

    public void useExportDeclaration(ExportDeclaration exportDeclaration) {
        if (!this.__MuseExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration) {
            this.__M_useExportDeclaration(exportDeclaration);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "useExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration", new Object[]{exportDeclaration});
            this.__M_useExportDeclaration(exportDeclaration);
            this.__IM.onExit((Object)this, "useExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "useExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration", throwable);
            throw throwable;
        }
    }

    private void __M_useExportDeclaration(ExportDeclaration exportDeclaration) {
        System.out.println("trying to export");
        String classname = (String)exportDeclaration.getMetadata().get("fuchsia.export.cxf.class.name");
        String webcontext = (String)exportDeclaration.getMetadata().get("fuchsia.export.cxf.url.context");
        Object instance = exportDeclaration.getMetadata().get("fuchsia.export.cxf.instance");
        try {
            ServerFactoryBean srvFactory = new ServerFactoryBean();
            Class ref = FuchsiaUtils.loadClass((BundleContext)this.__getcontext(), (String)classname);
            srvFactory.setServiceClass(ref);
            srvFactory.setBus(this.__getcxfbus());
            srvFactory.setServiceBean(instance);
            srvFactory.setAddress(webcontext);
            Server endpoint = srvFactory.create();
            this.__getexportedDeclaration().put(webcontext, endpoint);
            this.__getlogger().info("Pushing CXF endpoint: {}", (Object)endpoint.getEndpoint().getEndpointInfo().getAddress());
        }
        catch (Exception e) {
            this.__getlogger().error("Failed exporting in CXF, with the message {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    protected void denyExportDeclaration(ExportDeclaration exportDeclaration) {
        if (!this.__MdenyExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration) {
            this.__M_denyExportDeclaration(exportDeclaration);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "denyExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration", new Object[]{exportDeclaration});
            this.__M_denyExportDeclaration(exportDeclaration);
            this.__IM.onExit((Object)this, "denyExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "denyExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration", throwable);
            throw throwable;
        }
    }

    private void __M_denyExportDeclaration(ExportDeclaration exportDeclaration) {
        System.out.println("trying to unexport");
        String webcontext = (String)exportDeclaration.getMetadata().get("fuchsia.export.cxf.url.context");
        Server exported = (Server)this.__getexportedDeclaration().get(webcontext);
        if (exported != null) {
            exported.destroy();
            this.__getlogger().info("Endpoint destroyed: {}", (Object)webcontext);
        } else {
            this.__getlogger().warn("Error destroying endpoint {}, is was not registered before.", (Object)webcontext);
        }
    }

    public String getName() {
        String string;
        if (!this.__MgetName) {
            return this.__M_getName();
        }
        try {
            this.__IM.onEntry((Object)this, "getName", new Object[0]);
            string = this.__M_getName();
            this.__IM.onExit((Object)this, "getName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        System.setProperty("org.apache.cxf.nofastinfoset", "true");
        CXFNonSpringServlet cxfServlet = new CXFNonSpringServlet();
        try {
            this.__gethttp().registerServlet("/cxf", (Servlet)cxfServlet, null, null);
        }
        catch (ServletException e) {
            this.__getlogger().error("Failed registering CXF servlet, with the message {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        catch (NamespaceException e) {
            this.__getlogger().error("Failed registering CXF servlet, with the message {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        this.__setcxfbus(cxfServlet.getBus());
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        this.__gethttp().unregister("/cxf");
        for (Map.Entry item : this.__getexportedDeclaration().entrySet()) {
            ((Server)item.getValue()).destroy();
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("cxfbus")) {
                this.__Fcxfbus = true;
            }
            if (set.contains("exportedDeclaration")) {
                this.__FexportedDeclaration = true;
            }
            if (set.contains("filter")) {
                this.__Ffilter = true;
            }
            if (set.contains("http")) {
                this.__Fhttp = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("useExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration")) {
                this.__MuseExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration = true;
            }
            if (set.contains("denyExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration")) {
                this.__MdenyExportDeclaration$org_ow2_chameleon_fuchsia_core_declaration_ExportDeclaration = true;
            }
            if (set.contains("getName")) {
                this.__MgetName = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

