/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.fuchsia.pubsubhub.hub.dto;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.ow2.chameleon.fuchsia.pubsubhub.hub.exception.InvalidContentNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentNotification {
    private String mode;
    private String url;

    public ContentNotification(String mode, String url) {
        this.mode = mode;
        this.url = url;
    }

    public static ContentNotification from(HttpServletRequest request) throws InvalidContentNotification {
        ContentNotification.validateRequest(request);
        ContentNotification cn = new ContentNotification(request.getParameter("hub.mode"), request.getParameter("hub.url"));
        return cn;
    }

    public List<NameValuePair> toRequesParameters() {
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        nvps.add((NameValuePair)new BasicNameValuePair("hub.mode", this.getMode()));
        nvps.add((NameValuePair)new BasicNameValuePair("hub.url", this.getUrl()));
        return nvps;
    }

    public String getMode() {
        return this.mode;
    }

    public String getUrl() {
        return this.url;
    }

    private static void validateRequest(HttpServletRequest request) throws InvalidContentNotification {
        if (!request.getContentType().equals("application/x-www-form-urlencoded")) {
            throw new InvalidContentNotification("Invalid content type");
        }
        if (request.getParameter("hub.mode") == null) {
            throw new InvalidContentNotification("No hub.mode provided");
        }
        if (request.getParameter("hub.url") == null) {
            throw new InvalidContentNotification("No hub.url provided");
        }
    }
}

