/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.fuchsia.pubsubhub.hub.dto;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.ow2.chameleon.fuchsia.pubsubhub.hub.exception.InvalidContentNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionConfirmationRequest {
    private final String mode;
    private final String topic;
    private final String challenge;
    private final String lease;

    public SubscriptionConfirmationRequest(String mode, String topic, String challenge, String lease) {
        this.mode = mode;
        this.topic = topic;
        this.challenge = challenge;
        this.lease = lease;
    }

    public static SubscriptionConfirmationRequest from(HttpServletRequest request) throws InvalidContentNotification {
        SubscriptionConfirmationRequest.validateRequest(request);
        return new SubscriptionConfirmationRequest(request.getParameter("hub.mode"), request.getParameter("hub.topic"), request.getParameter("hub.challenge"), request.getParameter("hub.lease_seconds"));
    }

    private static void validateRequest(HttpServletRequest request) throws InvalidContentNotification {
        if (request.getParameter("hub.mode") == null || request.getParameter("hub.topic") == null || request.getParameter("hub.challenge") == null || request.getParameter("hub.lease_seconds") == null) {
            throw new InvalidContentNotification("No enough information provided");
        }
    }

    public List<NameValuePair> toRequestParameters() {
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        nvps.add((NameValuePair)new BasicNameValuePair("hub.mode", this.getMode()));
        nvps.add((NameValuePair)new BasicNameValuePair("hub.topic", this.getTopic()));
        nvps.add((NameValuePair)new BasicNameValuePair("hub.challenge", this.getChallenge()));
        nvps.add((NameValuePair)new BasicNameValuePair("hub.lease_seconds", this.getLease()));
        return nvps;
    }

    public String getMode() {
        return this.mode;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String getLease() {
        return this.lease;
    }
}

