/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.fuchsia.pubsubhub.hub.dto;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.ow2.chameleon.fuchsia.pubsubhub.hub.exception.InvalidContentNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionRequest {
    String callback;
    String mode;
    String topic;
    String verify;

    public SubscriptionRequest(String callback, String mode, String topic, String verify) {
        this.callback = callback;
        this.mode = mode;
        this.topic = topic;
        this.verify = verify;
    }

    public static SubscriptionRequest from(HttpServletRequest request) throws InvalidContentNotification {
        SubscriptionRequest.validateRequest(request);
        SubscriptionRequest sr = new SubscriptionRequest(request.getParameter("hub.callback"), request.getParameter("hub.mode"), request.getParameter("hub.topic"), request.getParameter("hub.verify"));
        return sr;
    }

    public List<NameValuePair> toRequestParameters() {
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        nvps.add((NameValuePair)new BasicNameValuePair("hub.callback", this.getCallback()));
        nvps.add((NameValuePair)new BasicNameValuePair("hub.mode", this.getMode()));
        nvps.add((NameValuePair)new BasicNameValuePair("hub.topic", this.getTopic()));
        nvps.add((NameValuePair)new BasicNameValuePair("hub.verify", this.getVerify()));
        return nvps;
    }

    private static void validateRequest(HttpServletRequest request) throws InvalidContentNotification {
        if (request.getParameter("hub.callback") == null || request.getParameter("hub.mode") == null || request.getParameter("hub.topic") == null || request.getParameter("hub.verify") == null) {
            throw new InvalidContentNotification("Parameters requested not defined in the request");
        }
    }

    public String getCallback() {
        return this.callback;
    }

    public String getMode() {
        return this.mode;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getVerify() {
        return this.verify;
    }
}

