/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.fuchsia.pubsubhub.hub.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.ow2.chameleon.fuchsia.pubsubhub.hub.Hub;
import org.ow2.chameleon.fuchsia.pubsubhub.hub.dto.ContentNotification;
import org.ow2.chameleon.fuchsia.pubsubhub.hub.dto.SubscriptionConfirmationRequest;
import org.ow2.chameleon.fuchsia.pubsubhub.hub.dto.SubscriptionRequest;
import org.ow2.chameleon.fuchsia.pubsubhub.hub.exception.SubscriptionException;
import org.ow2.chameleon.fuchsia.pubsubhub.hub.exception.SubscriptionOriginVerificationException;
import org.ow2.chameleon.fuchsia.pubsubhub.hub.servlet.ContentUpdatedNotificationServlet;
import org.ow2.chameleon.fuchsia.pubsubhub.hub.servlet.SubscriptionServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="PuSHHubFactory")
public class HubImpl
implements Hub,
Pojo {
    private InstanceManager __IM;
    private boolean __Fhttp;
    @Requires
    HttpService http;
    private boolean __Fcontext;
    BundleContext context;
    private boolean __FtopicCallbackSubscriptionMap;
    Map<String, List<String>> topicCallbackSubscriptionMap;
    private boolean __Flogger;
    private final Logger logger;
    private boolean __Mstart;
    private boolean __MContentNotificationReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification;
    private boolean __MSubscriptionRequestReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest;
    private boolean __MVerifySubscriberRequestedSubscription$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest;
    private boolean __MNotifySubscriberCallback$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification;
    private boolean __MaddCallbackToTopic$java_lang_String$java_lang_String;
    private boolean __MremoveCallbackToTopic$java_lang_String$java_lang_String;
    private boolean __MfetchContentFromPublisher$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification;
    private boolean __MdistributeContentToSubscribers$java_lang_String$java_lang_String;

    HttpService __gethttp() {
        if (!this.__Fhttp) {
            return this.http;
        }
        return (HttpService)this.__IM.onGet((Object)this, "http");
    }

    void __sethttp(HttpService httpService) {
        if (!this.__Fhttp) {
            this.http = httpService;
            return;
        }
        this.__IM.onSet((Object)this, "http", (Object)httpService);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    Map __gettopicCallbackSubscriptionMap() {
        if (!this.__FtopicCallbackSubscriptionMap) {
            return this.topicCallbackSubscriptionMap;
        }
        return (Map)this.__IM.onGet((Object)this, "topicCallbackSubscriptionMap");
    }

    void __settopicCallbackSubscriptionMap(Map map) {
        if (!this.__FtopicCallbackSubscriptionMap) {
            this.topicCallbackSubscriptionMap = map;
            return;
        }
        this.__IM.onSet((Object)this, "topicCallbackSubscriptionMap", (Object)map);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    public HubImpl() {
        this((InstanceManager)null);
    }

    private HubImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__settopicCallbackSubscriptionMap(new HashMap());
        this.__setlogger(LoggerFactory.getLogger(this.getClass()));
    }

    public HubImpl(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private HubImpl(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__settopicCallbackSubscriptionMap(new HashMap());
        this.__setlogger(LoggerFactory.getLogger(this.getClass()));
        this.__setcontext(context);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        try {
            this.__gethttp().registerServlet("/hub/subscribe", (Servlet)new SubscriptionServlet(this), null, null);
            this.__gethttp().registerServlet("/hub/main", (Servlet)new ContentUpdatedNotificationServlet(this), null, null);
            this.__getlogger().info("Hub started.");
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        catch (NamespaceException e) {
            e.printStackTrace();
        }
    }

    public void ContentNotificationReceived(ContentNotification cn) {
        if (!this.__MContentNotificationReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification) {
            this.__M_ContentNotificationReceived(cn);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "ContentNotificationReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification", new Object[]{cn});
            this.__M_ContentNotificationReceived(cn);
            this.__IM.onExit((Object)this, "ContentNotificationReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "ContentNotificationReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification", throwable);
            throw throwable;
        }
    }

    private void __M_ContentNotificationReceived(ContentNotification cn) {
        this.__getlogger().info("Publisher -> (Hub), notification of new content available for the topic {}.", (Object)cn.getUrl());
        this.NotifySubscriberCallback(cn);
    }

    public void SubscriptionRequestReceived(SubscriptionRequest sr) throws SubscriptionException {
        if (!this.__MSubscriptionRequestReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest) {
            this.__M_SubscriptionRequestReceived(sr);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "SubscriptionRequestReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest", new Object[]{sr});
            this.__M_SubscriptionRequestReceived(sr);
            this.__IM.onExit((Object)this, "SubscriptionRequestReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "SubscriptionRequestReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest", throwable);
            throw throwable;
        }
    }

    private void __M_SubscriptionRequestReceived(SubscriptionRequest sr) throws SubscriptionException {
        this.__getlogger().info("Subscriber -> (Hub), new subscription request received.", (Object)sr.getCallback());
        try {
            this.VerifySubscriberRequestedSubscription(sr);
            if (sr.getMode().equals("subscribe")) {
                this.__getlogger().info("Adding callback {} to the topic {}", (Object)sr.getCallback(), (Object)sr.getTopic());
                this.addCallbackToTopic(sr.getCallback(), sr.getTopic());
            } else if (sr.getMode().equals("unsubscribe")) {
                this.__getlogger().info("Removing callback {} from the topic {}", (Object)sr.getCallback(), (Object)sr.getTopic());
                this.removeCallbackToTopic(sr.getCallback(), sr.getTopic());
            }
        }
        catch (Exception e) {
            throw new SubscriptionException(e);
        }
    }

    public Boolean VerifySubscriberRequestedSubscription(SubscriptionRequest sr) throws SubscriptionOriginVerificationException, URISyntaxException, IOException {
        Boolean bl;
        if (!this.__MVerifySubscriberRequestedSubscription$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest) {
            return this.__M_VerifySubscriberRequestedSubscription(sr);
        }
        try {
            this.__IM.onEntry((Object)this, "VerifySubscriberRequestedSubscription$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest", new Object[]{sr});
            bl = this.__M_VerifySubscriberRequestedSubscription(sr);
            this.__IM.onExit((Object)this, "VerifySubscriberRequestedSubscription$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest", (Object)bl);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "VerifySubscriberRequestedSubscription$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest", throwable);
            throw throwable;
        }
        return bl;
    }

    private Boolean __M_VerifySubscriberRequestedSubscription(SubscriptionRequest sr) throws SubscriptionOriginVerificationException, URISyntaxException, IOException {
        this.__getlogger().info("(Hub) -> Subscriber, sending notification to verify the origin of the subscription {}.", (Object)sr.getCallback());
        SubscriptionConfirmationRequest sc = new SubscriptionConfirmationRequest(sr.getMode(), sr.getTopic(), "challenge", "0");
        URI uri = new URIBuilder(sr.getCallback()).setParameters(sc.toRequestParameters()).build();
        HttpGet httpGet = new HttpGet(uri);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse response1 = httpclient.execute((HttpUriRequest)httpGet);
        this.__getlogger().info("Subscriber replied with the http code {}.", (Object)response1.getStatusLine().getStatusCode());
        Integer returnedCode = response1.getStatusLine().getStatusCode();
        if (returnedCode > 199 && returnedCode < 300) {
            return true;
        }
        return false;
    }

    public void NotifySubscriberCallback(ContentNotification cn) {
        if (!this.__MNotifySubscriberCallback$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification) {
            this.__M_NotifySubscriberCallback(cn);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "NotifySubscriberCallback$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification", new Object[]{cn});
            this.__M_NotifySubscriberCallback(cn);
            this.__IM.onExit((Object)this, "NotifySubscriberCallback$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "NotifySubscriberCallback$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification", throwable);
            throw throwable;
        }
    }

    private void __M_NotifySubscriberCallback(ContentNotification cn) {
        String content = this.fetchContentFromPublisher(cn);
        this.distributeContentToSubscribers(content, cn.getUrl());
    }

    private void addCallbackToTopic(String callback, String topic) {
        if (!this.__MaddCallbackToTopic$java_lang_String$java_lang_String) {
            this.__M_addCallbackToTopic(callback, topic);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addCallbackToTopic$java_lang_String$java_lang_String", new Object[]{callback, topic});
            this.__M_addCallbackToTopic(callback, topic);
            this.__IM.onExit((Object)this, "addCallbackToTopic$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addCallbackToTopic$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_addCallbackToTopic(String callback, String topic) {
        ArrayList<String> callbacks = (ArrayList<String>)this.__gettopicCallbackSubscriptionMap().get(topic);
        if (callbacks == null) {
            callbacks = new ArrayList<String>();
            this.__gettopicCallbackSubscriptionMap().put(topic, callbacks);
        }
        callbacks.add(callback);
    }

    private void removeCallbackToTopic(String callback, String topic) {
        if (!this.__MremoveCallbackToTopic$java_lang_String$java_lang_String) {
            this.__M_removeCallbackToTopic(callback, topic);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeCallbackToTopic$java_lang_String$java_lang_String", new Object[]{callback, topic});
            this.__M_removeCallbackToTopic(callback, topic);
            this.__IM.onExit((Object)this, "removeCallbackToTopic$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeCallbackToTopic$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_removeCallbackToTopic(String callback, String topic) {
        Boolean removedFromList;
        ArrayList callbacks = (ArrayList)this.__gettopicCallbackSubscriptionMap().get(topic);
        if (callbacks == null) {
            callbacks = new ArrayList();
            this.__gettopicCallbackSubscriptionMap().put(topic, callbacks);
        }
        if ((removedFromList = Boolean.valueOf(callbacks.remove(callback))).booleanValue()) {
            this.__getlogger().info("Hub, callback {} removed from the topic {}", (Object)callback, (Object)topic);
        } else {
            this.__getlogger().info("Hub, callback {} was not present for the topic {}", (Object)callback, (Object)topic);
        }
    }

    private String fetchContentFromPublisher(ContentNotification cn) {
        String string;
        if (!this.__MfetchContentFromPublisher$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification) {
            return this.__M_fetchContentFromPublisher(cn);
        }
        try {
            this.__IM.onEntry((Object)this, "fetchContentFromPublisher$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification", new Object[]{cn});
            string = this.__M_fetchContentFromPublisher(cn);
            this.__IM.onExit((Object)this, "fetchContentFromPublisher$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fetchContentFromPublisher$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_fetchContentFromPublisher(ContentNotification cn) {
        this.__getlogger().info("(Hub) -> Publisher, fetching content from the publisher on the url {}", (Object)cn.getUrl());
        HttpGet httpGet = new HttpGet(cn.getUrl());
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            String contentReceived = HubImpl.inputStreamToString(response.getEntity().getContent());
            this.__getlogger().info("(Hub) -> Publisher, Content fetched from publisher \n{}\n", (Object)contentReceived);
            return contentReceived;
        }
        catch (IOException e) {
            this.__getlogger().info("(Hub) -> Publisher, Failed to fetched from publisher");
            e.printStackTrace();
            return null;
        }
    }

    private void distributeContentToSubscribers(String content, String topic) {
        if (!this.__MdistributeContentToSubscribers$java_lang_String$java_lang_String) {
            this.__M_distributeContentToSubscribers(content, topic);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "distributeContentToSubscribers$java_lang_String$java_lang_String", new Object[]{content, topic});
            this.__M_distributeContentToSubscribers(content, topic);
            this.__IM.onExit((Object)this, "distributeContentToSubscribers$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "distributeContentToSubscribers$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_distributeContentToSubscribers(String content, String topic) {
        List callbacks = (List)this.__gettopicCallbackSubscriptionMap().get(topic);
        System.out.println(String.format("The topic [%s] has the callbacks %s", topic, callbacks));
        if (callbacks != null) {
            for (String callback : callbacks) {
                HttpPost httpPost = new HttpPost(callback);
                try {
                    httpPost.setEntity((HttpEntity)new StringEntity(content));
                    httpPost.setHeader("Content-Type", "application/atom+xml");
                    System.out.println("publisher --> Distributed content to callback: " + callback);
                    CloseableHttpClient httpclient = HttpClients.createDefault();
                    this.__getlogger().info("(Hub) -> Subscriber, send content to subscriber {}", (Object)callback);
                    CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                    this.__getlogger().info("(Hub) -> Subscriber, subcribers response {}", (Object)response.getStatusLine().getStatusCode());
                }
                catch (Exception e) {
                    this.__getlogger().info("Failed distributing content to subscribers caused by {}", (Object)e.getMessage());
                }
            }
        }
    }

    private static String inputStreamToString(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        in.close();
        return sb.toString();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("http")) {
                this.__Fhttp = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("topicCallbackSubscriptionMap")) {
                this.__FtopicCallbackSubscriptionMap = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("ContentNotificationReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification")) {
                this.__MContentNotificationReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification = true;
            }
            if (set.contains("SubscriptionRequestReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest")) {
                this.__MSubscriptionRequestReceived$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest = true;
            }
            if (set.contains("VerifySubscriberRequestedSubscription$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest")) {
                this.__MVerifySubscriberRequestedSubscription$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_SubscriptionRequest = true;
            }
            if (set.contains("NotifySubscriberCallback$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification")) {
                this.__MNotifySubscriberCallback$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification = true;
            }
            if (set.contains("addCallbackToTopic$java_lang_String$java_lang_String")) {
                this.__MaddCallbackToTopic$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeCallbackToTopic$java_lang_String$java_lang_String")) {
                this.__MremoveCallbackToTopic$java_lang_String$java_lang_String = true;
            }
            if (set.contains("fetchContentFromPublisher$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification")) {
                this.__MfetchContentFromPublisher$org_ow2_chameleon_fuchsia_pubsubhub_hub_dto_ContentNotification = true;
            }
            if (set.contains("distributeContentToSubscribers$java_lang_String$java_lang_String")) {
                this.__MdistributeContentToSubscribers$java_lang_String$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

