/*
 * Copyright 2009 OW2 Chameleon
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.chameleon.i18n.extension;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;

import junit.framework.Assert;

import org.junit.Test;
import org.ow2.chameleon.i18n.I18nService;

public class I18NServiceImplTest {

	@Test
	public void testProperties() {
		I18nService svc = I18NServiceFactory.createMyApp_De();
		Assert.assertEquals("myapp", svc.getResources()[0]);
		Assert.assertEquals(new Locale("de"), svc.getLocale());
		Assert.assertEquals(2, svc.getKeys().length);
		Assert.assertEquals("Hallo", svc.getString("HELLO"));
	}

	@Test
	public void testUTF8Properties() {
		I18nService svc = I18NServiceFactory.createMyApp_De_UTF8();
		Assert.assertEquals("myapp", svc.getResources()[0]);
		Assert.assertEquals(new Locale("de"), svc.getLocale());
		Assert.assertEquals(2, svc.getKeys().length);
		Assert.assertEquals("Hallo", svc.getString("HELLO"));
		Assert.assertEquals("Grüße", svc.getString("WELCOME"));
	}

	@Test
	public void testXMLProperties() {
		I18nService svc = I18NServiceFactory.createMyApp_De_XML();
		Assert.assertEquals("myapp", svc.getResources()[0]);
		Assert.assertEquals(new Locale("de"), svc.getLocale());
		Assert.assertEquals(2, svc.getKeys().length);
		Assert.assertEquals("Hallo", svc.getString("HELLO"));
		Assert.assertEquals("Grüße", svc.getString("WELCOME"));
	}

	@Test(expected=IOException.class)
	public void testI18NWithWrongURL() throws IOException {
		URL wrong = null;
		try {
			wrong = new File("do_not_exit.properties").toURI().toURL();
		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}

		new I18nServiceImpl(
				new String[] {"myapp2"},
				new Locale("de"),
				wrong
				);
	}


	@Test(expected=IOException.class)
	public void testEmptyProperties() throws IOException {
		I18NServiceFactory.createEmpty();
	}

	@Test(expected=IOException.class)
	public void testEmptyUTF8Properties() throws IOException {
		I18NServiceFactory.createEmpty_UTF8();
	}

	@Test(expected=IOException.class)
	public void testEmptyXML() throws IOException {
		I18NServiceFactory.createEmpty_XML();
	}

	@Test
	public void testNoResources() {
		I18nService svc = I18NServiceFactory.createI18NWithNoResource();
		Assert.assertEquals(0, svc.getResources().length);
		Assert.assertEquals(new Locale("de"), svc.getLocale());
		Assert.assertEquals(2, svc.getKeys().length);
		Assert.assertEquals("Hallo", svc.getString("HELLO"));
	}


}
