/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.i18n.extension;

import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class I18nExtender
implements BundleListener,
Pojo {
    private InstanceManager __IM;
    private boolean __Fm_context;
    private BundleContext m_context;
    private boolean __Fm_i18nFactory;
    @Requires(filter="(factory.name=org.ow2.chameleon.i18n.extension)")
    private Factory m_i18nFactory;
    private boolean __Fm_extensions;
    private List<I18nExtension> m_extensions;
    private boolean __Fm_logger;
    private Logger m_logger;
    private boolean __Mstart;
    private boolean __Manalyze$org_osgi_framework_Bundle;
    private boolean __Mtraverse$java_lang_String$java_lang_String$org_osgi_framework_Bundle;
    private boolean __McreateExtension$org_osgi_framework_Bundle$java_lang_String$java_lang_String$java_net_URL;
    private boolean __MbundleChanged$org_osgi_framework_BundleEvent;

    BundleContext __getm_context() {
        if (!this.__Fm_context) {
            return this.m_context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "m_context");
    }

    void __setm_context(BundleContext bundleContext) {
        if (!this.__Fm_context) {
            this.m_context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "m_context", (Object)bundleContext);
    }

    Factory __getm_i18nFactory() {
        if (!this.__Fm_i18nFactory) {
            return this.m_i18nFactory;
        }
        return (Factory)this.__IM.onGet((Object)this, "m_i18nFactory");
    }

    void __setm_i18nFactory(Factory factory) {
        if (!this.__Fm_i18nFactory) {
            this.m_i18nFactory = factory;
            return;
        }
        this.__IM.onSet((Object)this, "m_i18nFactory", (Object)factory);
    }

    List __getm_extensions() {
        if (!this.__Fm_extensions) {
            return this.m_extensions;
        }
        return (List)this.__IM.onGet((Object)this, "m_extensions");
    }

    void __setm_extensions(List list) {
        if (!this.__Fm_extensions) {
            this.m_extensions = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_extensions", (Object)list);
    }

    Logger __getm_logger() {
        if (!this.__Fm_logger) {
            return this.m_logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "m_logger");
    }

    void __setm_logger(Logger logger) {
        if (!this.__Fm_logger) {
            this.m_logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "m_logger", (Object)logger);
    }

    public I18nExtender(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private I18nExtender(InstanceManager _manager, BundleContext bc) {
        this._setInstanceManager(_manager);
        this.__setm_extensions(new ArrayList());
        this.__setm_logger(LoggerFactory.getLogger((String)"org.ow2.chameleon.i18n.extender"));
        this.__setm_context(bc);
    }

    public synchronized void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        this.__getm_context().addBundleListener((BundleListener)this);
        for (Bundle bundle : this.__getm_context().getBundles()) {
            this.analyze(bundle);
        }
    }

    private synchronized void analyze(Bundle bundle) {
        if (!this.__Manalyze$org_osgi_framework_Bundle) {
            this.__analyze(bundle);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "analyze$org_osgi_framework_Bundle", new Object[]{bundle});
            this.__analyze(bundle);
            this.__IM.onExit((Object)this, "analyze$org_osgi_framework_Bundle", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "analyze$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
    }

    private void __analyze(Bundle b) {
        this.__getm_logger().info("Analyzing " + b.getSymbolicName());
        this.traverse("/i18n/", "/i18n/", b);
    }

    private void traverse(String string, String string2, Bundle bundle) {
        if (!this.__Mtraverse$java_lang_String$java_lang_String$org_osgi_framework_Bundle) {
            this.__traverse(string, string2, bundle);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "traverse$java_lang_String$java_lang_String$org_osgi_framework_Bundle", new Object[]{string, string2, bundle});
            this.__traverse(string, string2, bundle);
            this.__IM.onExit((Object)this, "traverse$java_lang_String$java_lang_String$org_osgi_framework_Bundle", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "traverse$java_lang_String$java_lang_String$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
    }

    private void __traverse(String path, String prefix, Bundle bundle) {
        if (path.endsWith("/")) {
            Enumeration paths = bundle.getEntryPaths(path);
            if (paths != null) {
                while (paths.hasMoreElements()) {
                    String p = (String)paths.nextElement();
                    this.traverse(p, prefix, bundle);
                }
            }
        } else {
            String file = path.substring(prefix.length() - 1);
            int index = (file = file.replace("/", ".")).indexOf(95);
            if (index != -1) {
                URL url;
                String resourceName = null;
                resourceName = file.startsWith("/") ? file.substring(1, index) : file.substring(0, index);
                String locale = file.substring(index + 1);
                if (locale.lastIndexOf(46) != -1) {
                    int lastDot = locale.lastIndexOf(46);
                    locale = locale.substring(0, lastDot);
                }
                if ((url = bundle.getEntry(path)) != null) {
                    this.createExtension(bundle, resourceName, locale, url);
                } else {
                    this.__getm_logger().error("Cannot open " + path + " from " + bundle.getSymbolicName());
                }
            } else {
                this.__getm_logger().error("Malformed resource file in " + bundle.getBundleId() + " for " + path);
            }
        }
    }

    private synchronized void createExtension(Bundle bundle, String string, String string2, URL uRL) {
        if (!this.__McreateExtension$org_osgi_framework_Bundle$java_lang_String$java_lang_String$java_net_URL) {
            this.__createExtension(bundle, string, string2, uRL);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createExtension$org_osgi_framework_Bundle$java_lang_String$java_lang_String$java_net_URL", new Object[]{bundle, string, string2, uRL});
            this.__createExtension(bundle, string, string2, uRL);
            this.__IM.onExit((Object)this, "createExtension$org_osgi_framework_Bundle$java_lang_String$java_lang_String$java_net_URL", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createExtension$org_osgi_framework_Bundle$java_lang_String$java_lang_String$java_net_URL", throwable);
            throw throwable;
        }
    }

    private void __createExtension(Bundle bundle, String resourceName, String locale, URL url) {
        I18nExtension extension = new I18nExtension(bundle, resourceName, locale);
        if (this.__getm_extensions().contains(extension)) {
            return;
        }
        Properties configuration = new Properties();
        configuration.put("i18n.resources", new String[]{resourceName});
        configuration.put("i18n.locale", locale);
        configuration.put("i18n.url", url);
        try {
            ComponentInstance ci = this.__getm_i18nFactory().createComponentInstance((Dictionary)configuration);
            extension.setInstance(ci);
            this.__getm_extensions().add(extension);
            this.__getm_logger().info("I18N Extension created for " + resourceName + " - " + locale);
        }
        catch (Exception e) {
            this.__getm_logger().error("Cannot create I18N Extension Instance : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public synchronized void bundleChanged(BundleEvent bundleEvent) {
        if (!this.__MbundleChanged$org_osgi_framework_BundleEvent) {
            this.__bundleChanged(bundleEvent);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bundleChanged$org_osgi_framework_BundleEvent", new Object[]{bundleEvent});
            this.__bundleChanged(bundleEvent);
            this.__IM.onExit((Object)this, "bundleChanged$org_osgi_framework_BundleEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bundleChanged$org_osgi_framework_BundleEvent", throwable);
            throw throwable;
        }
    }

    private void __bundleChanged(BundleEvent event) {
        if (event.getType() == 2) {
            this.analyze(event.getBundle());
            return;
        }
        if (event.getType() == 64) {
            ArrayList<I18nExtension> toRemove = new ArrayList<I18nExtension>();
            for (I18nExtension extension : this.__getm_extensions()) {
                if (extension.m_bundle.getBundleId() != event.getBundle().getBundleId()) continue;
                extension.m_instance.dispose();
                toRemove.add(extension);
                this.__getm_logger().info("I18N Removed : " + extension.m_resource + " - " + extension.m_locale);
            }
            this.__getm_extensions().removeAll(toRemove);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_logger")) {
                this.__Fm_logger = true;
            }
            if (set.contains("m_context")) {
                this.__Fm_context = true;
            }
            if (set.contains("m_i18nFactory")) {
                this.__Fm_i18nFactory = true;
            }
            if (set.contains("m_extensions")) {
                this.__Fm_extensions = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("analyze$org_osgi_framework_Bundle")) {
                this.__Manalyze$org_osgi_framework_Bundle = true;
            }
            if (set.contains("traverse$java_lang_String$java_lang_String$org_osgi_framework_Bundle")) {
                this.__Mtraverse$java_lang_String$java_lang_String$org_osgi_framework_Bundle = true;
            }
            if (set.contains("createExtension$org_osgi_framework_Bundle$java_lang_String$java_lang_String$java_net_URL")) {
                this.__McreateExtension$org_osgi_framework_Bundle$java_lang_String$java_lang_String$java_net_URL = true;
            }
            if (set.contains("bundleChanged$org_osgi_framework_BundleEvent")) {
                this.__MbundleChanged$org_osgi_framework_BundleEvent = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private class I18nExtension {
        private final Bundle m_bundle;
        private final String m_resource;
        private final String m_locale;
        private ComponentInstance m_instance;

        public I18nExtension(Bundle bundle, String resource, String locale) {
            this.m_bundle = bundle;
            this.m_resource = resource;
            this.m_locale = locale;
        }

        public void setInstance(ComponentInstance instance) {
            this.m_instance = instance;
        }

        public boolean equals(Object object) {
            if (object instanceof I18nExtension) {
                I18nExtension extension = (I18nExtension)object;
                return this.m_bundle.getBundleId() == extension.m_bundle.getBundleId() && this.m_resource.equals(extension.m_resource) && this.m_locale.equals(extension.m_locale);
            }
            return false;
        }
    }
}

