/**
 * Copyright 2009 OW2 Chameleon
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.chameleon.i18n.extension;


import org.junit.Assert;
import org.junit.Test;

import java.util.Locale;

public class I18NExtenderTest {

    @Test
    public void testLocaleExtractionWithLanguageAndCountry() {
        String path = "TdmFrontend_fr_FR.utf8-properties";
        String file = path;
        file = file.replace("/", ".");
        int index = file.indexOf('_');
        if (index != -1) {
            String resourceName = null;
            if (file.startsWith("/")) {
                resourceName = file.substring(1, index);
            } else {
                resourceName = file.substring(0, index);
            }

            String locale = I18nExtender.computeLocale(file.substring(index + 1));
            System.out.println(locale);

            Locale loc = I18nExtender.getLocaleFromString(locale);

            Assert.assertEquals("fr", loc.getLanguage());
            Assert.assertEquals("FR", loc.getCountry());
            Assert.assertEquals("", loc.getVariant());
        }
    }

    @Test
    public void testLocaleExtractionWithLanguage() {
        String path = "TdmFrontend_fr.utf8-properties";
        String file = path;
        file = file.replace("/", ".");
        int index = file.indexOf('_');
        if (index != -1) {
            String resourceName = null;
            if (file.startsWith("/")) {
                resourceName = file.substring(1, index);
            } else {
                resourceName = file.substring(0, index);
            }

            String locale = I18nExtender.computeLocale(file.substring(index + 1));
            System.out.println(locale);

            Locale loc = I18nExtender.getLocaleFromString(locale);

            Assert.assertEquals("fr", loc.getLanguage());
            Assert.assertEquals("", loc.getCountry());
            Assert.assertEquals("", loc.getVariant());
        }
    }

    @Test
    public void testLocaleExtractionWithLanguageCountryAndVariant() {
        String path = "TdmFrontend_fr_FR_MAC.utf8-properties";
        String file = path;
        file = file.replace("/", ".");
        int index = file.indexOf('_');
        if (index != -1) {
            String resourceName = null;
            if (file.startsWith("/")) {
                resourceName = file.substring(1, index);
            } else {
                resourceName = file.substring(0, index);
            }

            String locale = I18nExtender.computeLocale(file.substring(index + 1));
            System.out.println(locale);

            Locale loc = I18nExtender.getLocaleFromString(locale);

            Assert.assertEquals("fr", loc.getLanguage());
            Assert.assertEquals("FR", loc.getCountry());
            Assert.assertEquals("MAC", loc.getVariant());
        }
    }

        @Test
    public void testLocaleExtractionWithLanguageAndVariant() {
        String path = "TdmFrontend_fr__MAC.utf8-properties";
        String file = path;
        file = file.replace("/", ".");
        int index = file.indexOf('_');
        if (index != -1) {
            String resourceName = null;
            if (file.startsWith("/")) {
                resourceName = file.substring(1, index);
            } else {
                resourceName = file.substring(0, index);
            }

            String locale = I18nExtender.computeLocale(file.substring(index + 1));
            System.out.println(locale);

            Locale loc = I18nExtender.getLocaleFromString(locale);

            Assert.assertEquals("fr", loc.getLanguage());
            Assert.assertEquals("", loc.getCountry());
            Assert.assertEquals("MAC", loc.getVariant());
        }
    }
}
