/*
 * Copyright 2009 OW2 Chameleon
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.chameleon.i18n.extension;

import org.ow2.chameleon.i18n.I18nService;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Locale;

public class I18NServiceFactory {

	private static final File ROOT = new File("src/test/resources/i18n-resources");

	public static I18nService createMyApp_De() {
		try {
			return new I18nServiceImpl(
					new String[] {"myapp"},
					new Locale("de"),
					new File(ROOT, "myapp_de.properties").toURI().toURL());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static I18nService createMyApp_De_UTF8() {
		try {
			return new I18nServiceImpl(
					new String[] {"myapp"},
					new Locale("de"),
					new File(ROOT, "myapp_de.utf8-properties").toURI().toURL());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static I18nService createMyApp_De_XML() {
		try {
			return new I18nServiceImpl(
					new String[] {"myapp"},
					new Locale("de"),
					new File(ROOT, "myapp_de.xml").toURI().toURL());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static I18nService createMyApp_En() {
		try {
			return new I18nServiceImpl(
					new String[] {"myapp"},
					new Locale("de"),
					new File(ROOT, "myapp_en.properties").toURI().toURL());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static I18nService createMyApp_fr_FR() {
		try {
			return new I18nServiceImpl(
					new String[] {"myapp"},
					new Locale("fr", "FR"),
					new File(ROOT, "myapp_fr_FR.properties").toURI().toURL());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static I18nService createMyApp_fr_CA() {
		try {
			return new I18nServiceImpl(
					new String[] {"myapp"},
					new Locale("fr", "CA"),
					new File(ROOT, "myapp_fr_FR.properties").toURI().toURL());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static I18nService createMyApp_fr_CA_QE() {
		try {
			return new I18nServiceImpl(
					new String[] {"myapp"},
					new Locale("fr", "CA", "QE"),
					new File(ROOT, "myapp_fr_FR.properties").toURI().toURL());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static I18nService createMyApp_fr() {
		try {
			return new I18nServiceImpl(
					new String[] {"myapp"},
					new Locale("fr"),
					new File(ROOT, "myapp_fr.properties").toURI().toURL());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}


	public static I18nService createMyApp2_de() {
		try {
			return new I18nServiceImpl(
					new String[] {"myapp2"},
					new Locale("de"),
					new File(ROOT, "myapp2_de.properties").toURI().toURL());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static I18nService createEmpty() throws IOException {
		try {
			return new I18nServiceImpl(
					new String[] {"myapp"},
					new Locale("de"),
					new File(ROOT, "empty_de.properties").toURI().toURL());
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static I18nService createEmpty_UTF8() throws IOException {
		try {
			return new I18nServiceImpl(
					new String[] {"myapp"},
					new Locale("de"),
					new File(ROOT, "empty_de.utf8-properties").toURI().toURL());
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static I18nService createEmpty_XML() throws IOException {
		try {
			return new I18nServiceImpl(
					new String[] {"myapp"},
					new Locale("de"),
					new File(ROOT, "empty_de.xml").toURI().toURL());
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static I18nService createI18NWithNoResource() {
		try {
			return new I18nServiceImpl(
					null,
					new Locale("de"),
					new File(ROOT, "myapp_de.properties").toURI().toURL());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}


}
