/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.i18n.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.ow2.chameleon.i18n.I18nService;
import org.ow2.chameleon.i18n.I18nServiceSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Provides
public class I18NServiceSelectorImpl
implements I18nServiceSelector,
Pojo {
    private InstanceManager __IM;
    private boolean __Fm_i18n;
    @Requires(optional=true)
    private I18nService[] m_i18n;
    private boolean __MgetI18nServices$java_lang_String;
    private boolean __MgetI18nServicesForCurrentLocale$java_lang_String;
    private boolean __MfindServicesForLocale$org_ow2_chameleon_i18n_I18nService__$java_util_Locale$boolean;
    private boolean __MfindServicesForResource$org_ow2_chameleon_i18n_I18nService__$java_lang_String;
    private boolean __MgetCandidateLocales$java_util_Locale;
    private boolean __MgetI18nServicesForCurrentLocale$java_lang_String$boolean;
    private boolean __MgetI18nServices$java_lang_String$java_util_Locale;
    private boolean __MgetI18nServices$java_lang_String$java_util_Locale$boolean;
    private boolean __MgetI18nServices$java_util_Locale;
    private boolean __MgetI18nServices$java_util_Locale$boolean;
    private boolean __MgetI18nServiceForCurrentLocale$java_lang_String;
    private boolean __MgetI18nService$java_lang_String$java_util_Locale;
    private boolean __MgetI18nServiceForCurrentLocale$java_lang_String$boolean;
    private boolean __MgetI18nService$java_lang_String$java_util_Locale$boolean;

    I18nService[] __getm_i18n() {
        if (!this.__Fm_i18n) {
            return this.m_i18n;
        }
        return (I18nService[])this.__IM.onGet((Object)this, "m_i18n");
    }

    void __setm_i18n(I18nService[] i18nServiceArray) {
        if (!this.__Fm_i18n) {
            this.m_i18n = i18nServiceArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_i18n", (Object)i18nServiceArray);
    }

    public I18NServiceSelectorImpl() {
        this((InstanceManager)null);
    }

    private I18NServiceSelectorImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    protected I18NServiceSelectorImpl(I18nService[] i18nServiceArray) {
        this(null, i18nServiceArray);
    }

    private I18NServiceSelectorImpl(InstanceManager _manager, I18nService[] services) {
        this();
        this.__setm_i18n(services);
    }

    @Override
    public I18nService[] getI18nServices(String string) {
        I18nService[] i18nServiceArray;
        if (!this.__MgetI18nServices$java_lang_String) {
            return this.__getI18nServices(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getI18nServices$java_lang_String", new Object[]{string});
            i18nServiceArray = this.__getI18nServices(string);
            this.__IM.onExit((Object)this, "getI18nServices$java_lang_String", (Object)i18nServiceArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getI18nServices$java_lang_String", throwable);
            throw throwable;
        }
        return i18nServiceArray;
    }

    private I18nService[] __getI18nServices(String resourceName) {
        return this.findServicesForResource(this.__getm_i18n(), resourceName);
    }

    @Override
    public I18nService[] getI18nServicesForCurrentLocale(String string) {
        I18nService[] i18nServiceArray;
        if (!this.__MgetI18nServicesForCurrentLocale$java_lang_String) {
            return this.__getI18nServicesForCurrentLocale(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getI18nServicesForCurrentLocale$java_lang_String", new Object[]{string});
            i18nServiceArray = this.__getI18nServicesForCurrentLocale(string);
            this.__IM.onExit((Object)this, "getI18nServicesForCurrentLocale$java_lang_String", (Object)i18nServiceArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getI18nServicesForCurrentLocale$java_lang_String", throwable);
            throw throwable;
        }
        return i18nServiceArray;
    }

    private I18nService[] __getI18nServicesForCurrentLocale(String resourceName) {
        return this.getI18nServicesForCurrentLocale(resourceName, false);
    }

    private I18nService[] findServicesForLocale(I18nService[] i18nServiceArray, Locale locale, boolean bl) {
        I18nService[] i18nServiceArray2;
        if (!this.__MfindServicesForLocale$org_ow2_chameleon_i18n_I18nService__$java_util_Locale$boolean) {
            return this.__findServicesForLocale(i18nServiceArray, locale, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "findServicesForLocale$org_ow2_chameleon_i18n_I18nService__$java_util_Locale$boolean", new Object[]{i18nServiceArray, locale, new Boolean(bl)});
            i18nServiceArray2 = this.__findServicesForLocale(i18nServiceArray, locale, bl);
            this.__IM.onExit((Object)this, "findServicesForLocale$org_ow2_chameleon_i18n_I18nService__$java_util_Locale$boolean", (Object)i18nServiceArray2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "findServicesForLocale$org_ow2_chameleon_i18n_I18nService__$java_util_Locale$boolean", throwable);
            throw throwable;
        }
        return i18nServiceArray2;
    }

    private I18nService[] __findServicesForLocale(I18nService[] services, Locale locale, boolean includeParents) {
        ArrayList<I18nService> list = new ArrayList<I18nService>();
        List<Locale> locales = this.getCandidateLocales(locale);
        for (I18nService svc : services) {
            if (!svc.getLocale().equals(locales.get(0))) continue;
            list.add(svc);
        }
        if (!includeParents) {
            return list.toArray(new I18nService[list.size()]);
        }
        for (I18nService svc : services) {
            if (locales.size() < 2 || !svc.getLocale().equals(locales.get(1)) || list.contains(svc)) continue;
            list.add(svc);
        }
        for (I18nService svc : services) {
            if (locales.size() < 3 || !svc.getLocale().equals(locales.get(2)) || list.contains(svc)) continue;
            list.add(svc);
        }
        return list.toArray(new I18nService[list.size()]);
    }

    private I18nService[] findServicesForResource(I18nService[] i18nServiceArray, String string) {
        I18nService[] i18nServiceArray2;
        if (!this.__MfindServicesForResource$org_ow2_chameleon_i18n_I18nService__$java_lang_String) {
            return this.__findServicesForResource(i18nServiceArray, string);
        }
        try {
            this.__IM.onEntry((Object)this, "findServicesForResource$org_ow2_chameleon_i18n_I18nService__$java_lang_String", new Object[]{i18nServiceArray, string});
            i18nServiceArray2 = this.__findServicesForResource(i18nServiceArray, string);
            this.__IM.onExit((Object)this, "findServicesForResource$org_ow2_chameleon_i18n_I18nService__$java_lang_String", (Object)i18nServiceArray2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "findServicesForResource$org_ow2_chameleon_i18n_I18nService__$java_lang_String", throwable);
            throw throwable;
        }
        return i18nServiceArray2;
    }

    private I18nService[] __findServicesForResource(I18nService[] services, String resourceName) {
        ArrayList<I18nService> list = new ArrayList<I18nService>();
        for (I18nService svc : services) {
            String[] resources = svc.getResources();
            if (resources == null) continue;
            for (String res : resources) {
                if (!resourceName.equals(res) || list.contains(svc)) continue;
                list.add(svc);
            }
        }
        return list.toArray(new I18nService[list.size()]);
    }

    public List<Locale> getCandidateLocales(Locale locale) {
        List<Locale> list;
        if (!this.__MgetCandidateLocales$java_util_Locale) {
            return this.__getCandidateLocales(locale);
        }
        try {
            this.__IM.onEntry((Object)this, "getCandidateLocales$java_util_Locale", new Object[]{locale});
            list = this.__getCandidateLocales(locale);
            this.__IM.onExit((Object)this, "getCandidateLocales$java_util_Locale", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCandidateLocales$java_util_Locale", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Locale> __getCandidateLocales(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        ArrayList<Locale> locales = new ArrayList<Locale>(3);
        if (variant.length() > 0) {
            locales.add(locale);
        }
        if (country.length() > 0) {
            locales.add(locales.size() == 0 ? locale : new Locale(language, country, ""));
        }
        if (language.length() > 0) {
            locales.add(locales.size() == 0 ? locale : new Locale(language, "", ""));
        }
        return locales;
    }

    @Override
    public I18nService[] getI18nServicesForCurrentLocale(String string, boolean bl) {
        I18nService[] i18nServiceArray;
        if (!this.__MgetI18nServicesForCurrentLocale$java_lang_String$boolean) {
            return this.__getI18nServicesForCurrentLocale(string, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "getI18nServicesForCurrentLocale$java_lang_String$boolean", new Object[]{string, new Boolean(bl)});
            i18nServiceArray = this.__getI18nServicesForCurrentLocale(string, bl);
            this.__IM.onExit((Object)this, "getI18nServicesForCurrentLocale$java_lang_String$boolean", (Object)i18nServiceArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getI18nServicesForCurrentLocale$java_lang_String$boolean", throwable);
            throw throwable;
        }
        return i18nServiceArray;
    }

    private I18nService[] __getI18nServicesForCurrentLocale(String resourceName, boolean includeParents) {
        return this.getI18nServices(resourceName, Locale.getDefault(), includeParents);
    }

    @Override
    public I18nService[] getI18nServices(String string, Locale locale) {
        I18nService[] i18nServiceArray;
        if (!this.__MgetI18nServices$java_lang_String$java_util_Locale) {
            return this.__getI18nServices(string, locale);
        }
        try {
            this.__IM.onEntry((Object)this, "getI18nServices$java_lang_String$java_util_Locale", new Object[]{string, locale});
            i18nServiceArray = this.__getI18nServices(string, locale);
            this.__IM.onExit((Object)this, "getI18nServices$java_lang_String$java_util_Locale", (Object)i18nServiceArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getI18nServices$java_lang_String$java_util_Locale", throwable);
            throw throwable;
        }
        return i18nServiceArray;
    }

    private I18nService[] __getI18nServices(String resourceName, Locale locale) {
        return this.getI18nServices(resourceName, locale, false);
    }

    @Override
    public I18nService[] getI18nServices(String string, Locale locale, boolean bl) {
        I18nService[] i18nServiceArray;
        if (!this.__MgetI18nServices$java_lang_String$java_util_Locale$boolean) {
            return this.__getI18nServices(string, locale, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "getI18nServices$java_lang_String$java_util_Locale$boolean", new Object[]{string, locale, new Boolean(bl)});
            i18nServiceArray = this.__getI18nServices(string, locale, bl);
            this.__IM.onExit((Object)this, "getI18nServices$java_lang_String$java_util_Locale$boolean", (Object)i18nServiceArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getI18nServices$java_lang_String$java_util_Locale$boolean", throwable);
            throw throwable;
        }
        return i18nServiceArray;
    }

    private I18nService[] __getI18nServices(String resourceName, Locale locale, boolean includeParents) {
        I18nService[] services = this.findServicesForResource(this.__getm_i18n(), resourceName);
        services = this.findServicesForLocale(services, locale, includeParents);
        return services;
    }

    @Override
    public I18nService[] getI18nServices(Locale locale) {
        I18nService[] i18nServiceArray;
        if (!this.__MgetI18nServices$java_util_Locale) {
            return this.__getI18nServices(locale);
        }
        try {
            this.__IM.onEntry((Object)this, "getI18nServices$java_util_Locale", new Object[]{locale});
            i18nServiceArray = this.__getI18nServices(locale);
            this.__IM.onExit((Object)this, "getI18nServices$java_util_Locale", (Object)i18nServiceArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getI18nServices$java_util_Locale", throwable);
            throw throwable;
        }
        return i18nServiceArray;
    }

    private I18nService[] __getI18nServices(Locale locale) {
        return this.getI18nServices(locale, false);
    }

    @Override
    public I18nService[] getI18nServices(Locale locale, boolean bl) {
        I18nService[] i18nServiceArray;
        if (!this.__MgetI18nServices$java_util_Locale$boolean) {
            return this.__getI18nServices(locale, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "getI18nServices$java_util_Locale$boolean", new Object[]{locale, new Boolean(bl)});
            i18nServiceArray = this.__getI18nServices(locale, bl);
            this.__IM.onExit((Object)this, "getI18nServices$java_util_Locale$boolean", (Object)i18nServiceArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getI18nServices$java_util_Locale$boolean", throwable);
            throw throwable;
        }
        return i18nServiceArray;
    }

    private I18nService[] __getI18nServices(Locale locale, boolean includeParents) {
        return this.findServicesForLocale(this.__getm_i18n(), locale, includeParents);
    }

    @Override
    public I18nService getI18nServiceForCurrentLocale(String string) {
        I18nService i18nService;
        if (!this.__MgetI18nServiceForCurrentLocale$java_lang_String) {
            return this.__getI18nServiceForCurrentLocale(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getI18nServiceForCurrentLocale$java_lang_String", new Object[]{string});
            i18nService = this.__getI18nServiceForCurrentLocale(string);
            this.__IM.onExit((Object)this, "getI18nServiceForCurrentLocale$java_lang_String", (Object)i18nService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getI18nServiceForCurrentLocale$java_lang_String", throwable);
            throw throwable;
        }
        return i18nService;
    }

    private I18nService __getI18nServiceForCurrentLocale(String resourceName) {
        return this.getI18nService(resourceName, Locale.getDefault(), false);
    }

    @Override
    public I18nService getI18nService(String string, Locale locale) {
        I18nService i18nService;
        if (!this.__MgetI18nService$java_lang_String$java_util_Locale) {
            return this.__getI18nService(string, locale);
        }
        try {
            this.__IM.onEntry((Object)this, "getI18nService$java_lang_String$java_util_Locale", new Object[]{string, locale});
            i18nService = this.__getI18nService(string, locale);
            this.__IM.onExit((Object)this, "getI18nService$java_lang_String$java_util_Locale", (Object)i18nService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getI18nService$java_lang_String$java_util_Locale", throwable);
            throw throwable;
        }
        return i18nService;
    }

    private I18nService __getI18nService(String resourceName, Locale locale) {
        return this.getI18nService(resourceName, locale, false);
    }

    @Override
    public I18nService getI18nServiceForCurrentLocale(String string, boolean bl) {
        I18nService i18nService;
        if (!this.__MgetI18nServiceForCurrentLocale$java_lang_String$boolean) {
            return this.__getI18nServiceForCurrentLocale(string, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "getI18nServiceForCurrentLocale$java_lang_String$boolean", new Object[]{string, new Boolean(bl)});
            i18nService = this.__getI18nServiceForCurrentLocale(string, bl);
            this.__IM.onExit((Object)this, "getI18nServiceForCurrentLocale$java_lang_String$boolean", (Object)i18nService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getI18nServiceForCurrentLocale$java_lang_String$boolean", throwable);
            throw throwable;
        }
        return i18nService;
    }

    private I18nService __getI18nServiceForCurrentLocale(String resourceName, boolean includeParents) {
        return this.getI18nService(resourceName, Locale.getDefault(), includeParents);
    }

    @Override
    public I18nService getI18nService(String string, Locale locale, boolean bl) {
        I18nService i18nService;
        if (!this.__MgetI18nService$java_lang_String$java_util_Locale$boolean) {
            return this.__getI18nService(string, locale, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "getI18nService$java_lang_String$java_util_Locale$boolean", new Object[]{string, locale, new Boolean(bl)});
            i18nService = this.__getI18nService(string, locale, bl);
            this.__IM.onExit((Object)this, "getI18nService$java_lang_String$java_util_Locale$boolean", (Object)i18nService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getI18nService$java_lang_String$java_util_Locale$boolean", throwable);
            throw throwable;
        }
        return i18nService;
    }

    private I18nService __getI18nService(String resourceName, Locale locale, boolean includeParents) {
        I18nService[] services = this.findServicesForResource(this.__getm_i18n(), resourceName);
        List<Locale> locales = this.getCandidateLocales(locale);
        I18nService fullMatch = null;
        I18nService noVariantMatch = null;
        I18nService noVariantnoCountryMatch = null;
        for (I18nService svc : services) {
            if (fullMatch == null && svc.getLocale().equals(locales.get(0))) {
                fullMatch = svc;
            }
            if (noVariantMatch == null && locales.size() >= 2 && svc.getLocale().equals(locales.get(1))) {
                noVariantMatch = svc;
            }
            if (noVariantnoCountryMatch != null || locales.size() < 3 || !svc.getLocale().equals(locales.get(2))) continue;
            noVariantnoCountryMatch = svc;
        }
        if (!includeParents || fullMatch != null) {
            return fullMatch;
        }
        if (noVariantMatch != null) {
            return noVariantMatch;
        }
        return noVariantnoCountryMatch;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("m_i18n")) {
            this.__Fm_i18n = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getI18nServices$java_lang_String")) {
                this.__MgetI18nServices$java_lang_String = true;
            }
            if (set.contains("getI18nServicesForCurrentLocale$java_lang_String")) {
                this.__MgetI18nServicesForCurrentLocale$java_lang_String = true;
            }
            if (set.contains("findServicesForLocale$org_ow2_chameleon_i18n_I18nService__$java_util_Locale$boolean")) {
                this.__MfindServicesForLocale$org_ow2_chameleon_i18n_I18nService__$java_util_Locale$boolean = true;
            }
            if (set.contains("findServicesForResource$org_ow2_chameleon_i18n_I18nService__$java_lang_String")) {
                this.__MfindServicesForResource$org_ow2_chameleon_i18n_I18nService__$java_lang_String = true;
            }
            if (set.contains("getCandidateLocales$java_util_Locale")) {
                this.__MgetCandidateLocales$java_util_Locale = true;
            }
            if (set.contains("getI18nServicesForCurrentLocale$java_lang_String$boolean")) {
                this.__MgetI18nServicesForCurrentLocale$java_lang_String$boolean = true;
            }
            if (set.contains("getI18nServices$java_lang_String$java_util_Locale")) {
                this.__MgetI18nServices$java_lang_String$java_util_Locale = true;
            }
            if (set.contains("getI18nServices$java_lang_String$java_util_Locale$boolean")) {
                this.__MgetI18nServices$java_lang_String$java_util_Locale$boolean = true;
            }
            if (set.contains("getI18nServices$java_util_Locale")) {
                this.__MgetI18nServices$java_util_Locale = true;
            }
            if (set.contains("getI18nServices$java_util_Locale$boolean")) {
                this.__MgetI18nServices$java_util_Locale$boolean = true;
            }
            if (set.contains("getI18nServiceForCurrentLocale$java_lang_String")) {
                this.__MgetI18nServiceForCurrentLocale$java_lang_String = true;
            }
            if (set.contains("getI18nService$java_lang_String$java_util_Locale")) {
                this.__MgetI18nService$java_lang_String$java_util_Locale = true;
            }
            if (set.contains("getI18nServiceForCurrentLocale$java_lang_String$boolean")) {
                this.__MgetI18nServiceForCurrentLocale$java_lang_String$boolean = true;
            }
            if (set.contains("getI18nService$java_lang_String$java_util_Locale$boolean")) {
                this.__MgetI18nService$java_lang_String$java_util_Locale$boolean = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

