/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.sharedprefs.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.ow2.chameleon.sharedprefs.SharedPreferences;
import org.ow2.chameleon.sharedprefs.SharedPreferencesService;
import org.ow2.chameleon.sharedprefs.xml.SharedPreferencesImpl;
import org.ow2.chameleon.sharedprefs.xml.SubstVars;
import org.ow2.chameleon.sharedprefs.xml.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

@Component(name="org.ow2.chameleon.sharedprefs.XmlSharedPreferences")
@Provides
public class SharedPreferencesServiceImpl
implements SharedPreferencesService,
Pojo {
    private InstanceManager __IM;
    private boolean __Fm_logger;
    private Logger m_logger;
    private boolean __Fm_storage;
    private File m_storage;
    private boolean __Fm_prefs;
    private final HashMap<File, SharedPreferencesImpl> m_prefs;
    private boolean __MsetLocation$java_lang_String;
    private boolean __MgetSharedPreferences$java_lang_String;
    private boolean __MgetSharedPrefsFile$java_lang_String;
    private boolean __MgetPreferences$java_lang_String;

    Logger __getm_logger() {
        if (!this.__Fm_logger) {
            return this.m_logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "m_logger");
    }

    void __setm_logger(Logger logger) {
        if (!this.__Fm_logger) {
            this.m_logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "m_logger", (Object)logger);
    }

    File __getm_storage() {
        if (!this.__Fm_storage) {
            return this.m_storage;
        }
        return (File)this.__IM.onGet((Object)this, "m_storage");
    }

    void __setm_storage(File file) {
        if (!this.__Fm_storage) {
            this.m_storage = file;
            return;
        }
        this.__IM.onSet((Object)this, "m_storage", (Object)file);
    }

    HashMap __getm_prefs() {
        if (!this.__Fm_prefs) {
            return this.m_prefs;
        }
        return (HashMap)this.__IM.onGet((Object)this, "m_prefs");
    }

    void __setm_prefs(HashMap hashMap) {
        if (!this.__Fm_prefs) {
            this.m_prefs = hashMap;
            return;
        }
        this.__IM.onSet((Object)this, "m_prefs", (Object)hashMap);
    }

    public SharedPreferencesServiceImpl() {
        this(null);
    }

    private SharedPreferencesServiceImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_logger(LoggerFactory.getLogger(SharedPreferencesServiceImpl.class));
        this.__setm_prefs(new HashMap());
    }

    public void setLocation(String string) throws IOException {
        if (!this.__MsetLocation$java_lang_String) {
            this.__setLocation(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setLocation$java_lang_String", new Object[]{string});
            this.__setLocation(string);
            this.__IM.onExit((Object)this, "setLocation$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setLocation$java_lang_String", throwable);
            throw throwable;
        }
    }

    @Property(name="location")
    private void __setLocation(String location) throws IOException {
        String loc = SubstVars.substVars(location, "location", null, System.getProperties());
        this.__setm_storage(new File(loc));
        if (!this.__getm_storage().exists()) {
            this.__getm_storage().mkdirs();
        } else if (!this.__getm_storage().isDirectory()) {
            throw new IOException(this.__getm_storage().getAbsolutePath() + " is not a directory");
        }
        if (!this.__getm_storage().canWrite()) {
            throw new IOException(this.__getm_storage().getAbsolutePath() + " is not writable");
        }
    }

    public SharedPreferences getSharedPreferences(String string) {
        SharedPreferences sharedPreferences;
        if (!this.__MgetSharedPreferences$java_lang_String) {
            return this.__getSharedPreferences(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getSharedPreferences$java_lang_String", new Object[]{string});
            sharedPreferences = this.__getSharedPreferences(string);
            this.__IM.onExit((Object)this, "getSharedPreferences$java_lang_String", (Object)sharedPreferences);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSharedPreferences$java_lang_String", throwable);
            throw throwable;
        }
        return sharedPreferences;
    }

    private SharedPreferences __getSharedPreferences(String name) {
        return this.getPreferences(name);
    }

    public File getSharedPrefsFile(String string) {
        File file;
        if (!this.__MgetSharedPrefsFile$java_lang_String) {
            return this.__getSharedPrefsFile(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getSharedPrefsFile$java_lang_String", new Object[]{string});
            file = this.__getSharedPrefsFile(string);
            this.__IM.onExit((Object)this, "getSharedPrefsFile$java_lang_String", (Object)file);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSharedPrefsFile$java_lang_String", throwable);
            throw throwable;
        }
        return file;
    }

    private File __getSharedPrefsFile(String name) {
        return new File(this.__getm_storage(), name + ".xml");
    }

    private SharedPreferences getPreferences(String string) {
        SharedPreferences sharedPreferences;
        if (!this.__MgetPreferences$java_lang_String) {
            return this.__getPreferences(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getPreferences$java_lang_String", new Object[]{string});
            sharedPreferences = this.__getPreferences(string);
            this.__IM.onExit((Object)this, "getPreferences$java_lang_String", (Object)sharedPreferences);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPreferences$java_lang_String", throwable);
            throw throwable;
        }
        return sharedPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedPreferences __getPreferences(String name) {
        SharedPreferencesImpl sp;
        File f = this.getSharedPrefsFile(name);
        HashMap hashMap = this.__getm_prefs();
        synchronized (hashMap) {
            sp = (SharedPreferencesImpl)this.__getm_prefs().get(f);
            if (sp != null && !sp.hasFileChanged()) {
                this.__getm_logger().info("Returning existing prefs " + name + ": " + sp);
                return sp;
            }
        }
        FileInputStream str = null;
        File backup = SharedPreferencesImpl.makeBackupFile(f);
        if (backup.exists()) {
            f.delete();
            backup.renameTo(f);
        }
        if (f.exists() && !f.canRead()) {
            this.__getm_logger().warn("Attempt to read preferences file " + f + " without permission");
        }
        Map<String, Object> map = null;
        if (f.exists() && f.canRead()) {
            try {
                str = new FileInputStream(f);
                map = XMLUtils.readMapXml(str);
                str.close();
            }
            catch (XmlPullParserException e) {
                this.__getm_logger().warn("getSharedPreferences", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                this.__getm_logger().warn("getSharedPreferences", (Throwable)e);
            }
            catch (IOException e) {
                this.__getm_logger().warn("getSharedPreferences", (Throwable)e);
            }
        }
        HashMap hashMap2 = this.__getm_prefs();
        synchronized (hashMap2) {
            if (sp != null) {
                this.__getm_logger().info("Updating existing prefs " + name + " " + sp + ": " + map);
                sp.replace(map);
            } else {
                sp = (SharedPreferencesImpl)this.__getm_prefs().get(f);
                if (sp == null) {
                    sp = new SharedPreferencesImpl(f, map);
                    this.__getm_prefs().put(f, sp);
                }
            }
            return sp;
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_logger")) {
                this.__Fm_logger = true;
            }
            if (set.contains("m_storage")) {
                this.__Fm_storage = true;
            }
            if (set.contains("m_prefs")) {
                this.__Fm_prefs = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setLocation$java_lang_String")) {
                this.__MsetLocation$java_lang_String = true;
            }
            if (set.contains("getSharedPreferences$java_lang_String")) {
                this.__MgetSharedPreferences$java_lang_String = true;
            }
            if (set.contains("getSharedPrefsFile$java_lang_String")) {
                this.__MgetSharedPrefsFile$java_lang_String = true;
            }
            if (set.contains("getPreferences$java_lang_String")) {
                this.__MgetPreferences$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

