/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.syndication.rome;

import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndCategoryImpl;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.ow2.chameleon.syndication.FeedEntry;
import org.ow2.chameleon.syndication.FeedWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeedWriter
implements FeedWriter {
    private int m_recent;

    protected void setRecentItemsCount(int recent) {
        this.m_recent = recent;
    }

    public abstract SyndFeed getFeed();

    public abstract EventAdmin getEventAdmin();

    public synchronized void addEntry(FeedEntry entry) {
        SyndEntryImpl theEntry = new SyndEntryImpl();
        SyndContentImpl theContent = new SyndContentImpl();
        theEntry.setAuthor(entry.author());
        theEntry.setTitle(entry.title());
        theEntry.setLink(entry.url());
        theEntry.setPublishedDate(new Date());
        theEntry.setUpdatedDate(new Date());
        theContent.setValue(entry.content());
        theEntry.setDescription(theContent);
        ArrayList<SyndCategoryImpl> theList = new ArrayList<SyndCategoryImpl>();
        for (String cat : entry.categories()) {
            SyndCategoryImpl theCategory = new SyndCategoryImpl();
            theCategory.setName(cat);
            theList.add(theCategory);
        }
        theEntry.setCategories(theList);
        this.getFeed().getEntries().add(0, theEntry);
        this.postEvent(new FeedEntryImpl(theEntry));
    }

    public synchronized void removeEntry(FeedEntry entry) {
        List entries = this.getFeed().getEntries();
        SyndEntry target = null;
        for (SyndEntry e : entries) {
            if (e.getTitle() == null || !e.getTitle().equals(entry.title())) continue;
            if (e.getPublishedDate() != null && e.getPublishedDate().equals(entry.publicationDate())) {
                target = e;
                break;
            }
            if (e.getUpdatedDate() == null || !e.getUpdatedDate().equals(entry.publicationDate())) continue;
            target = e;
            break;
        }
        if (target != null) {
            entries.remove(target);
        }
    }

    public synchronized void removeEntryByTitle(String title) {
        List entries = this.getFeed().getEntries();
        SyndEntry target = null;
        Iterator i$ = entries.iterator();
        if (i$.hasNext()) {
            SyndEntry e;
            target = e = (SyndEntry)i$.next();
        }
        if (target != null) {
            entries.remove(target);
        }
    }

    public synchronized List<FeedEntry> getEntries() {
        List entries = this.getFeed().getEntries();
        ArrayList<FeedEntry> result = new ArrayList<FeedEntry>();
        for (SyndEntry e : entries) {
            result.add(new FeedEntryImpl(e));
        }
        return result;
    }

    public synchronized FeedEntry getLastEntry() {
        List entries = this.getFeed().getEntries();
        if (entries.isEmpty()) {
            return null;
        }
        return new FeedEntryImpl((SyndEntry)entries.get(0));
    }

    public synchronized List<FeedEntry> getRecentEntries() {
        List entries = this.getFeed().getEntries();
        ArrayList<FeedEntry> result = new ArrayList<FeedEntry>();
        int count = 0;
        for (SyndEntry e : entries) {
            if (count == this.m_recent) {
                return result;
            }
            result.add(new FeedEntryImpl(e));
            ++count;
        }
        return result;
    }

    public String getTitle() {
        return this.getFeed().getTitle();
    }

    public FeedEntry createFeedEntry() {
        return new FeedEntryImpl();
    }

    public void postEvent(FeedEntry entry) {
        EventAdmin ea = this.getEventAdmin();
        if (ea == null) {
            return;
        }
        Properties data = new Properties();
        if (entry.author() != null) {
            ((Dictionary)data).put("entry.author", entry.author());
        }
        if (entry.categories() != null && !entry.categories().isEmpty()) {
            ((Dictionary)data).put("entry.categories", entry.categories());
        }
        if (entry.content() != null) {
            ((Dictionary)data).put("entry.content", entry.content());
        }
        if (entry.publicationDate() != null) {
            ((Dictionary)data).put("entry.date", entry.publicationDate());
        }
        if (entry.title() != null) {
            ((Dictionary)data).put("entry.title", entry.title());
        }
        if (entry.url() != null) {
            ((Dictionary)data).put("entry.url", entry.url());
        }
        if (this.getTitle() != null) {
            ((Dictionary)data).put("feed.title", this.getTitle());
        }
        if (this.getURL() != null) {
            ((Dictionary)data).put("feed.url", this.getURL());
        }
        Event event = new Event("org/ow2/chameleon/syndication", (Dictionary)data);
        ea.postEvent(event);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FeedEntryImpl
    implements FeedEntry {
        private String m_author;
        private String m_content;
        private Date m_date;
        private String m_title;
        private String m_url;
        private final List<String> m_categories;

        public FeedEntryImpl(SyndEntry e) {
            this.m_author = e.getAuthor();
            this.m_content = e.getDescription().getValue();
            Date d = e.getPublishedDate();
            this.m_date = d == null ? e.getUpdatedDate() : d;
            this.m_title = e.getTitle();
            this.m_url = e.getLink();
            List categories = e.getCategories();
            this.m_categories = new ArrayList<String>();
            for (SyndCategory cat : categories) {
                this.m_categories.add(cat.getName());
            }
        }

        public FeedEntryImpl() {
            this.m_categories = new ArrayList<String>();
        }

        public String author() {
            return this.m_author;
        }

        public List<String> categories() {
            return Collections.unmodifiableList(this.m_categories);
        }

        public String content() {
            return this.m_content;
        }

        public Date publicationDate() {
            return this.m_date;
        }

        public String title() {
            return this.m_title;
        }

        public String url() {
            return this.m_url;
        }

        public FeedEntry author(String t) {
            this.m_author = t;
            return this;
        }

        public FeedEntry category(String t) {
            this.m_categories.add(t);
            return this;
        }

        public FeedEntry content(String t) {
            this.m_content = t;
            return this;
        }

        public FeedEntry title(String t) {
            this.m_title = t;
            return this;
        }

        public FeedEntry url(String t) {
            this.m_url = t;
            return this;
        }
    }
}

