/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.syndication.rome;

import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.ow2.chameleon.syndication.FeedEntry;
import org.ow2.chameleon.syndication.FeedReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="org.ow2.chameleon.syndication.rome.reader", immediate=true)
@Provides
public class FeedReaderImpl
implements FeedReader,
Pojo {
    private InstanceManager __IM;
    private boolean __Fm_url;
    private URL m_url;
    private boolean __Fm_title;
    @ServiceProperty(name="org.ow2.chameleon.syndication.feed.title")
    private String m_title;
    private boolean __Fm_feedUrl;
    @ServiceProperty(name="org.ow2.chameleon.syndication.feed.url")
    String m_feedUrl;
    private boolean __Fm_recentCount;
    @Property(name="feed.recent", value="20")
    private int m_recentCount;
    private boolean __Fm_period;
    @Property(name="feed.period", value="3600000")
    private int m_period;
    private boolean __Fm_ea;
    @Requires(optional=true)
    private EventAdmin m_ea;
    private boolean __Fm_feed;
    private SyndFeed m_feed;
    private boolean __Fm_pool;
    private ScheduledExecutorService m_pool;
    private boolean __Fm_lastDate;
    private volatile Date m_lastDate;
    private boolean __Fm_logger;
    private Logger m_logger;
    private boolean __MsetUrl$java_lang_String;
    private boolean __Mload;
    private boolean __MgetEntries;
    private boolean __MgetURL;
    private boolean __MgetLastEntry;
    private boolean __MgetRecentEntries;
    private boolean __MgetTitle;
    private boolean __Mstop;
    private boolean __MpostEvent$org_ow2_chameleon_syndication_FeedEntry;

    URL __getm_url() {
        if (!this.__Fm_url) {
            return this.m_url;
        }
        return (URL)this.__IM.onGet((Object)this, "m_url");
    }

    void __setm_url(URL uRL) {
        if (!this.__Fm_url) {
            this.m_url = uRL;
            return;
        }
        this.__IM.onSet((Object)this, "m_url", (Object)uRL);
    }

    String __getm_title() {
        if (!this.__Fm_title) {
            return this.m_title;
        }
        return (String)this.__IM.onGet((Object)this, "m_title");
    }

    void __setm_title(String string) {
        if (!this.__Fm_title) {
            this.m_title = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_title", (Object)string);
    }

    String __getm_feedUrl() {
        if (!this.__Fm_feedUrl) {
            return this.m_feedUrl;
        }
        return (String)this.__IM.onGet((Object)this, "m_feedUrl");
    }

    void __setm_feedUrl(String string) {
        if (!this.__Fm_feedUrl) {
            this.m_feedUrl = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_feedUrl", (Object)string);
    }

    int __getm_recentCount() {
        if (!this.__Fm_recentCount) {
            return this.m_recentCount;
        }
        Object object = this.__IM.onGet((Object)this, "m_recentCount");
        Integer n = (Integer)object;
        return n;
    }

    void __setm_recentCount(int n) {
        if (!this.__Fm_recentCount) {
            this.m_recentCount = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "m_recentCount", (Object)n2);
    }

    int __getm_period() {
        if (!this.__Fm_period) {
            return this.m_period;
        }
        Object object = this.__IM.onGet((Object)this, "m_period");
        Integer n = (Integer)object;
        return n;
    }

    void __setm_period(int n) {
        if (!this.__Fm_period) {
            this.m_period = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "m_period", (Object)n2);
    }

    EventAdmin __getm_ea() {
        if (!this.__Fm_ea) {
            return this.m_ea;
        }
        return (EventAdmin)this.__IM.onGet((Object)this, "m_ea");
    }

    void __setm_ea(EventAdmin eventAdmin) {
        if (!this.__Fm_ea) {
            this.m_ea = eventAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "m_ea", (Object)eventAdmin);
    }

    SyndFeed __getm_feed() {
        if (!this.__Fm_feed) {
            return this.m_feed;
        }
        return (SyndFeed)this.__IM.onGet((Object)this, "m_feed");
    }

    void __setm_feed(SyndFeed syndFeed) {
        if (!this.__Fm_feed) {
            this.m_feed = syndFeed;
            return;
        }
        this.__IM.onSet((Object)this, "m_feed", (Object)syndFeed);
    }

    ScheduledExecutorService __getm_pool() {
        if (!this.__Fm_pool) {
            return this.m_pool;
        }
        return (ScheduledExecutorService)this.__IM.onGet((Object)this, "m_pool");
    }

    void __setm_pool(ScheduledExecutorService scheduledExecutorService) {
        if (!this.__Fm_pool) {
            this.m_pool = scheduledExecutorService;
            return;
        }
        this.__IM.onSet((Object)this, "m_pool", (Object)scheduledExecutorService);
    }

    Date __getm_lastDate() {
        if (!this.__Fm_lastDate) {
            return this.m_lastDate;
        }
        return (Date)this.__IM.onGet((Object)this, "m_lastDate");
    }

    void __setm_lastDate(Date date) {
        if (!this.__Fm_lastDate) {
            this.m_lastDate = date;
            return;
        }
        this.__IM.onSet((Object)this, "m_lastDate", (Object)date);
    }

    Logger __getm_logger() {
        if (!this.__Fm_logger) {
            return this.m_logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "m_logger");
    }

    void __setm_logger(Logger logger) {
        if (!this.__Fm_logger) {
            this.m_logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "m_logger", (Object)logger);
    }

    public FeedReaderImpl(URL url, int period, int count) throws FeedException, IOException {
        this.m_logger = LoggerFactory.getLogger((String)this.toString());
        this.m_url = url;
        this.m_pool = Executors.newScheduledThreadPool(1);
        this.m_recentCount = count;
        this.m_period = period;
        if (period != -1) {
            this.m_pool.scheduleAtFixedRate(new Runnable(){

                public void run() {
                    try {
                        FeedReaderImpl.this.__getm_logger().info("Reading " + FeedReaderImpl.this.__getm_url());
                        FeedReaderImpl.this.load();
                    }
                    catch (Exception e) {
                        FeedReaderImpl.this.__getm_logger().error("Cannot read the feed " + FeedReaderImpl.this.__getm_url(), (Throwable)e);
                    }
                }
            }, this.m_period, this.m_period, TimeUnit.MILLISECONDS);
        }
        this.load();
        this.m_title = this.m_feed.getTitle();
    }

    public FeedReaderImpl() throws FeedException, IOException {
        this(null);
    }

    private FeedReaderImpl(InstanceManager _manager) throws FeedException, IOException {
        this._setInstanceManager(_manager);
        this.__setm_logger(LoggerFactory.getLogger((String)this.toString()));
        this.__setm_pool(Executors.newScheduledThreadPool(1));
        this.__getm_pool().scheduleAtFixedRate(new Runnable(){

            public void run() {
                try {
                    FeedReaderImpl.this.__getm_logger().info("Reading " + FeedReaderImpl.this.__getm_url());
                    FeedReaderImpl.this.load();
                }
                catch (Exception e) {
                    FeedReaderImpl.this.__getm_logger().error("Cannot read the feed " + FeedReaderImpl.this.__getm_url(), (Throwable)e);
                }
            }
        }, this.__getm_period(), this.__getm_period(), TimeUnit.MILLISECONDS);
    }

    public void setUrl(String string) throws FeedException, IOException {
        if (!this.__MsetUrl$java_lang_String) {
            this.__setUrl(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setUrl$java_lang_String", new Object[]{string});
            this.__setUrl(string);
            this.__IM.onExit((Object)this, "setUrl$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setUrl$java_lang_String", throwable);
            throw throwable;
        }
    }

    @Property(name="feed.url", mandatory=true)
    private void __setUrl(String u) throws FeedException, IOException {
        this.__setm_url(new URL(u));
        this.__setm_feedUrl(u);
        this.load();
        this.__setm_title(this.__getm_feed().getTitle());
    }

    private synchronized void load() throws FeedException, IOException {
        if (!this.__Mload) {
            this.__load();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "load", new Object[0]);
            this.__load();
            this.__IM.onExit((Object)this, "load", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "load", throwable);
            throw throwable;
        }
    }

    private void __load() throws FeedException, IOException {
        SyndFeedInput input = new SyndFeedInput();
        this.__setm_feed(input.build(new XmlReader(this.__getm_url())));
        for (FeedEntry entry : this.getRecentEntries()) {
            if (this.__getm_lastDate() != null && !this.__getm_lastDate().before(entry.publicationDate())) continue;
            this.postEvent(entry);
        }
        if (this.getLastEntry() != null) {
            this.__setm_lastDate(this.getLastEntry().publicationDate());
        }
    }

    public synchronized List<FeedEntry> getEntries() {
        List<FeedEntry> list;
        if (!this.__MgetEntries) {
            return this.__getEntries();
        }
        try {
            this.__IM.onEntry((Object)this, "getEntries", new Object[0]);
            list = this.__getEntries();
            this.__IM.onExit((Object)this, "getEntries", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getEntries", throwable);
            throw throwable;
        }
        return list;
    }

    private List<FeedEntry> __getEntries() {
        List entries = this.__getm_feed().getEntries();
        ArrayList<FeedEntry> result = new ArrayList<FeedEntry>();
        for (SyndEntry e : entries) {
            result.add(new FeedEntryImpl(e));
        }
        return result;
    }

    public String getURL() {
        String string;
        if (!this.__MgetURL) {
            return this.__getURL();
        }
        try {
            this.__IM.onEntry((Object)this, "getURL", new Object[0]);
            string = this.__getURL();
            this.__IM.onExit((Object)this, "getURL", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getURL", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getURL() {
        return this.__getm_url().toExternalForm();
    }

    public synchronized FeedEntry getLastEntry() {
        FeedEntry feedEntry;
        if (!this.__MgetLastEntry) {
            return this.__getLastEntry();
        }
        try {
            this.__IM.onEntry((Object)this, "getLastEntry", new Object[0]);
            feedEntry = this.__getLastEntry();
            this.__IM.onExit((Object)this, "getLastEntry", (Object)feedEntry);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getLastEntry", throwable);
            throw throwable;
        }
        return feedEntry;
    }

    private FeedEntry __getLastEntry() {
        List entries = this.__getm_feed().getEntries();
        if (entries.isEmpty()) {
            return null;
        }
        return new FeedEntryImpl((SyndEntry)entries.get(0));
    }

    public synchronized List<FeedEntry> getRecentEntries() {
        List<FeedEntry> list;
        if (!this.__MgetRecentEntries) {
            return this.__getRecentEntries();
        }
        try {
            this.__IM.onEntry((Object)this, "getRecentEntries", new Object[0]);
            list = this.__getRecentEntries();
            this.__IM.onExit((Object)this, "getRecentEntries", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRecentEntries", throwable);
            throw throwable;
        }
        return list;
    }

    private List<FeedEntry> __getRecentEntries() {
        List entries = this.__getm_feed().getEntries();
        ArrayList<FeedEntry> result = new ArrayList<FeedEntry>();
        int count = 0;
        for (SyndEntry e : entries) {
            if (count == this.__getm_recentCount()) {
                return result;
            }
            result.add(new FeedEntryImpl(e));
            ++count;
        }
        return result;
    }

    public String getTitle() {
        String string;
        if (!this.__MgetTitle) {
            return this.__getTitle();
        }
        try {
            this.__IM.onEntry((Object)this, "getTitle", new Object[0]);
            string = this.__getTitle();
            this.__IM.onExit((Object)this, "getTitle", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTitle", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getTitle() {
        return this.__getm_title();
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        this.__getm_pool().shutdownNow();
    }

    public void postEvent(FeedEntry feedEntry) {
        if (!this.__MpostEvent$org_ow2_chameleon_syndication_FeedEntry) {
            this.__postEvent(feedEntry);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "postEvent$org_ow2_chameleon_syndication_FeedEntry", new Object[]{feedEntry});
            this.__postEvent(feedEntry);
            this.__IM.onExit((Object)this, "postEvent$org_ow2_chameleon_syndication_FeedEntry", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postEvent$org_ow2_chameleon_syndication_FeedEntry", throwable);
            throw throwable;
        }
    }

    private void __postEvent(FeedEntry entry) {
        if (this.__getm_ea() == null) {
            return;
        }
        Properties data = new Properties();
        if (entry.author() != null) {
            ((Dictionary)data).put("entry.author", entry.author());
        }
        if (entry.categories() != null && !entry.categories().isEmpty()) {
            ((Dictionary)data).put("entry.categories", entry.categories());
        }
        if (entry.content() != null) {
            ((Dictionary)data).put("entry.content", entry.content());
        }
        if (entry.publicationDate() != null) {
            ((Dictionary)data).put("entry.date", entry.publicationDate());
        }
        if (entry.title() != null) {
            ((Dictionary)data).put("entry.title", entry.title());
        }
        if (entry.url() != null) {
            ((Dictionary)data).put("entry.url", entry.url());
        }
        if (this.__getm_feed().getTitle() != null) {
            ((Dictionary)data).put("feed.title", this.__getm_feed().getTitle());
        }
        if (this.__getm_feedUrl() != null) {
            ((Dictionary)data).put("feed.url", this.__getm_feedUrl());
        }
        Event event = new Event("org/ow2/chameleon/syndication", (Dictionary)data);
        this.__getm_ea().postEvent(event);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_logger")) {
                this.__Fm_logger = true;
            }
            if (set.contains("m_feed")) {
                this.__Fm_feed = true;
            }
            if (set.contains("m_ea")) {
                this.__Fm_ea = true;
            }
            if (set.contains("m_feedUrl")) {
                this.__Fm_feedUrl = true;
            }
            if (set.contains("m_pool")) {
                this.__Fm_pool = true;
            }
            if (set.contains("m_lastDate")) {
                this.__Fm_lastDate = true;
            }
            if (set.contains("m_recentCount")) {
                this.__Fm_recentCount = true;
            }
            if (set.contains("m_title")) {
                this.__Fm_title = true;
            }
            if (set.contains("m_url")) {
                this.__Fm_url = true;
            }
            if (set.contains("m_period")) {
                this.__Fm_period = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setUrl$java_lang_String")) {
                this.__MsetUrl$java_lang_String = true;
            }
            if (set.contains("load")) {
                this.__Mload = true;
            }
            if (set.contains("getEntries")) {
                this.__MgetEntries = true;
            }
            if (set.contains("getURL")) {
                this.__MgetURL = true;
            }
            if (set.contains("getLastEntry")) {
                this.__MgetLastEntry = true;
            }
            if (set.contains("getRecentEntries")) {
                this.__MgetRecentEntries = true;
            }
            if (set.contains("getTitle")) {
                this.__MgetTitle = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("postEvent$org_ow2_chameleon_syndication_FeedEntry")) {
                this.__MpostEvent$org_ow2_chameleon_syndication_FeedEntry = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FeedEntryImpl
    implements FeedEntry {
        private final String m_author;
        private final String m_content;
        private final Date m_date;
        private final String m_title;
        private final String m_url;
        private final List<String> m_categories;

        public FeedEntryImpl(SyndEntry e) {
            this.m_author = e.getAuthor();
            this.m_content = e.getDescription().getValue();
            Date d = e.getPublishedDate();
            this.m_date = d == null ? e.getUpdatedDate() : d;
            this.m_title = e.getTitle();
            this.m_url = e.getLink();
            List categories = e.getCategories();
            this.m_categories = new ArrayList<String>();
            for (SyndCategory cat : categories) {
                this.m_categories.add(cat.getName());
            }
        }

        public String author() {
            return this.m_author;
        }

        public List<String> categories() {
            return Collections.unmodifiableList(this.m_categories);
        }

        public String content() {
            return this.m_content;
        }

        public Date publicationDate() {
            return this.m_date;
        }

        public String title() {
            return this.m_title;
        }

        public String url() {
            return this.m_url;
        }

        public FeedEntry author(String t) {
            throw new UnsupportedOperationException("Cannot modify a read only feed entry");
        }

        public FeedEntry category(String t) {
            throw new UnsupportedOperationException("Cannot modify a read only feed entry");
        }

        public FeedEntry content(String t) {
            throw new UnsupportedOperationException("Cannot modify a read only feed entry");
        }

        public FeedEntry title(String t) {
            throw new UnsupportedOperationException("Cannot modify a read only feed entry");
        }

        public FeedEntry url(String t) {
            throw new UnsupportedOperationException("Cannot modify a read only feed entry");
        }
    }
}

