/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.testing.helpers;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class OSGiHelper {
    private BundleContext context;
    private List<ServiceReference> m_references = new ArrayList<ServiceReference>();

    public OSGiHelper(BundleContext context) {
        this.context = context;
    }

    public void dispose() {
        for (int i = 0; i < this.m_references.size(); ++i) {
            this.context.ungetService(this.m_references.get(i));
        }
        this.m_references.clear();
    }

    public BundleContext getContext() {
        return this.context;
    }

    public static Object getServiceObject(Bundle bundle, String itf, String filter) {
        ServiceReference ref = OSGiHelper.getServiceReference(bundle, itf, filter);
        if (ref != null) {
            return bundle.getBundleContext().getService(ref);
        }
        return null;
    }

    public static Object[] getServiceObjects(Bundle bundle, String itf, String filter) {
        ServiceReference[] refs = OSGiHelper.getServiceReferences(bundle, itf, filter);
        if (refs != null) {
            Object[] list = new Object[refs.length];
            for (int i = 0; i < refs.length; ++i) {
                list[i] = bundle.getBundleContext().getService(refs[i]);
            }
            return list;
        }
        return new Object[0];
    }

    public static ServiceReference getServiceReference(Bundle bundle, String itf, String filter) {
        ServiceReference[] refs = OSGiHelper.getServiceReferences(bundle, itf, filter);
        if (refs.length != 0) {
            return refs[0];
        }
        return null;
    }

    public boolean isServiceAvailable(String itf) {
        ServiceReference ref = this.getServiceReference(itf, null);
        return ref != null;
    }

    public boolean isServiceAvailableByPID(String itf, String pid) {
        ServiceReference ref = this.getServiceReferenceByPID(itf, pid);
        return ref != null;
    }

    public static ServiceReference getServiceReferenceByPID(Bundle bundle, String itf, String pid) {
        String filter = "(service.pid=" + pid + ")";
        ServiceReference[] refs = OSGiHelper.getServiceReferences(bundle, itf, filter);
        if (refs == null) {
            return null;
        }
        if (refs.length == 1) {
            return refs[0];
        }
        throw new IllegalStateException("A service lookup by PID returned several providers (" + refs.length + ")" + " for " + itf + " with pid=" + pid);
    }

    public static ServiceReference[] getServiceReferences(Bundle bundle, String itf, String filter) {
        ServiceReference[] refs = null;
        try {
            refs = bundle.getBundleContext().getServiceReferences(itf, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Cannot get service references: " + e.getMessage());
        }
        if (refs == null) {
            return new ServiceReference[0];
        }
        return refs;
    }

    public Object getServiceObject(String itf, String filter) {
        ServiceReference ref = this.getServiceReference(itf, filter);
        if (ref != null) {
            this.m_references.add(ref);
            return this.context.getService(ref);
        }
        return null;
    }

    public Object getServiceObject(ServiceReference ref) {
        if (ref != null) {
            this.m_references.add(ref);
            return this.context.getService(ref);
        }
        return null;
    }

    public Object[] getServiceObjects(String itf, String filter) {
        ServiceReference[] refs = this.getServiceReferences(itf, filter);
        if (refs != null) {
            Object[] list = new Object[refs.length];
            for (int i = 0; i < refs.length; ++i) {
                this.m_references.add(refs[i]);
                list[i] = this.context.getService(refs[i]);
            }
            return list;
        }
        return new Object[0];
    }

    public ServiceReference getServiceReference(String itf, String filter) {
        return OSGiHelper.getServiceReference(this.context.getBundle(), itf, filter);
    }

    public ServiceReference getServiceReference(String itf) {
        return OSGiHelper.getServiceReference(this.context.getBundle(), itf, null);
    }

    public ServiceReference getServiceReferenceByPID(String itf, String pid) {
        return OSGiHelper.getServiceReferenceByPID(this.context.getBundle(), itf, pid);
    }

    public ServiceReference[] getServiceReferences(String itf, String filter) {
        return OSGiHelper.getServiceReferences(this.context.getBundle(), itf, filter);
    }

    public PackageAdmin getPackageAdmin() {
        PackageAdmin pa = (PackageAdmin)this.getServiceObject(PackageAdmin.class.getName(), null);
        if (pa == null) {
            Assert.fail((String)"No package admin available");
        }
        return pa;
    }

    public void refresh() {
        this.getPackageAdmin().refreshPackages(null);
    }

    public void waitForService(String itf, String filter, long timeout) {
        if (timeout == 0L) {
            timeout = 10000L;
        }
        ServiceReference[] refs = this.getServiceReferences(itf, filter);
        long begin = System.currentTimeMillis();
        if (refs.length != 0) {
            return;
        }
        while (refs.length == 0) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long now = System.currentTimeMillis();
            if (now - begin > timeout) {
                Assert.fail((String)("Timeout ... no services matching with the request after " + timeout + "ms"));
            }
            refs = this.getServiceReferences(itf, filter);
        }
    }

    public Bundle installBundle(String url) {
        try {
            return this.context.installBundle(url);
        }
        catch (BundleException e) {
            Assert.fail((String)("Cannot install the bundle " + url + " : " + e.getMessage()));
            return null;
        }
    }

    public Bundle installBundle(String url, InputStream stream) {
        try {
            return this.context.installBundle(url, stream);
        }
        catch (BundleException e) {
            Assert.fail((String)("Cannot install the bundle " + url + " : " + e.getMessage()));
            return null;
        }
    }

    public Bundle installAndStart(String url) {
        Bundle bundle = this.installBundle(url);
        try {
            bundle.start();
        }
        catch (BundleException e) {
            Assert.fail((String)("Cannot start the bundle " + url + " : " + e.getMessage()));
        }
        return bundle;
    }

    public Bundle installAndStart(String url, InputStream stream) {
        Bundle bundle = this.installBundle(url, stream);
        try {
            bundle.start();
        }
        catch (BundleException e) {
            Assert.fail((String)("Cannot start the bundle " + url + " : " + e.getMessage()));
        }
        return bundle;
    }

    public Bundle getBundle(long bundleId) {
        return this.context.getBundle(bundleId);
    }

    public Bundle getBundle(String name) {
        Bundle[] bundles = this.context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            if (!name.equals(bundles[i].getSymbolicName())) continue;
            return bundles[i];
        }
        Assert.fail((String)("No bundles with the given symbolic name " + name));
        return null;
    }
}

