/*
 * Copyright 2009 OW2 Chameleon
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.chameleon.url.shortener.service;


/**
 * URL Shortener Service interface.
 * This service allows creating short url from
 * long url.
 * The expiration date of generated URLs are implementation
 * dependent.
 * @author Clement Escoffier clement.escoffier@akquinet.de
 */
public interface URLShortenerService {

    /**
     * Computes a short URL for the given long URL.
     * @param longURL the long URL
     * @return the short URL
     * @throws Exception an error has occurred (refer to the message).
     */
    String getShortURL(String longURL) throws Exception;


}
