/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.shrten;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ow2.chameleon.url.shortener.service.URLShortenerService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ShrtenURLShortener
implements URLShortenerService {
    String m_endpoint;
    String m_parameter;

    public String getShortURL(String url) throws Exception {
        if (url == null || url.length() == 0) {
            throw new NullPointerException("The given URL cannot be null or empty");
        }
        URL query = new URL(this.m_endpoint + "?" + this.m_parameter + "=" + url);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(query.openStream());
        boolean success = false;
        String response = null;
        Element node = doc.getDocumentElement();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeName().equals("success")) {
                success = n.getChildNodes().item(0).getNodeValue().equals("true");
                continue;
            }
            if (!n.getNodeName().equals("shorturl")) continue;
            response = n.getChildNodes().item(0).getNodeValue();
        }
        if (success) {
            return response;
        }
        throw new Exception("Cannot compute the short url");
    }

    String read(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

