/*
 * Copyright 2009 OW2 Chameleon
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.chameleon.shrten;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import junit.framework.Assert;
import junit.framework.TestCase;


public class ShrtenURLShortenerTest extends TestCase {

    private ShrtenURLShortener svc;


    public void setUp() {
        svc = new ShrtenURLShortener();
        // Inject the endpoint and the url
        svc.m_endpoint = "http://shrten.com/api";
        svc.m_parameter = "format=xml&url";
    }

    public void testOK() throws Exception {
        String url = svc.getShortURL("http://perdu.com");
        Assert.assertNotNull(url);
        Assert.assertFalse(url.length() == 0);
        Assert.assertTrue(url.startsWith("http://"));

        URL u = new URL(url);
        HttpURLConnection connection = (HttpURLConnection) u.openConnection();

        Assert.assertEquals(200, connection.getResponseCode());
        String response = svc.read(connection.getInputStream());
        Assert.assertTrue(response.contains("Perdu sur l'Internet ?"));
    }

    public void testBadURL() throws Exception {
        String url = svc.getShortURL("http://perdu.com@");
        Assert.assertNotNull(url);
        Assert.assertFalse(url.length() == 0);
        Assert.assertTrue(url.startsWith("http://"));

        URL u = new URL(url);
        HttpURLConnection connection = (HttpURLConnection) u.openConnection();

        String response = null;
        try {
            InputStream is = connection.getInputStream();
            response = svc.read(is);
        } catch (IOException e) {
            // OK
            return;
        }

        fail("Connection error expected : " + response);

    }


    public void testNull() {
        try {
            svc.getShortURL(null);
        } catch (NullPointerException e) {
            // OK
            return;
        } catch (Exception e) { }
        fail("Exception expected");
    }

    public void testEmpty() {
        try {
            svc.getShortURL("");
        } catch (NullPointerException e) {
            // OK
            return;
        } catch (Exception e) { }
        fail("Exception expected");
    }

}
