/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.ant;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class MultipleAnt
extends Ant
implements FilenameFilter {
    protected File directory = null;
    protected String antFile = null;
    protected String target = null;
    protected boolean useDefaultExcludes = true;
    protected FileSet fileset = new FileSet();

    public void execute() throws BuildException {
        String string = null;
        try {
            if (this.directory == null) {
                throw new BuildException("The Dir parameter is required !");
            }
            DirectoryScanner directoryScanner = this.getDirectoryScanner(this.directory);
            String[] stringArray = directoryScanner.getIncludedDirectories();
            if (stringArray == null || stringArray.length == 0) {
                this.log("No directory found", 4);
                return;
            }
            int n = 0;
            while (n < stringArray.length) {
                File file = new File(this.directory.getAbsolutePath() + File.separator + stringArray[n]);
                this.log("Directory=" + file.getAbsolutePath(), 4);
                if (this.antFile != null) {
                    string = file.getAbsolutePath() + File.separator + this.antFile;
                    if (new File(string).exists()) {
                        this.log("execute=" + string, 4);
                        super.setAntfile(string);
                        super.setTarget(this.target);
                        super.execute();
                    }
                } else {
                    String[] stringArray2 = file.list(this);
                    if (stringArray2 == null) {
                        this.log("No xml file found", 4);
                    } else {
                        int n2 = 0;
                        while (n2 < stringArray2.length) {
                            string = this.directory.getAbsolutePath() + File.separator + stringArray2[n2];
                            this.log("execute=" + string, 4);
                            super.setAntfile(string);
                            super.setTarget(this.target);
                            super.execute();
                            ++n2;
                        }
                    }
                }
                ++n;
            }
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception exception) {
            System.out.println("Error in " + string + " file:\n\t" + exception.getMessage());
            throw new BuildException((Throwable)exception);
        }
    }

    public void setDir(File file) {
        this.directory = file;
    }

    public void setAntFile(String string) {
        this.antFile = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public boolean accept(File file, String string) {
        return string != null && file != null && file.equals(this.directory) && string.endsWith(".xml");
    }

    public PatternSet.NameEntry createInclude() {
        return this.fileset.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        return this.fileset.createIncludesFile();
    }

    public PatternSet.NameEntry createExclude() {
        return this.fileset.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        return this.fileset.createExcludesFile();
    }

    public PatternSet createPatternSet() {
        return this.fileset.createPatternSet();
    }

    public void setIncludes(String string) {
        this.fileset.setIncludes(string);
    }

    public void setExcludes(String string) {
        this.fileset.setExcludes(string);
    }

    public void setDefaultexcludes(boolean bl) {
        this.useDefaultExcludes = bl;
    }

    protected DirectoryScanner getDirectoryScanner(File file) {
        this.fileset.setDir(file);
        this.fileset.setDefaultexcludes(this.useDefaultExcludes);
        return this.fileset.getDirectoryScanner(((ProjectComponent)this).project);
    }

    public void setIncludesfile(File file) {
        this.fileset.setIncludesfile(file);
    }

    public void setExcludesfile(File file) {
        this.fileset.setExcludesfile(file);
    }
}

