/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class MultipleCopy
extends Copy {
    protected File basedir = null;
    protected String myFile = null;
    protected boolean notReplace = true;
    protected boolean useDefaultExcludes = true;
    protected FileSet fileset = new FileSet();

    public void execute() throws BuildException {
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.basedir);
        String[] stringArray = directoryScanner.getIncludedDirectories();
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (this.myFile == null) {
                string = this.basedir + "/" + stringArray[n];
                super.setTodir(new File(string));
                super.setTofile(null);
            } else {
                super.setTodir(null);
                string = this.basedir + "/" + stringArray[n] + "/" + this.myFile;
                super.setTofile(new File(string));
            }
            this.log("File name = " + string, 4);
            this.copy();
            ++n;
        }
    }

    public void copy() throws BuildException {
        this.validateAttributes();
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.destFile == null) {
                    this.destFile = new File(this.destDir, this.file.getName());
                }
                if (!this.destFile.exists()) {
                    this.fileCopyMap.put(this.file.getAbsolutePath(), this.destFile.getAbsolutePath());
                } else if (!this.notReplace && (this.forceOverwrite || this.file.lastModified() > this.destFile.lastModified())) {
                    this.fileCopyMap.put(this.file.getAbsolutePath(), this.destFile.getAbsolutePath());
                } else {
                    this.log(this.file + " omitted as " + this.destFile + " is up to date.", 3);
                }
            } else {
                String string = "Could not find file " + this.file.getAbsolutePath() + " to copy.";
                this.log(string);
                throw new BuildException(string);
            }
        }
        int n = 0;
        while (n < this.filesets.size()) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(n);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(((ProjectComponent)this).project);
            File file = fileSet.getDir(((ProjectComponent)this).project);
            String[] stringArray = directoryScanner.getIncludedFiles();
            String[] stringArray2 = directoryScanner.getIncludedDirectories();
            this.scan(file, this.destDir, stringArray, stringArray2);
            ++n;
        }
        this.doFileOperations();
        if (this.destFile != null) {
            this.destDir = null;
        }
    }

    public void setNotReplace(boolean bl) {
        this.notReplace = bl;
    }

    public void setTodir(File file) {
        this.basedir = file;
    }

    public void setTofile(String string) {
        this.myFile = string;
    }

    public PatternSet.NameEntry createInclude() {
        return this.fileset.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        return this.fileset.createIncludesFile();
    }

    public PatternSet.NameEntry createExclude() {
        return this.fileset.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        return this.fileset.createExcludesFile();
    }

    public PatternSet createPatternSet() {
        return this.fileset.createPatternSet();
    }

    public void setIncludes(String string) {
        this.fileset.setIncludes(string);
    }

    public void setExcludes(String string) {
        this.fileset.setExcludes(string);
    }

    public void setDefaultexcludes(boolean bl) {
        this.useDefaultExcludes = bl;
    }

    protected DirectoryScanner getDirectoryScanner(File file) {
        this.fileset.setDir(file);
        this.fileset.setDefaultexcludes(this.useDefaultExcludes);
        return this.fileset.getDirectoryScanner(((ProjectComponent)this).project);
    }

    public void setIncludesfile(File file) {
        this.fileset.setIncludesfile(file);
    }

    public void setExcludesfile(File file) {
        this.fileset.setExcludesfile(file);
    }
}

