/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;
import gov.nist.core.NameValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameValueList
implements Serializable,
Map<String, NameValue> {
    private static final long serialVersionUID = -6998271876574260243L;
    private Map<String, NameValue> hmap;
    private String separator = ";";

    public NameValueList() {
        this.hmap = new LinkedHashMap<String, NameValue>();
    }

    public NameValueList(boolean sync) {
        this.hmap = sync ? new ConcurrentHashMap<String, NameValue>() : new LinkedHashMap<String, NameValue>();
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String encode() {
        return this.encode(new StringBuffer()).toString();
    }

    public StringBuffer encode(StringBuffer buffer) {
        Iterator<NameValue> iterator;
        if (!this.hmap.isEmpty() && (iterator = this.hmap.values().iterator()).hasNext()) {
            while (true) {
                NameValue obj;
                if ((obj = iterator.next()) instanceof GenericObject) {
                    GenericObject gobj = obj;
                    gobj.encode(buffer);
                } else {
                    buffer.append(obj.toString());
                }
                if (!iterator.hasNext()) break;
                buffer.append(this.separator);
            }
        }
        return buffer;
    }

    public String toString() {
        return this.encode();
    }

    public void set(NameValue nv) {
        this.hmap.put(nv.getName().toLowerCase(), nv);
    }

    public void set(String name, Object value) {
        NameValue nameValue = new NameValue(name, value);
        this.hmap.put(name.toLowerCase(), nameValue);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (!otherObject.getClass().equals(this.getClass())) {
            return false;
        }
        NameValueList other = (NameValueList)otherObject;
        if (this.hmap.size() != other.hmap.size()) {
            return false;
        }
        for (String key : this.hmap.keySet()) {
            NameValue nv1 = this.getNameValue(key);
            NameValue nv2 = other.hmap.get(key);
            if (nv2 == null) {
                return false;
            }
            if (nv2.equals(nv1)) continue;
            return false;
        }
        return true;
    }

    public Object getValue(String name) {
        NameValue nv = this.getNameValue(name.toLowerCase());
        if (nv != null) {
            return nv.getValueAsObject();
        }
        return null;
    }

    public NameValue getNameValue(String name) {
        return this.hmap.get(name.toLowerCase());
    }

    public boolean hasNameValue(String name) {
        return this.hmap.containsKey(name.toLowerCase());
    }

    public boolean delete(String name) {
        String lcName = name.toLowerCase();
        if (this.hmap.containsKey(lcName)) {
            this.hmap.remove(lcName);
            return true;
        }
        return false;
    }

    public Object clone() {
        NameValueList retval = new NameValueList();
        retval.setSeparator(this.separator);
        Iterator<NameValue> it = this.hmap.values().iterator();
        while (it.hasNext()) {
            retval.set((NameValue)it.next().clone());
        }
        return retval;
    }

    @Override
    public int size() {
        return this.hmap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hmap.isEmpty();
    }

    public Iterator<NameValue> iterator() {
        return this.hmap.values().iterator();
    }

    public Iterator<String> getNames() {
        return this.hmap.keySet().iterator();
    }

    public String getParameter(String name) {
        Object val = this.getValue(name);
        if (val == null) {
            return null;
        }
        if (val instanceof GenericObject) {
            return ((GenericObject)val).encode();
        }
        return val.toString();
    }

    @Override
    public void clear() {
        this.hmap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hmap.containsKey(key.toString().toLowerCase());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.hmap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, NameValue>> entrySet() {
        return this.hmap.entrySet();
    }

    @Override
    public NameValue get(Object key) {
        return this.hmap.get(key.toString().toLowerCase());
    }

    @Override
    public Set<String> keySet() {
        return this.hmap.keySet();
    }

    @Override
    public NameValue put(String name, NameValue nameValue) {
        return this.hmap.put(name, nameValue);
    }

    @Override
    public void putAll(Map<? extends String, ? extends NameValue> map) {
        this.hmap.putAll(map);
    }

    @Override
    public NameValue remove(Object key) {
        return this.hmap.remove(key.toString().toLowerCase());
    }

    @Override
    public Collection<NameValue> values() {
        return this.hmap.values();
    }
}

