/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexer;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.htmlparser.Node;
import org.htmlparser.lexer.Cursor;
import org.htmlparser.lexer.Page;
import org.htmlparser.lexer.nodes.NodeFactory;
import org.htmlparser.lexer.nodes.PageAttribute;
import org.htmlparser.lexer.nodes.RemarkNode;
import org.htmlparser.lexer.nodes.StringNode;
import org.htmlparser.lexer.nodes.TagNode;
import org.htmlparser.util.ParserException;

public class Lexer
implements Serializable,
NodeFactory {
    protected Page mPage;
    protected Cursor mCursor;
    protected NodeFactory mFactory;
    protected static int mDebugLineTrigger = -1;

    public Lexer() {
        this(new Page(""));
    }

    public Lexer(Page page) {
        this.setPage(page);
        this.setCursor(new Cursor(page, 0));
        this.setNodeFactory(this);
    }

    public Lexer(String text) {
        this(new Page(text));
    }

    public Lexer(URLConnection connection) throws ParserException {
        this(new Page(connection));
    }

    public void reset() {
        this.getPage().reset();
        this.setCursor(new Cursor(this.getPage(), 0));
    }

    public Page getPage() {
        return this.mPage;
    }

    public void setPage(Page page) {
        if (null == page) {
            throw new IllegalArgumentException("page cannot be null");
        }
        this.mPage = page;
    }

    public Cursor getCursor() {
        return this.mCursor;
    }

    public void setCursor(Cursor cursor) {
        if (null == cursor) {
            throw new IllegalArgumentException("cursor cannot be null");
        }
        this.mCursor = cursor;
    }

    public NodeFactory getNodeFactory() {
        return this.mFactory;
    }

    public void setNodeFactory(NodeFactory factory) {
        if (null == factory) {
            throw new IllegalArgumentException("node factory cannot be null");
        }
        this.mFactory = factory;
    }

    public int getPosition() {
        return this.getCursor().getPosition();
    }

    public void setPosition(int position) {
        this.getCursor().setPosition(position);
    }

    public int getCurrentLineNumber() {
        return this.getPage().row(this.getCursor());
    }

    public String getCurrentLine() {
        return this.getPage().getLine(this.getCursor());
    }

    public Node nextNode() throws ParserException {
        return this.nextNode(false);
    }

    public Node nextNode(boolean quotesmart) throws ParserException {
        Node ret;
        Page page;
        int lineno;
        if (-1 != mDebugLineTrigger && mDebugLineTrigger < (lineno = (page = this.getPage()).row(this.mCursor))) {
            mDebugLineTrigger = lineno + 1;
        }
        Cursor probe = this.mCursor.dup();
        char ch = this.mPage.getCharacter(probe);
        switch (ch) {
            case '\u0000': {
                ret = null;
                break;
            }
            case '<': {
                ch = this.mPage.getCharacter(probe);
                if ('\u0000' == ch) {
                    ret = this.makeString(probe);
                    break;
                }
                if ('%' == ch) {
                    probe.retreat();
                    ret = this.parseJsp(probe);
                    break;
                }
                if ('/' == ch || '%' == ch || Character.isLetter(ch)) {
                    probe.retreat();
                    ret = this.parseTag(probe);
                    break;
                }
                if ('!' == ch) {
                    ch = this.mPage.getCharacter(probe);
                    if ('\u0000' == ch) {
                        ret = this.makeString(probe);
                        break;
                    }
                    if ('>' == ch) {
                        ret = this.makeRemark(probe);
                        break;
                    }
                    probe.retreat();
                    if ('-' == ch) {
                        ret = this.parseRemark(probe, quotesmart);
                        break;
                    }
                    probe.retreat();
                    ret = this.parseTag(probe);
                    break;
                }
                ret = this.parseString(probe, quotesmart);
                break;
            }
            default: {
                probe.retreat();
                ret = this.parseString(probe, quotesmart);
            }
        }
        return ret;
    }

    protected void scanJIS(Cursor cursor) throws ParserException {
        boolean done = false;
        int state = 0;
        block5: while (!done) {
            char ch = this.mPage.getCharacter(cursor);
            if ('\u0000' == ch) {
                done = true;
                continue;
            }
            switch (state) {
                case 0: {
                    if ('\u001b' != ch) continue block5;
                    state = 1;
                    continue block5;
                }
                case 1: {
                    if ('(' == ch) {
                        state = 2;
                        continue block5;
                    }
                    state = 0;
                    continue block5;
                }
                case 2: {
                    if ('J' == ch) {
                        done = true;
                        continue block5;
                    }
                    state = 0;
                    continue block5;
                }
            }
            throw new IllegalStateException("how the fuck did we get in state " + state);
        }
    }

    protected Node parseString(Cursor cursor, boolean quotesmart) throws ParserException {
        boolean done = false;
        char quote = '\u0000';
        while (!done) {
            char ch = this.mPage.getCharacter(cursor);
            if ('\u0000' == ch) {
                done = true;
                continue;
            }
            if ('\u001b' == ch) {
                ch = this.mPage.getCharacter(cursor);
                if ('\u0000' == ch) {
                    done = true;
                    continue;
                }
                if ('$' == ch) {
                    ch = this.mPage.getCharacter(cursor);
                    if ('\u0000' == ch) {
                        done = true;
                        continue;
                    }
                    if ('B' == ch) {
                        this.scanJIS(cursor);
                        continue;
                    }
                    cursor.retreat();
                    cursor.retreat();
                    continue;
                }
                cursor.retreat();
                continue;
            }
            if (quotesmart && '\u0000' == quote && ('\'' == ch || '\"' == ch)) {
                quote = ch;
                continue;
            }
            if (quotesmart && '\u0000' != quote && '\\' == ch) {
                ch = this.mPage.getCharacter(cursor);
                if (ch == '\\' || ch == quote) continue;
                cursor.retreat();
                continue;
            }
            if (quotesmart && ch == quote) {
                quote = '\u0000';
                continue;
            }
            if (quotesmart && '\u0000' == quote && ch == '/') {
                ch = this.mPage.getCharacter(cursor);
                if ('\u0000' == ch) {
                    done = true;
                    continue;
                }
                if ('/' == ch) {
                    while ((ch = this.mPage.getCharacter(cursor)) != '\u0000' && ch != '\n') {
                    }
                    continue;
                }
                if ('*' == ch) {
                    while (true) {
                        if ((ch = this.mPage.getCharacter(cursor)) != '\u0000' && ch != '*') {
                            continue;
                        }
                        ch = this.mPage.getCharacter(cursor);
                        if (ch == '*') {
                            cursor.retreat();
                        }
                        if (ch == '\u0000' || ch == '/') break;
                    }
                    continue;
                }
                cursor.retreat();
                continue;
            }
            if ('\u0000' != quote || '<' != ch) continue;
            ch = this.mPage.getCharacter(cursor);
            if ('\u0000' == ch) {
                done = true;
                continue;
            }
            if ('/' == ch || Character.isLetter(ch) || '!' == ch || '%' == ch) {
                done = true;
                cursor.retreat();
                cursor.retreat();
                continue;
            }
            cursor.retreat();
        }
        return this.makeString(cursor);
    }

    protected Node makeString(Cursor cursor) throws ParserException {
        Node ret;
        int begin = this.mCursor.getPosition();
        int end = cursor.getPosition();
        int length = end - begin;
        if (0 != length) {
            this.mCursor = cursor;
            ret = this.getNodeFactory().createStringNode(this.getPage(), begin, end);
        } else {
            ret = null;
        }
        return ret;
    }

    private void whitespace(Vector attributes, int[] bookmarks) {
        if (bookmarks[1] > bookmarks[0]) {
            attributes.addElement(new PageAttribute(this.mPage, -1, -1, bookmarks[0], bookmarks[1], '\u0000'));
        }
    }

    private void standalone(Vector attributes, int[] bookmarks) {
        attributes.addElement(new PageAttribute(this.mPage, bookmarks[1], bookmarks[2], -1, -1, '\u0000'));
    }

    private void empty(Vector attributes, int[] bookmarks) {
        attributes.addElement(new PageAttribute(this.mPage, bookmarks[1], bookmarks[2], bookmarks[2] + 1, -1, '\u0000'));
    }

    private void naked(Vector attributes, int[] bookmarks) {
        attributes.addElement(new PageAttribute(this.mPage, bookmarks[1], bookmarks[2], bookmarks[3], bookmarks[4], '\u0000'));
    }

    private void single_quote(Vector attributes, int[] bookmarks) {
        attributes.addElement(new PageAttribute(this.mPage, bookmarks[1], bookmarks[2], bookmarks[4] + 1, bookmarks[5], '\''));
    }

    private void double_quote(Vector attributes, int[] bookmarks) {
        attributes.addElement(new PageAttribute(this.mPage, bookmarks[1], bookmarks[2], bookmarks[5] + 1, bookmarks[6], '\"'));
    }

    protected Node parseTag(Cursor cursor) throws ParserException {
        boolean done = false;
        Vector attributes = new Vector();
        int state = 0;
        int[] bookmarks = new int[8];
        bookmarks[0] = cursor.getPosition();
        block9: while (!done) {
            bookmarks[state + 1] = cursor.getPosition();
            char ch = this.mPage.getCharacter(cursor);
            switch (state) {
                case 0: {
                    if ('\u0000' == ch || '>' == ch || '<' == ch) {
                        if ('<' == ch) {
                            cursor.retreat();
                            bookmarks[state + 1] = cursor.getPosition();
                        }
                        this.whitespace(attributes, bookmarks);
                        done = true;
                        continue block9;
                    }
                    if (Character.isWhitespace(ch)) continue block9;
                    this.whitespace(attributes, bookmarks);
                    state = 1;
                    continue block9;
                }
                case 1: {
                    if ('\u0000' == ch || '>' == ch || '<' == ch) {
                        if ('<' == ch) {
                            cursor.retreat();
                            bookmarks[state + 1] = cursor.getPosition();
                        }
                        this.standalone(attributes, bookmarks);
                        done = true;
                        continue block9;
                    }
                    if (Character.isWhitespace(ch)) {
                        bookmarks[6] = bookmarks[2];
                        state = 6;
                        continue block9;
                    }
                    if ('=' != ch) continue block9;
                    state = 2;
                    continue block9;
                }
                case 2: {
                    if ('\u0000' == ch || '>' == ch) {
                        this.empty(attributes, bookmarks);
                        done = true;
                        continue block9;
                    }
                    if ('\'' == ch) {
                        state = 4;
                        bookmarks[4] = bookmarks[3];
                        continue block9;
                    }
                    if ('\"' == ch) {
                        state = 5;
                        bookmarks[5] = bookmarks[3];
                        continue block9;
                    }
                    if (Character.isWhitespace(ch)) continue block9;
                    state = 3;
                    continue block9;
                }
                case 3: {
                    if ('\u0000' == ch || '>' == ch) {
                        this.naked(attributes, bookmarks);
                        done = true;
                        continue block9;
                    }
                    if (!Character.isWhitespace(ch)) continue block9;
                    this.naked(attributes, bookmarks);
                    bookmarks[0] = bookmarks[4];
                    state = 0;
                    continue block9;
                }
                case 4: {
                    if ('\u0000' == ch) {
                        this.single_quote(attributes, bookmarks);
                        done = true;
                        continue block9;
                    }
                    if ('\'' != ch) continue block9;
                    this.single_quote(attributes, bookmarks);
                    bookmarks[0] = bookmarks[5] + 1;
                    state = 0;
                    continue block9;
                }
                case 5: {
                    if ('\u0000' == ch) {
                        this.double_quote(attributes, bookmarks);
                        done = true;
                        continue block9;
                    }
                    if ('\"' != ch) continue block9;
                    this.double_quote(attributes, bookmarks);
                    bookmarks[0] = bookmarks[6] + 1;
                    state = 0;
                    continue block9;
                }
                case 6: {
                    if ('\u0000' == ch) {
                        this.standalone(attributes, bookmarks);
                        bookmarks[0] = bookmarks[6];
                        cursor.retreat();
                        state = 0;
                        continue block9;
                    }
                    if (Character.isWhitespace(ch)) continue block9;
                    if ('=' == ch) {
                        bookmarks[2] = bookmarks[6];
                        bookmarks[3] = bookmarks[7];
                        state = 2;
                        continue block9;
                    }
                    this.standalone(attributes, bookmarks);
                    bookmarks[0] = bookmarks[6];
                    cursor.retreat();
                    state = 0;
                    continue block9;
                }
            }
            throw new IllegalStateException("how the fuck did we get in state " + state);
        }
        return this.makeTag(cursor, attributes);
    }

    protected Node makeTag(Cursor cursor, Vector attributes) throws ParserException {
        Node ret;
        int begin = this.mCursor.getPosition();
        int end = cursor.getPosition();
        int length = end - begin;
        if (0 != length) {
            if (2 > length) {
                return this.makeString(cursor);
            }
            this.mCursor = cursor;
            ret = this.getNodeFactory().createTagNode(this.getPage(), begin, end, attributes);
        } else {
            ret = null;
        }
        return ret;
    }

    protected Node parseRemark(Cursor cursor, boolean quotesmart) throws ParserException {
        boolean done = false;
        int state = 0;
        block7: while (!done) {
            char ch = this.mPage.getCharacter(cursor);
            if ('\u0000' == ch) {
                done = true;
                continue;
            }
            switch (state) {
                case 0: {
                    if ('>' == ch) {
                        done = true;
                    }
                    if ('-' == ch) {
                        state = 1;
                        continue block7;
                    }
                    return this.parseString(cursor, quotesmart);
                }
                case 1: {
                    if ('-' == ch) {
                        ch = this.mPage.getCharacter(cursor);
                        if ('\u0000' == ch) {
                            done = true;
                            continue block7;
                        }
                        if ('>' == ch) {
                            done = true;
                            continue block7;
                        }
                        cursor.retreat();
                        state = 2;
                        continue block7;
                    }
                    return this.parseString(cursor, quotesmart);
                }
                case 2: {
                    if ('-' == ch) {
                        state = 3;
                        continue block7;
                    }
                    if ('\u0000' != ch) continue block7;
                    return this.parseString(cursor, quotesmart);
                }
                case 3: {
                    if ('-' == ch) {
                        state = 4;
                        continue block7;
                    }
                    state = 2;
                    continue block7;
                }
                case 4: {
                    if ('>' == ch) {
                        done = true;
                        continue block7;
                    }
                    if ('!' == ch || '-' == ch || Character.isWhitespace(ch)) continue block7;
                    state = 2;
                    continue block7;
                }
            }
            throw new IllegalStateException("how the fuck did we get in state " + state);
        }
        return this.makeRemark(cursor);
    }

    protected Node makeRemark(Cursor cursor) throws ParserException {
        Node ret;
        int begin = this.mCursor.getPosition();
        int end = cursor.getPosition();
        int length = end - begin;
        if (0 != length) {
            if (2 > length) {
                return this.makeString(cursor);
            }
            this.mCursor = cursor;
            ret = this.getNodeFactory().createRemarkNode(this.getPage(), begin, end);
        } else {
            ret = null;
        }
        return ret;
    }

    protected Node parseJsp(Cursor cursor) throws ParserException {
        boolean done = false;
        int state = 0;
        int code = 0;
        Vector<PageAttribute> attributes = new Vector<PageAttribute>();
        block32: while (!done) {
            char ch = this.mPage.getCharacter(cursor);
            switch (state) {
                case 0: {
                    switch (ch) {
                        case '%': {
                            state = 1;
                            continue block32;
                        }
                    }
                    done = true;
                    continue block32;
                }
                case 1: {
                    switch (ch) {
                        case '\u0000': 
                        case '>': {
                            done = true;
                            continue block32;
                        }
                        case '=': 
                        case '@': {
                            code = cursor.getPosition();
                            attributes.addElement(new PageAttribute(this.mPage, this.mCursor.getPosition() + 1, code, -1, -1, '\u0000'));
                            state = 2;
                            continue block32;
                        }
                    }
                    code = cursor.getPosition() - 1;
                    attributes.addElement(new PageAttribute(this.mPage, this.mCursor.getPosition() + 1, code, -1, -1, '\u0000'));
                    state = 2;
                    continue block32;
                }
                case 2: {
                    switch (ch) {
                        case '\u0000': 
                        case '>': {
                            done = true;
                            continue block32;
                        }
                        case '\"': 
                        case '\'': {
                            state = ch;
                            continue block32;
                        }
                        case '%': {
                            state = 3;
                            continue block32;
                        }
                    }
                    continue block32;
                }
                case 3: {
                    switch (ch) {
                        case '\u0000': {
                            done = true;
                            continue block32;
                        }
                        case '>': {
                            state = 4;
                            done = true;
                            continue block32;
                        }
                    }
                    state = 2;
                    continue block32;
                }
                case 34: {
                    switch (ch) {
                        case '\u0000': {
                            done = true;
                            continue block32;
                        }
                        case '\"': {
                            state = 2;
                            continue block32;
                        }
                    }
                    continue block32;
                }
                case 39: {
                    switch (ch) {
                        case '\u0000': {
                            done = true;
                            continue block32;
                        }
                        case '\'': {
                            state = 2;
                            continue block32;
                        }
                    }
                    continue block32;
                }
            }
            throw new IllegalStateException("how the fuck did we get in state " + state);
        }
        if (4 == state) {
            if (0 == code) {
                throw new IllegalStateException("jsp with no code!");
            }
        } else {
            return this.parseString(cursor, true);
        }
        state = cursor.getPosition() - 2;
        attributes.addElement(new PageAttribute(this.mPage, code, state, -1, -1, '\u0000'));
        attributes.addElement(new PageAttribute(this.mPage, state, state + 1, -1, -1, '\u0000'));
        return this.makeTag(cursor, attributes);
    }

    public Node createStringNode(Page page, int start, int end) {
        return new StringNode(page, start, end);
    }

    public Node createRemarkNode(Page page, int start, int end) {
        return new RemarkNode(page, start, end);
    }

    public Node createTagNode(Page page, int start, int end, Vector attributes) {
        return new TagNode(page, start, end, attributes);
    }

    public static void main(String[] args) throws MalformedURLException, IOException, ParserException {
        block5: {
            if (0 >= args.length) {
                System.out.println("usage: java -jar htmllexer.jar <url>");
            } else {
                URL url = new URL(args[0]);
                try {
                    Node node;
                    Lexer lexer = new Lexer(url.openConnection());
                    while (null != (node = lexer.nextNode())) {
                        System.out.println(((Object)node).toString());
                    }
                }
                catch (ParserException pe) {
                    System.out.println(pe.getMessage());
                    if (null == pe.getThrowable()) break block5;
                    System.out.println(pe.getThrowable().getMessage());
                }
            }
        }
    }
}

