/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import java.util.Locale;
import org.htmlparser.AbstractNode;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.StringNode;
import org.htmlparser.lexer.nodes.TagNode;
import org.htmlparser.scanners.CompositeTagScanner;
import org.htmlparser.tags.Tag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.SimpleNodeIterator;
import org.htmlparser.visitors.NodeVisitor;

public class CompositeTag
extends Tag {
    protected TagNode mEndTag;
    protected static final CompositeTagScanner mDefaultScanner = new CompositeTagScanner();

    public CompositeTag() {
        this.setThisScanner(mDefaultScanner);
    }

    public SimpleNodeIterator children() {
        SimpleNodeIterator ret = null != this.getChildren() ? this.getChildren().elements() : new NodeList().elements();
        return ret;
    }

    public Node getChild(int index) {
        return null == this.getChildren() ? null : this.getChildren().elementAt(index);
    }

    public Node[] getChildrenAsNodeArray() {
        return null == this.getChildren() ? new Node[]{} : this.getChildren().toNodeArray();
    }

    public void removeChild(int i) {
        if (null != this.getChildren()) {
            this.getChildren().remove(i);
        }
    }

    public SimpleNodeIterator elements() {
        return null == this.getChildren() ? new NodeList().elements() : this.getChildren().elements();
    }

    public String toPlainTextString() {
        StringBuffer stringRepresentation = new StringBuffer();
        SimpleNodeIterator e = this.children();
        while (e.hasMoreNodes()) {
            stringRepresentation.append(e.nextNode().toPlainTextString());
        }
        return stringRepresentation.toString();
    }

    protected void putChildrenInto(StringBuffer sb) {
        SimpleNodeIterator e = this.children();
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            sb.append(node.toHtml());
        }
    }

    protected void putEndTagInto(StringBuffer sb) {
        sb.append(this.getEndTag().toHtml());
    }

    public String toHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toHtml());
        if (!this.isEmptyXmlTag()) {
            this.putChildrenInto(sb);
            if (null != this.getEndTag()) {
                this.putEndTagInto(sb);
            }
        }
        return sb.toString();
    }

    public Tag searchByName(String name) {
        Tag tag = null;
        boolean found = false;
        SimpleNodeIterator e = this.children();
        while (e.hasMoreNodes() && !found) {
            String nameAttribute;
            Node node = e.nextNode();
            if (!(node instanceof TagNode) || (nameAttribute = (tag = (Tag)node).getAttribute("NAME")) == null || !nameAttribute.equals(name)) continue;
            found = true;
        }
        if (found) {
            return tag;
        }
        return null;
    }

    public NodeList searchFor(String searchString) {
        return this.searchFor(searchString, false);
    }

    public NodeList searchFor(String searchString, boolean caseSensitive) {
        return this.searchFor(searchString, caseSensitive, Locale.ENGLISH);
    }

    public NodeList searchFor(String searchString, boolean caseSensitive, Locale locale) {
        NodeList ret = new NodeList();
        if (!caseSensitive) {
            searchString = searchString.toUpperCase(locale);
        }
        SimpleNodeIterator e = this.children();
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            String text = node.toPlainTextString();
            if (!caseSensitive) {
                text = text.toUpperCase(locale);
            }
            if (-1 == text.indexOf(searchString)) continue;
            ret.add(node);
        }
        return ret;
    }

    public NodeList searchFor(Class classType, boolean recursive) {
        return null == this.getChildren() ? new NodeList() : this.getChildren().searchFor(classType, recursive);
    }

    public int findPositionOf(String text) {
        return this.findPositionOf(text, Locale.ENGLISH);
    }

    public int findPositionOf(String text, Locale locale) {
        int loc = 0;
        text = text.toUpperCase(locale);
        SimpleNodeIterator e = this.children();
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            if (-1 != node.toPlainTextString().toUpperCase(locale).indexOf(text)) {
                return loc;
            }
            ++loc;
        }
        return -1;
    }

    public int findPositionOf(Node searchNode) {
        int loc = 0;
        SimpleNodeIterator e = this.children();
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            if (node == searchNode) {
                return loc;
            }
            ++loc;
        }
        return -1;
    }

    public Node childAt(int index) {
        return null == this.getChildren() ? null : this.getChildren().elementAt(index);
    }

    public void collectInto(NodeList list, NodeFilter filter) {
        super.collectInto(list, filter);
        SimpleNodeIterator e = this.children();
        while (e.hasMoreNodes()) {
            e.nextNode().collectInto(list, filter);
        }
        if (null != this.getEndTag() && this != this.getEndTag()) {
            this.getEndTag().collectInto(list, filter);
        }
    }

    public String getChildrenHTML() {
        StringBuffer buff = new StringBuffer();
        SimpleNodeIterator e = this.children();
        while (e.hasMoreNodes()) {
            AbstractNode node = (AbstractNode)e.nextNode();
            buff.append(node.toHtml());
        }
        return buff.toString();
    }

    public void accept(NodeVisitor visitor) {
        if (visitor.shouldRecurseSelf()) {
            visitor.visitTag(this);
        }
        if (visitor.shouldRecurseChildren()) {
            if (null != this.getChildren()) {
                SimpleNodeIterator children = this.children();
                while (children.hasMoreNodes()) {
                    Node child = children.nextNode();
                    child.accept(visitor);
                }
            }
            if (null != this.getEndTag() && this != this.getEndTag()) {
                this.getEndTag().accept(visitor);
            }
        }
    }

    public int getChildCount() {
        NodeList children = this.getChildren();
        return null == children ? 0 : children.size();
    }

    public TagNode getStartTag() {
        return this;
    }

    public void setStartTag(TagNode start) {
        if (null != start) {
            throw new IllegalStateException("the tag *is* ths start tag");
        }
    }

    public TagNode getEndTag() {
        return this.mEndTag;
    }

    public void setEndTag(TagNode end) {
        this.mEndTag = end;
    }

    public StringNode[] digupStringNode(String searchText) {
        NodeList nodeList = this.searchFor(searchText);
        NodeList stringNodes = new NodeList();
        for (int i = 0; i < nodeList.size(); ++i) {
            Node node = nodeList.elementAt(i);
            if (node instanceof StringNode) {
                stringNodes.add(node);
                continue;
            }
            if (!(node instanceof CompositeTag)) continue;
            CompositeTag ctag = (CompositeTag)node;
            StringNode[] nodes = ctag.digupStringNode(searchText);
            for (int j = 0; j < nodes.length; ++j) {
                stringNodes.add(nodes[j]);
            }
        }
        StringNode[] stringNode = new StringNode[stringNodes.size()];
        for (int i = 0; i < stringNode.length; ++i) {
            stringNode[i] = (StringNode)stringNodes.elementAt(i);
        }
        return stringNode;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(1024);
        this.toString(0, ret);
        return ret.toString();
    }

    public String getText() {
        String ret = super.toHtml();
        ret = ret.substring(1, ret.length() - 1);
        return ret;
    }

    public String getStringText() {
        int start = this.getEndPosition();
        int end = this.mEndTag.getStartPosition();
        String ret = this.getPage().getText(start, end);
        return ret;
    }

    public void toString(int level, StringBuffer buffer) {
        for (int i = 0; i < level; ++i) {
            buffer.append("  ");
        }
        buffer.append(super.toString());
        buffer.append(System.getProperty("line.separator"));
        SimpleNodeIterator e = this.children();
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            if (node instanceof CompositeTag) {
                ((CompositeTag)node).toString(level + 1, buffer);
                continue;
            }
            for (int i = 0; i <= level; ++i) {
                buffer.append("  ");
            }
            buffer.append(node);
            buffer.append(System.getProperty("line.separator"));
        }
        if (null != this.getEndTag() && this != this.getEndTag()) {
            for (int i = 0; i <= level; ++i) {
                buffer.append("  ");
            }
            buffer.append(this.getEndTag().toString());
            buffer.append(System.getProperty("line.separator"));
        }
    }
}

