/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.util;

import org.htmlparser.Node;
import org.htmlparser.lexer.Cursor;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.scanners.TagScanner;
import org.htmlparser.tags.Tag;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.ParserFeedback;

public class IteratorImpl
implements NodeIterator {
    Lexer mLexer;
    ParserFeedback mFeedback;
    Cursor mCursor;

    public IteratorImpl(Lexer lexer, ParserFeedback fb) {
        this.mLexer = lexer;
        this.mFeedback = fb;
        this.mCursor = new Cursor(this.mLexer.getPage(), 0);
    }

    public boolean hasMoreNodes() throws ParserException {
        this.mCursor.setPosition(this.mLexer.getPosition());
        boolean ret = '\u0000' != this.mLexer.getPage().getCharacter(this.mCursor);
        return ret;
    }

    public Node nextNode() throws ParserException {
        Node ret;
        try {
            TagScanner scanner;
            Tag tag;
            ret = this.mLexer.nextNode();
            if (null != ret && ret instanceof Tag && !(tag = (Tag)ret).isEndTag() && null != (scanner = tag.getThisScanner())) {
                NodeList stack = new NodeList();
                ret = scanner.scan(tag, this.mLexer, stack);
            }
        }
        catch (ParserException pe) {
            throw pe;
        }
        catch (Exception e) {
            StringBuffer msgBuffer = new StringBuffer();
            msgBuffer.append("Unexpected Exception occurred while reading ");
            msgBuffer.append(this.mLexer.getPage().getUrl());
            msgBuffer.append(", in nextNode");
            ParserException ex = new ParserException(msgBuffer.toString(), e);
            this.mFeedback.error(msgBuffer.toString(), ex);
            throw ex;
        }
        return ret;
    }
}

