/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.htmlparser.lexer.Cursor;
import org.htmlparser.lexer.PageIndex;
import org.htmlparser.lexer.Source;
import org.htmlparser.lexer.Stream;
import org.htmlparser.util.EncodingChangeException;
import org.htmlparser.util.LinkProcessor;
import org.htmlparser.util.ParserException;

public class Page
implements Serializable {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    protected String mUrl;
    protected Source mSource;
    protected PageIndex mIndex;
    protected transient URLConnection mConnection;
    protected LinkProcessor mProcessor;
    private static final String[] mFourOhFour = new String[]{"The web site you seek cannot be located, but countless more exist", "You step in the stream, but the water has moved on. This page is not here.", "Yesterday the page existed. Today it does not. The internet is like that.", "That page was so big. It might have been very useful. But now it is gone.", "Three things are certain: death, taxes and broken links. Guess which has occured.", "Chaos reigns within. Reflect, repent and enter the correct URL. Order shall return.", "Stay the patient course. Of little worth is your ire. The page is not found.", "A non-existant URL reduces your expensive computer to a simple stone.", "Many people have visited that page. Today, you are not one of the lucky ones.", "Cutting the wind with a knife. Bookmarking a URL. Both are ephemeral."};
    static /* synthetic */ Class class$java$lang$String;

    public Page() {
        this("");
    }

    public Page(URLConnection connection) throws ParserException {
        if (null == connection) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        this.setConnection(connection);
        this.mProcessor = null;
    }

    public Page(InputStream stream, String charset) throws UnsupportedEncodingException {
        if (null == stream) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        if (null == charset) {
            charset = DEFAULT_CHARSET;
        }
        this.mSource = new Source(stream, charset);
        this.mIndex = new PageIndex(this);
        this.mConnection = null;
        this.mUrl = null;
        this.mProcessor = null;
    }

    public Page(String text) {
        if (null == text) {
            throw new IllegalArgumentException("text cannot be null");
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes(DEFAULT_CHARSET));
            this.mSource = new Source(stream, DEFAULT_CHARSET, text.length() + 1);
            this.mIndex = new PageIndex(this);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee.getMessage());
        }
        this.mConnection = null;
        this.mUrl = null;
        this.mProcessor = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (null != this.getConnection()) {
            out.writeBoolean(true);
            out.writeInt(this.mSource.offset());
            String href = this.getUrl();
            out.writeObject(href);
            this.setUrl(this.getConnection().getURL().toExternalForm());
            Source source = this.getSource();
            this.mSource = null;
            PageIndex index = this.mIndex;
            this.mIndex = null;
            out.defaultWriteObject();
            this.mSource = source;
            this.mIndex = index;
        } else {
            out.writeBoolean(false);
            String href = this.getUrl();
            out.writeObject(href);
            this.setUrl(null);
            out.defaultWriteObject();
            this.setUrl(href);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean fromurl = in.readBoolean();
        if (fromurl) {
            int offset = in.readInt();
            String href = (String)in.readObject();
            in.defaultReadObject();
            if (null != this.getUrl()) {
                URL url = new URL(this.getUrl());
                try {
                    this.setConnection(url.openConnection());
                }
                catch (ParserException pe) {
                    throw new IOException(pe.getMessage());
                }
            }
            Cursor cursor = new Cursor(this, 0);
            for (int i = 0; i < offset; ++i) {
                try {
                    this.getCharacter(cursor);
                    continue;
                }
                catch (ParserException pe) {
                    throw new IOException(pe.getMessage());
                }
            }
            this.setUrl(href);
        } else {
            String href = (String)in.readObject();
            in.defaultReadObject();
            this.setUrl(href);
        }
    }

    public void reset() {
        this.getSource().reset();
        this.mIndex = new PageIndex(this);
    }

    public URLConnection getConnection() {
        return this.mConnection;
    }

    public void setConnection(URLConnection connection) throws ParserException {
        this.mConnection = connection;
        try {
            this.getConnection().connect();
        }
        catch (UnknownHostException uhe) {
            int message = (int)(Math.random() * (double)mFourOhFour.length);
            throw new ParserException(mFourOhFour[message], uhe);
        }
        catch (IOException ioe) {
            throw new ParserException(ioe.getMessage(), ioe);
        }
        String type = this.getContentType();
        String charset = this.getCharset(type);
        try {
            Stream stream = new Stream(this.getConnection().getInputStream());
            try {
                this.mSource = new Source(stream, charset);
            }
            catch (UnsupportedEncodingException uee) {
                charset = DEFAULT_CHARSET;
                this.mSource = new Source(stream, charset);
            }
        }
        catch (IOException ioe) {
            throw new ParserException(ioe.getMessage(), ioe);
        }
        this.mUrl = connection.getURL().toExternalForm();
        this.mIndex = new PageIndex(this);
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public Source getSource() {
        return this.mSource;
    }

    public String getContentType() {
        String ret = DEFAULT_CONTENT_TYPE;
        URLConnection connection = this.getConnection();
        if (null != connection) {
            ret = connection.getContentType();
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char getCharacter(Cursor cursor) throws ParserException {
        char ret;
        block14: {
            int i = cursor.getPosition();
            if (this.mSource.mOffset < i) {
                throw new ParserException("attempt to read future characters from source");
            }
            if (this.mSource.mOffset == i) {
                try {
                    i = this.mSource.read();
                    if (0 > i) {
                        return '\u0000';
                    }
                    ret = (char)i;
                    cursor.advance();
                }
                catch (IOException ioe) {
                    throw new ParserException("problem reading a character at position " + cursor.getPosition(), ioe);
                }
            } else {
                ret = this.mSource.mBuffer[i];
                cursor.advance();
            }
            if ('\r' == ret) {
                ret = '\n';
                if (this.mSource.mOffset == cursor.getPosition()) {
                    try {
                        i = this.mSource.read();
                        if (-1 == i) break block14;
                        if ('\n' == (char)i) {
                            cursor.advance();
                            break block14;
                        }
                        try {
                            this.mSource.unread();
                            break block14;
                        }
                        catch (IOException ioe) {
                            throw new ParserException("can't unread a character at position " + cursor.getPosition(), ioe);
                        }
                    }
                    catch (IOException ioe) {
                        throw new ParserException("problem reading a character at position " + cursor.getPosition(), ioe);
                    }
                }
                if ('\n' == this.mSource.mBuffer[cursor.getPosition()]) {
                    cursor.advance();
                }
            }
        }
        if (10 != ret) return ret;
        this.mIndex.add(cursor);
        return ret;
    }

    public String getCharset(String content) {
        int index;
        String CHARSET_STRING = "charset";
        String ret = DEFAULT_CHARSET;
        if (null != content && (index = content.indexOf("charset")) != -1 && (content = content.substring(index + "charset".length()).trim()).startsWith("=")) {
            index = (content = content.substring(1).trim()).indexOf(";");
            if (index != -1) {
                content = content.substring(0, index);
            }
            if (content.startsWith("\"") && content.endsWith("\"") && 1 < content.length()) {
                content = content.substring(1, content.length() - 1);
            }
            if (content.startsWith("'") && content.endsWith("'") && 1 < content.length()) {
                content = content.substring(1, content.length() - 1);
            }
            ret = this.findCharset(content, ret);
        }
        return ret;
    }

    public String findCharset(String name, String _default) {
        String ret;
        try {
            Class<?> cls = Class.forName("java.nio.charset.Charset");
            Method method = cls.getMethod("forName", class$java$lang$String == null ? (class$java$lang$String = Page.class$("java.lang.String")) : class$java$lang$String);
            Object object = method.invoke(null, name);
            method = cls.getMethod("name", new Class[0]);
            object = method.invoke(object, new Object[0]);
            ret = (String)object;
        }
        catch (ClassNotFoundException cnfe) {
            ret = name;
        }
        catch (NoSuchMethodException nsme) {
            ret = name;
        }
        catch (IllegalAccessException ia) {
            ret = name;
        }
        catch (InvocationTargetException ita) {
            ret = _default;
            System.out.println("unable to determine cannonical charset name for " + name + " - using " + _default);
        }
        return ret;
    }

    public String getEncoding() {
        return this.mSource.getEncoding();
    }

    public void setEncoding(String character_set) throws ParserException {
        String encoding = this.getEncoding();
        if (!encoding.equalsIgnoreCase(character_set)) {
            InputStream stream = this.getSource().getStream();
            try {
                char[] buffer = this.mSource.mBuffer;
                int offset = this.mSource.mOffset;
                stream.reset();
                this.mSource = new Source(stream, character_set);
                if (0 != offset) {
                    char[] new_chars = new char[offset];
                    if (offset != this.mSource.read(new_chars)) {
                        throw new ParserException("reset stream failed");
                    }
                    for (int i = 0; i < offset; ++i) {
                        if (new_chars[i] == buffer[i]) continue;
                        throw new EncodingChangeException("character mismatch (new: " + new_chars[i] + " != old: " + buffer[i] + ") for encoding change from " + encoding + " to " + character_set + " at character offset " + offset);
                    }
                }
            }
            catch (IOException ioe) {
                throw new ParserException(ioe.getMessage(), ioe);
            }
        }
    }

    public LinkProcessor getLinkProcessor() {
        if (null == this.mProcessor) {
            this.mProcessor = new LinkProcessor();
        }
        return this.mProcessor;
    }

    public void setLinkProcessor(LinkProcessor processor) {
        this.mProcessor = processor;
    }

    public int row(Cursor cursor) {
        return this.mIndex.row(cursor);
    }

    public int row(int position) {
        return this.mIndex.row(position);
    }

    public int column(Cursor cursor) {
        return this.mIndex.column(cursor);
    }

    public int column(int position) {
        return this.mIndex.column(position);
    }

    public String getText(int start, int end) {
        return new String(this.mSource.mBuffer, start, end - start);
    }

    public void getText(StringBuffer buffer, int start, int end) {
        int length;
        if (this.mSource.mOffset < start || this.mSource.mOffset < end) {
            throw new IllegalArgumentException("attempt to extract future characters from source");
        }
        if (end < start) {
            length = end;
            end = start;
            start = length;
        }
        length = end - start;
        buffer.append(this.mSource.mBuffer, start, length);
    }

    public String getText() {
        return new String(this.mSource.mBuffer, 0, this.mSource.mOffset);
    }

    public void getText(StringBuffer buffer) {
        this.getText(buffer, 0, this.mSource.mOffset);
    }

    public String getLine(Cursor cursor) {
        int end;
        int start;
        int size;
        int line = this.row(cursor);
        if (line < (size = this.mIndex.size())) {
            start = this.mIndex.elementAt(line);
            end = ++line <= size ? this.mIndex.elementAt(line) : this.mSource.mOffset;
        } else {
            start = this.mIndex.elementAt(line - 1);
            end = this.mSource.mOffset;
        }
        return this.getText(start, end);
    }

    public String getLine(int position) {
        return this.getLine(new Cursor(this, position));
    }

    public String toString() {
        String ret;
        if (this.mSource.mOffset > 0) {
            StringBuffer buffer = new StringBuffer(43);
            int start = this.mSource.mOffset - 40;
            if (0 > start) {
                start = 0;
            } else {
                buffer.append("...");
            }
            this.getText(buffer, start, this.mSource.mOffset);
            ret = buffer.toString();
        } else {
            ret = super.toString();
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

