/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.htmlparser.Node;
import org.htmlparser.StringNode;
import org.htmlparser.lexer.nodes.Attribute;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.Tag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.SimpleNodeIterator;

public class AppletTag
extends CompositeTag {
    private static final String[] mIds = new String[]{"APPLET"};
    private static final String[] mEndTagEnders = new String[]{"BODY", "HTML"};

    public String[] getIds() {
        return mIds;
    }

    public String[] getEndTagEnders() {
        return mEndTagEnders;
    }

    public Hashtable createAppletParamsTable() {
        Hashtable<String, String> ret = new Hashtable<String, String>();
        NodeList kids = this.getChildren();
        if (null != kids) {
            for (int i = 0; i < kids.size(); ++i) {
                String paramName;
                Tag tag;
                Node node = this.children.elementAt(i);
                if (!(node instanceof Tag) || !(tag = (Tag)node).getTagName().equals("PARAM") || null == (paramName = tag.getAttribute("NAME")) || 0 == paramName.length()) continue;
                String paramValue = tag.getAttribute("VALUE");
                ret.put(paramName, paramValue);
            }
        }
        return ret;
    }

    public String getAppletClass() {
        return this.getAttribute("CODE");
    }

    public Hashtable getAppletParams() {
        return this.createAppletParamsTable();
    }

    public String getArchive() {
        return this.getAttribute("ARCHIVE");
    }

    public String getCodeBase() {
        return this.getAttribute("CODEBASE");
    }

    public String getParameter(String key) {
        return (String)this.getAppletParams().get(key);
    }

    public Enumeration getParameterNames() {
        return this.getAppletParams().keys();
    }

    public void setAppletClass(String newAppletClass) {
        this.setAttribute("CODE", newAppletClass);
    }

    public void setAppletParams(Hashtable newAppletParams) {
        NodeList kids = this.getChildren();
        if (null == kids) {
            kids = new NodeList();
        } else {
            int i = 0;
            while (i < kids.size()) {
                Node node = kids.elementAt(i);
                if (node instanceof Tag) {
                    if (((Tag)node).getTagName().equals("PARAM")) {
                        StringNode string;
                        kids.remove(i);
                        if (i >= kids.size() || !((node = kids.elementAt(i)) instanceof StringNode) || 0 != (string = (StringNode)node).getText().trim().length()) continue;
                        kids.remove(i);
                        continue;
                    }
                    ++i;
                    continue;
                }
                ++i;
            }
        }
        Enumeration e = newAppletParams.keys();
        while (e.hasMoreElements()) {
            Vector<Attribute> attributes = new Vector<Attribute>();
            String paramName = (String)e.nextElement();
            String paramValue = (String)newAppletParams.get(paramName);
            attributes.addElement(new Attribute("PARAM", null));
            attributes.addElement(new Attribute(" "));
            attributes.addElement(new Attribute("VALUE", paramValue, '\"'));
            attributes.addElement(new Attribute(" "));
            attributes.addElement(new Attribute("NAME", paramName, '\"'));
            Tag tag = new Tag(null, 0, 0, attributes);
            kids.add(tag);
        }
        this.setChildren(kids);
    }

    public void setArchive(String newArchive) {
        this.setAttribute("ARCHIVE", newArchive);
    }

    public void setCodeBase(String newCodeBase) {
        this.setAttribute("CODEBASE", newCodeBase);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(500);
        ret.append("Applet Tag\n");
        ret.append("**********\n");
        ret.append("Class Name = ");
        ret.append(this.getAppletClass());
        ret.append("\n");
        ret.append("Archive = ");
        ret.append(this.getArchive());
        ret.append("\n");
        ret.append("Codebase = ");
        ret.append(this.getCodeBase());
        ret.append("\n");
        Hashtable parameters = this.getAppletParams();
        Enumeration params = parameters.keys();
        if (null == params) {
            ret.append("No Params found.\n");
        } else {
            int cnt = 0;
            while (params.hasMoreElements()) {
                String paramName = (String)params.nextElement();
                String paramValue = (String)parameters.get(paramName);
                ret.append(cnt);
                ret.append(": Parameter name = ");
                ret.append(paramName);
                ret.append(", Parameter value = ");
                ret.append(paramValue);
                ret.append("\n");
                ++cnt;
            }
        }
        boolean found = false;
        SimpleNodeIterator e = this.children();
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            if (node instanceof Tag && ((Tag)node).getTagName().equals("PARAM")) continue;
            if (!found) {
                ret.append("Miscellaneous items :\n");
            } else {
                ret.append(" ");
            }
            found = true;
            ret.append(((Object)node).toString());
        }
        if (found) {
            ret.append("\n");
        }
        ret.append("End of Applet Tag\n");
        ret.append("*****************\n");
        return ret.toString();
    }
}

