/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import org.htmlparser.lexer.nodes.Attribute;
import org.htmlparser.tags.Tag;
import org.htmlparser.util.ParserException;

public class MetaTag
extends Tag {
    private static final String[] mIds = new String[]{"META"};

    public String[] getIds() {
        return mIds;
    }

    public String getHttpEquiv() {
        return this.getAttribute("HTTP-EQUIV");
    }

    public String getMetaContent() {
        return this.getAttribute("CONTENT");
    }

    public String getMetaTagName() {
        return this.getAttribute("NAME");
    }

    public void setHttpEquiv(String httpEquiv) {
        Attribute equiv = this.getAttributeEx("HTTP-EQUIV");
        if (null != equiv) {
            equiv.setValue(httpEquiv);
        } else {
            this.getAttributesEx().add(new Attribute("HTTP-EQUIV", httpEquiv));
        }
    }

    public void setMetaTagContents(String metaTagContents) {
        Attribute content = this.getAttributeEx("CONTENT");
        if (null != content) {
            content.setValue(metaTagContents);
        } else {
            this.getAttributesEx().add(new Attribute("CONTENT", metaTagContents));
        }
    }

    public void setMetaTagName(String metaTagName) {
        Attribute name = this.getAttributeEx("NAME");
        if (null != name) {
            name.setValue(metaTagName);
        } else {
            this.getAttributesEx().add(new Attribute("NAME", metaTagName));
        }
    }

    public void doSemanticAction() throws ParserException {
        String httpEquiv = this.getHttpEquiv();
        if ("Content-Type".equalsIgnoreCase(httpEquiv)) {
            String charset = this.getPage().getCharset(this.getAttribute("CONTENT"));
            this.getPage().setEncoding(charset);
        }
    }
}

