/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.visitors;

import java.util.Locale;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.visitors.NodeVisitor;

public class LinkFindingVisitor
extends NodeVisitor {
    private String linkTextToFind;
    private int count = 0;
    private Locale locale;

    public LinkFindingVisitor(String linkTextToFind) {
        this(linkTextToFind, null);
    }

    public LinkFindingVisitor(String linkTextToFind, Locale locale) {
        this.locale = null == locale ? Locale.ENGLISH : locale;
        this.linkTextToFind = linkTextToFind.toUpperCase(this.locale);
    }

    public void visitLinkTag(LinkTag linkTag) {
        if (-1 != linkTag.getLinkText().toUpperCase(this.locale).indexOf(this.linkTextToFind)) {
            ++this.count;
        }
    }

    public boolean linkTextFound() {
        return 0 != this.count;
    }

    public int getCount() {
        return this.count;
    }
}

