/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.LexerCore;
import gov.nist.core.ParserCore;
import java.text.ParseException;

public class HostNameParser
extends ParserCore {
    private static final char[] VALID_DOMAIN_LABEL_CHAR = new char[]{'\ufffd', '-', '.'};

    public HostNameParser(String hname) {
        this.lexer = new LexerCore("charLexer", hname);
    }

    public HostNameParser(LexerCore lexer) {
        this.lexer = lexer;
        lexer.selectLexer("charLexer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeDomainLabel() throws ParseException {
        this.lexer.consumeValidChars(VALID_DOMAIN_LABEL_CHAR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String ipv6Reference() throws ParseException {
        char la;
        StringBuffer retval;
        block4: {
            retval = new StringBuffer();
            while (this.lexer.hasMoreChars()) {
                la = this.lexer.lookAhead(0);
                if (LexerCore.isHexDigit(la) || la == '.' || la == ':' || la == '[') {
                    this.lexer.consume(1);
                    retval.append(la);
                    continue;
                }
                break block4;
            }
            throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
        }
        if (la != ']') throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
        this.lexer.consume(1);
        retval.append(la);
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host host() throws ParseException {
        String hostname;
        if (this.lexer.lookAhead(0) == '[') {
            hostname = this.ipv6Reference();
        } else {
            int startPtr = this.lexer.getPtr();
            this.consumeDomainLabel();
            hostname = this.lexer.getBuffer().substring(startPtr, this.lexer.getPtr());
        }
        if (hostname.length() == 0) {
            throw new ParseException(this.lexer.getBuffer() + ": Missing host name", this.lexer.getPtr());
        }
        Host host = new Host(hostname);
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostPort hostPort(boolean allowWS) throws ParseException {
        Host host = this.host();
        HostPort hp = new HostPort();
        hp.setHost(host);
        if (allowWS) {
            this.lexer.SPorHT();
        }
        if (this.lexer.hasMoreChars()) {
            char la = this.lexer.lookAhead(0);
            switch (la) {
                case ':': {
                    this.lexer.consume(1);
                    if (allowWS) {
                        this.lexer.SPorHT();
                    }
                    try {
                        String port = this.lexer.number();
                        hp.setPort(Integer.parseInt(port));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new ParseException(this.lexer.getBuffer() + " :Error parsing port ", this.lexer.getPtr());
                    }
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '/': 
                case ';': 
                case '>': 
                case '?': {
                    break;
                }
                default: {
                    if (allowWS) break;
                    throw new ParseException(this.lexer.getBuffer() + " Illegal character in hostname:" + this.lexer.lookAhead(0), this.lexer.getPtr());
                }
            }
        }
        HostPort hostPort = hp;
        return hostPort;
    }

    public static void main(String[] args) throws ParseException {
        String[] hostNames = new String[]{"foo.bar.com:1234", "proxima.chaplin.bt.co.uk", "129.6.55.181:2345", ":1234", "foo.bar.com:         1234", "foo.bar.com     :      1234   ", "MIK_S:1234"};
        for (int i = 0; i < hostNames.length; ++i) {
            try {
                HostNameParser hnp = new HostNameParser(hostNames[i]);
                HostPort hp = hnp.hostPort(true);
                System.out.println("[" + hp.encode() + "]");
                continue;
            }
            catch (ParseException ex) {
                System.out.println("exception text = " + ex.getMessage());
            }
        }
    }
}

