/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.TransactionExt;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sip.Dialog;
import javax.sip.IOExceptionEvent;
import javax.sip.ServerTransaction;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.message.Request;
import javax.sip.message.Response;

public abstract class SIPTransaction
extends MessageChannel
implements Transaction,
TransactionExt {
    protected boolean toListener;
    protected int BASE_TIMER_INTERVAL = 500;
    protected int T4 = 5000 / this.BASE_TIMER_INTERVAL;
    protected int T2 = 4000 / this.BASE_TIMER_INTERVAL;
    protected int TIMER_I = this.T4;
    protected int TIMER_K = this.T4;
    protected int TIMER_D = 32000 / this.BASE_TIMER_INTERVAL;
    protected static final int T1 = 1;
    protected static final int TIMER_A = 1;
    protected static final int TIMER_B = 64;
    protected static final int TIMER_J = 64;
    protected static final int TIMER_F = 64;
    protected static final int TIMER_H = 64;
    protected Object applicationData;
    protected SIPResponse lastResponse;
    protected boolean isMapped;
    private Semaphore semaphore;
    protected boolean isSemaphoreAquired;
    protected String transactionId;
    public long auditTag = 0L;
    public static final TransactionState INITIAL_STATE = null;
    public static final TransactionState TRYING_STATE = TransactionState.TRYING;
    public static final TransactionState CALLING_STATE = TransactionState.CALLING;
    public static final TransactionState PROCEEDING_STATE = TransactionState.PROCEEDING;
    public static final TransactionState COMPLETED_STATE = TransactionState.COMPLETED;
    public static final TransactionState CONFIRMED_STATE = TransactionState.CONFIRMED;
    public static final TransactionState TERMINATED_STATE = TransactionState.TERMINATED;
    protected static final int MAXIMUM_RETRANSMISSION_TICK_COUNT = 8;
    protected transient SIPTransactionStack sipStack;
    protected SIPRequest originalRequest;
    private transient MessageChannel encapsulatedChannel;
    protected int peerPort;
    protected InetAddress peerInetAddress;
    protected String peerAddress;
    protected String peerProtocol;
    protected int peerPacketSourcePort;
    protected InetAddress peerPacketSourceAddress;
    protected boolean transactionTimerStarted = false;
    private String branch;
    private String method;
    private long cSeq;
    private TransactionState currentState;
    private transient int retransmissionTimerLastTickCount;
    private transient int retransmissionTimerTicksLeft;
    protected int timeoutTimerTicksLeft;
    private transient Set<SIPTransactionEventListener> eventListeners;
    protected From from;
    protected To to;
    protected Event event;
    protected CallID callId;
    protected int collectionTime;
    protected String toTag;
    protected String fromTag;
    private boolean terminatedEventDelivered;

    public String getBranchId() {
        return this.branch;
    }

    protected SIPTransaction(SIPTransactionStack newParentStack, MessageChannel newEncapsulatedChannel) {
        this.sipStack = newParentStack;
        this.semaphore = new Semaphore(1, true);
        this.encapsulatedChannel = newEncapsulatedChannel;
        this.peerPort = newEncapsulatedChannel.getPeerPort();
        this.peerAddress = newEncapsulatedChannel.getPeerAddress();
        this.peerInetAddress = newEncapsulatedChannel.getPeerInetAddress();
        this.peerPacketSourcePort = newEncapsulatedChannel.getPeerPacketSourcePort();
        this.peerPacketSourceAddress = newEncapsulatedChannel.getPeerPacketSourceAddress();
        this.peerProtocol = newEncapsulatedChannel.getPeerProtocol();
        if (this.isReliable()) {
            if (this.encapsulatedChannel instanceof TLSMessageChannel) {
                ++((TLSMessageChannel)this.encapsulatedChannel).useCount;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("use count for encapsulated channel" + this + " " + ((TLSMessageChannel)this.encapsulatedChannel).useCount);
                }
            } else {
                ++((TCPMessageChannel)this.encapsulatedChannel).useCount;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("use count for encapsulated channel" + this + " " + ((TCPMessageChannel)this.encapsulatedChannel).useCount);
                }
            }
        }
        this.currentState = null;
        this.disableRetransmissionTimer();
        this.disableTimeoutTimer();
        this.eventListeners = Collections.synchronizedSet(new HashSet());
        this.addEventListener(newParentStack);
    }

    public void setOriginalRequest(SIPRequest newOriginalRequest) {
        if (this.originalRequest != null && !this.originalRequest.getTransactionId().equals(newOriginalRequest.getTransactionId())) {
            this.sipStack.removeTransactionHash(this);
        }
        this.originalRequest = newOriginalRequest;
        this.method = newOriginalRequest.getMethod();
        this.from = (From)newOriginalRequest.getFrom();
        this.to = (To)newOriginalRequest.getTo();
        this.toTag = this.to.getTag();
        this.fromTag = this.from.getTag();
        this.callId = (CallID)newOriginalRequest.getCallId();
        this.cSeq = newOriginalRequest.getCSeq().getSeqNumber();
        this.event = (Event)newOriginalRequest.getHeader("Event");
        this.transactionId = newOriginalRequest.getTransactionId();
        this.originalRequest.setTransaction(this);
        String newBranch = ((Via)newOriginalRequest.getViaHeaders().getFirst()).getBranch();
        if (newBranch != null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Setting Branch id : " + newBranch);
            }
            this.setBranch(newBranch);
        } else {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Branch id is null - compute TID!" + newOriginalRequest.encode());
            }
            this.setBranch(newOriginalRequest.getTransactionId());
        }
    }

    public SIPRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public Request getRequest() {
        return this.originalRequest;
    }

    public final boolean isInviteTransaction() {
        return this.getMethod().equals("INVITE");
    }

    public final boolean isCancelTransaction() {
        return this.getMethod().equals("CANCEL");
    }

    public final boolean isByeTransaction() {
        return this.getMethod().equals("BYE");
    }

    public MessageChannel getMessageChannel() {
        return this.encapsulatedChannel;
    }

    public final void setBranch(String newBranch) {
        this.branch = newBranch;
    }

    public final String getBranch() {
        if (this.branch == null) {
            this.branch = this.getOriginalRequest().getTopmostVia().getBranch();
        }
        return this.branch;
    }

    public final String getMethod() {
        return this.method;
    }

    public final long getCSeq() {
        return this.cSeq;
    }

    public void setState(TransactionState newState) {
        if (this.currentState == TransactionState.COMPLETED && newState != TransactionState.TERMINATED && newState != TransactionState.CONFIRMED) {
            newState = TransactionState.COMPLETED;
        }
        if (this.currentState == TransactionState.CONFIRMED && newState != TransactionState.TERMINATED) {
            newState = TransactionState.CONFIRMED;
        }
        if (this.currentState != TransactionState.TERMINATED) {
            this.currentState = newState;
        } else {
            newState = this.currentState;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Transaction:setState " + newState + " " + this + " branchID = " + this.getBranch() + " isClient = " + (this instanceof SIPClientTransaction));
            this.sipStack.logWriter.logStackTrace();
        }
    }

    public TransactionState getState() {
        return this.currentState;
    }

    protected final void enableRetransmissionTimer() {
        this.enableRetransmissionTimer(1);
    }

    protected final void enableRetransmissionTimer(int tickCount) {
        this.retransmissionTimerTicksLeft = this.isInviteTransaction() && this instanceof SIPClientTransaction ? tickCount : Math.min(tickCount, 8);
        this.retransmissionTimerLastTickCount = this.retransmissionTimerTicksLeft;
    }

    protected final void disableRetransmissionTimer() {
        this.retransmissionTimerTicksLeft = -1;
    }

    protected final void enableTimeoutTimer(int tickCount) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("enableTimeoutTimer " + this + " tickCount " + tickCount + " currentTickCount = " + this.timeoutTimerTicksLeft);
        }
        this.timeoutTimerTicksLeft = tickCount;
    }

    protected final void disableTimeoutTimer() {
        this.timeoutTimerTicksLeft = -1;
    }

    final void fireTimer() {
        if (this.timeoutTimerTicksLeft != -1 && --this.timeoutTimerTicksLeft == 0) {
            this.fireTimeoutTimer();
        }
        if (this.retransmissionTimerTicksLeft != -1 && --this.retransmissionTimerTicksLeft == 0) {
            this.enableRetransmissionTimer(this.retransmissionTimerLastTickCount * 2);
            this.fireRetransmissionTimer();
        }
    }

    public final boolean isTerminated() {
        return this.getState() == TERMINATED_STATE;
    }

    public String getHost() {
        return this.encapsulatedChannel.getHost();
    }

    public String getKey() {
        return this.encapsulatedChannel.getKey();
    }

    public int getPort() {
        return this.encapsulatedChannel.getPort();
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getPeerPacketSourcePort() {
        return this.peerPacketSourcePort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerPacketSourceAddress;
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerInetAddress;
    }

    protected String getPeerProtocol() {
        return this.peerProtocol;
    }

    public String getTransport() {
        return this.encapsulatedChannel.getTransport();
    }

    public boolean isReliable() {
        return this.encapsulatedChannel.isReliable();
    }

    public Via getViaHeader() {
        Via channelViaHeader = super.getViaHeader();
        try {
            channelViaHeader.setBranch(this.branch);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return channelViaHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(SIPMessage messageToSend) throws IOException {
        try {
            this.encapsulatedChannel.sendMessage(messageToSend, this.peerInetAddress, this.peerPort);
        }
        finally {
            this.startTransactionTimer();
        }
    }

    protected void sendMessage(byte[] messageBytes, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        throw new IOException("Cannot send unparsed message through Transaction Channel!");
    }

    public void addEventListener(SIPTransactionEventListener newListener) {
        this.eventListeners.add(newListener);
    }

    public void removeEventListener(SIPTransactionEventListener oldListener) {
        this.eventListeners.remove(oldListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseErrorEvent(int errorEventID) {
        SIPTransactionErrorEvent newErrorEvent = new SIPTransactionErrorEvent(this, errorEventID);
        Set<SIPTransactionEventListener> set = this.eventListeners;
        synchronized (set) {
            for (SIPTransactionEventListener nextListener : this.eventListeners) {
                nextListener.transactionErrorEvent(newErrorEvent);
            }
        }
        if (errorEventID != 3) {
            this.eventListeners.clear();
            this.setState(TransactionState.TERMINATED);
            if (this instanceof SIPServerTransaction && this.isByeTransaction() && this.getDialog() != null) {
                ((SIPDialog)this.getDialog()).setState(3);
            }
        }
    }

    protected boolean IsServerTransaction() {
        return this instanceof SIPServerTransaction;
    }

    public abstract Dialog getDialog();

    public abstract void setDialog(SIPDialog var1, String var2);

    public int getRetransmitTimer() {
        return 500;
    }

    public String getViaHost() {
        return this.getViaHeader().getHost();
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    public Response getResponse() {
        return this.lastResponse;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public int hashCode() {
        if (this.transactionId == null) {
            return -1;
        }
        return this.transactionId.hashCode();
    }

    public int getViaPort() {
        return this.getViaHeader().getPort();
    }

    public boolean doesCancelMatchTransaction(SIPRequest requestToTest) {
        boolean transactionMatches = false;
        if (this.getOriginalRequest() == null || this.getOriginalRequest().getMethod().equals("CANCEL")) {
            return false;
        }
        ViaList viaHeaders = requestToTest.getViaHeaders();
        if (viaHeaders != null) {
            Via topViaHeader = (Via)viaHeaders.getFirst();
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.startsWith("z9hG4bK")) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                if (this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(((Via)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy())) {
                    transactionMatches = true;
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.logWriter.logDebug("returning  true");
                    }
                }
            } else {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("testing against " + this.getOriginalRequest());
                }
                if (this.getOriginalRequest().getRequestURI().equals(requestToTest.getRequestURI()) && ((Object)this.getOriginalRequest().getTo()).equals(requestToTest.getTo()) && ((Object)this.getOriginalRequest().getFrom()).equals(requestToTest.getFrom()) && this.getOriginalRequest().getCallId().getCallId().equals(requestToTest.getCallId().getCallId()) && this.getOriginalRequest().getCSeq().getSeqNumber() == requestToTest.getCSeq().getSeqNumber() && topViaHeader.equals(this.getOriginalRequest().getViaHeaders().getFirst())) {
                    transactionMatches = true;
                }
            }
        }
        if (transactionMatches) {
            this.setPassToListener();
        }
        return transactionMatches;
    }

    public void setRetransmitTimer(int retransmitTimer) {
        if (retransmitTimer <= 0) {
            throw new IllegalArgumentException("Retransmit timer must be positive!");
        }
        if (this.transactionTimerStarted) {
            throw new IllegalStateException("Transaction timer is already started");
        }
        this.BASE_TIMER_INTERVAL = retransmitTimer;
        this.T4 = 5000 / this.BASE_TIMER_INTERVAL;
        this.T2 = 4000 / this.BASE_TIMER_INTERVAL;
        this.TIMER_I = this.T4;
        this.TIMER_K = this.T4;
        this.TIMER_D = 32000 / this.BASE_TIMER_INTERVAL;
    }

    public void close() {
        this.encapsulatedChannel.close();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Closing " + this.encapsulatedChannel);
        }
    }

    public boolean isSecure() {
        return this.encapsulatedChannel.isSecure();
    }

    public MessageProcessor getMessageProcessor() {
        return this.encapsulatedChannel.getMessageProcessor();
    }

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public void setEncapsulatedChannel(MessageChannel messageChannel) {
        this.encapsulatedChannel = messageChannel;
        this.peerInetAddress = messageChannel.getPeerInetAddress();
        this.peerPort = messageChannel.getPeerPort();
    }

    public SipProviderImpl getSipProvider() {
        return this.getMessageProcessor().getListeningPoint().getProvider();
    }

    public void raiseIOExceptionEvent() {
        this.setState(TransactionState.TERMINATED);
        String host = this.getPeerAddress();
        int port = this.getPeerPort();
        String transport = this.getTransport();
        IOExceptionEvent exceptionEvent = new IOExceptionEvent(this, host, port, transport);
        this.getSipProvider().handleEvent(exceptionEvent, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireSem() {
        boolean retval = false;
        try {
            if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("acquireSem [[[[" + this);
                this.sipStack.getLogWriter().logStackTrace();
            }
            retval = this.semaphore.tryAcquire(1000L, TimeUnit.MILLISECONDS);
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("acquireSem() returning : " + retval);
            }
            boolean bl = retval;
            return bl;
        }
        catch (Exception ex) {
            this.sipStack.logWriter.logError("Unexpected exception acquiring sem", ex);
            InternalErrorHandler.handleException(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.isSemaphoreAquired = retval;
        }
    }

    public void releaseSem() {
        try {
            this.toListener = false;
            this.semRelease();
        }
        catch (Exception ex) {
            this.sipStack.logWriter.logError("Unexpected exception releasing sem", ex);
        }
    }

    protected void semRelease() {
        try {
            if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("semRelease ]]]]" + this);
                this.sipStack.getLogWriter().logStackTrace();
            }
            this.isSemaphoreAquired = false;
            this.semaphore.release();
        }
        catch (Exception ex) {
            this.sipStack.logWriter.logError("Unexpected exception releasing sem", ex);
        }
    }

    public boolean passToListener() {
        return this.toListener;
    }

    public void setPassToListener() {
        if (this.sipStack.logWriter.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("setPassToListener()");
        }
        this.toListener = true;
    }

    protected synchronized boolean testAndSetTransactionTerminatedEvent() {
        boolean retval = !this.terminatedEventDelivered;
        this.terminatedEventDelivered = true;
        return retval;
    }

    protected abstract void startTransactionTimer();

    public abstract boolean isMessagePartOfTransaction(SIPMessage var1);

    protected abstract void fireRetransmissionTimer();

    protected abstract void fireTimeoutTimer();

    class LingerTimer
    extends SIPStackTimerTask {
        public LingerTimer() {
            SIPTransaction sipTransaction = SIPTransaction.this;
            if (SIPTransaction.this.sipStack.logWriter.isLoggingEnabled()) {
                SIPTransaction.this.sipStack.logWriter.logDebug("LingerTimer : " + sipTransaction.getTransactionId());
            }
        }

        protected void runTask() {
            SIPTransaction transaction = SIPTransaction.this;
            SIPTransactionStack sipStack = transaction.getSIPStack();
            if (sipStack.logWriter.isLoggingEnabled()) {
                sipStack.logWriter.logDebug("LingerTimer: run() : " + SIPTransaction.this.getTransactionId());
            }
            if (transaction instanceof SIPClientTransaction) {
                sipStack.removeTransaction(transaction);
                transaction.close();
            } else if (transaction instanceof ServerTransaction) {
                if (sipStack.isLoggingEnabled()) {
                    sipStack.logWriter.logDebug("removing" + transaction);
                }
                sipStack.removeTransaction(transaction);
                if (!sipStack.cacheServerConnections && transaction.encapsulatedChannel instanceof TCPMessageChannel && --((TCPMessageChannel)((SIPTransaction)transaction).encapsulatedChannel).useCount <= 0) {
                    transaction.close();
                } else if (!sipStack.cacheServerConnections && transaction.encapsulatedChannel instanceof TLSMessageChannel && --((TLSMessageChannel)((SIPTransaction)transaction).encapsulatedChannel).useCount <= 0) {
                    transaction.close();
                } else if (sipStack.isLoggingEnabled() && !sipStack.cacheServerConnections && transaction.isReliable()) {
                    int useCount = transaction.encapsulatedChannel instanceof TCPMessageChannel ? ((TCPMessageChannel)((SIPTransaction)transaction).encapsulatedChannel).useCount : ((TLSMessageChannel)((SIPTransaction)transaction).encapsulatedChannel).useCount;
                    sipStack.logWriter.logDebug("Use Count = " + useCount);
                }
            }
        }
    }
}

