/*
 * CLIF is a Load Injection Framework
 * Copyright (C) 2005, 2006 France Telecom
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * CLIF $Name: not supported by cvs2svn $
 *
 * Contact: clif@ow2.org
 */

package org.ow2.clif.console.lib.batch;

import org.ow2.clif.deploy.ClifAppFacade;
import org.ow2.clif.util.ExecutionContext;

/**
 * Command to change a parameter of a deployed and possibly running blade. 
 * @author Joan Chaumont
 * @author Bruno Dillenseger
 */
public class ChangeParameterCmd
{
	/**
	 * Changes the value of a blade parameter.
	 * @param args args[0] is the name of the target deployed test plan,
	 * args[1] is the identifier of the target blade
	 * args[2] is the name of the paramter to be set
	 * args[3] is the new value of the parameter
	 */
	public static void main(String[] args)
	{
		if (args.length < 4)
		{
			BatchUtil.usage("arguments expected: <deployed test plan name> <blade identifier> <parameter name> <parameter value>");
		}
		if (System.getSecurityManager() == null)
		{
			System.setSecurityManager(new SecurityManager());
		}
		ExecutionContext.init("./");
		System.exit(run(args[0], args[1], args[2], args[3]));
	}


	/**
	 * Changes the value of a blade parameter.
	 * @param testplan name of target deployed test plan
	 * @param bladeId identifier fo the target blade in the given test plan
	 * @param name name of the parameter whose value is to be changed
	 * @param value new value for the given parameter
	 * @return execution status code
	 */
	public static int run(String testplan, String bladeId, String name, String value) {
		try {
			ClifAppFacade clifApp = BatchUtil.getClifAppFacade(testplan);
			clifApp.changeParameter(bladeId, name, value);
			System.out.println("Parameter change successful");
			return BatchUtil.SUCCESS;
		}
		catch (Exception ex) {
			System.err.println("Error occured while changing parameters");
			ex.printStackTrace(System.err);
			return BatchUtil.ERR_EXEC;
		}
	}
}
