/*
 * CLIF is a Load Injection Framework Copyright (C) 2005 France Telecom R&D
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option) any
 * later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * CLIF
 * 
 * Contact: clif@ow2.org
 */
package org.ow2.clif.scenario.isac.engine.nodes;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;

/**
 * @author Emmanuel Varoquaux
 */
public class PlugInNode {
	public String id;
	public String name;
	public Map<String,String> params;

	public PlugInNode(Element element) throws NodeException {
		ListIterator i;
		Attribute a;
		Element e;
		String name;

		for (i = element.getAttributes().listIterator(); i.hasNext();) {
			a = (Attribute)i.next();
			name = a.getName();
			if (name.equals("id")) {
				if (id != null)
					throw new DuplicatedAttributeException("id");
				id = a.getValue();
			}
			else if (name.equals("name")) {
				if (this.name != null)
					throw new DuplicatedAttributeException("name");
				this.name = a.getValue();
			}
			else
				throw new UnexpectedAttributeException(((Element)i.next()).getName());
		}
		if (id == null)
			throw new MissingAttributeException("id");
		if (this.name == null)
			throw new MissingAttributeException("name");

		i = element.getChildren().listIterator();

		if (i.hasNext()) {
			e = (Element)i.next();
			name = e.getName();
			if (!name.equals("params"))
				throw new BadElementException(name, "params");
			params = Util.analyseParams(e);
			if (i.hasNext())
				throw new UnexpectedElementException(((Element)i.next()).getName());
		}
		else
			params = new HashMap<String,String>();
	}

	@Override
	public String toString()
	{
		StringBuilder res = new StringBuilder();
		res.append("plug-in: id=\"" + id + "\", name=\"" + name + "\"");
		for (Map.Entry<String,String> entry : params.entrySet()) {
			res.append("  " + entry.getKey() + "=\"" + entry.getValue() + "\"");
		}
		return res.toString();
	}
}
