/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.chrono;

import java.util.Hashtable;
import java.util.Map;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SampleAction;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.storage.api.ActionEvent;

public class SessionObject
implements SessionObjectAction,
TestAction,
ControlAction,
SampleAction,
DataProvider {
    private static final int STOPPED = -1;
    static final String TYPE_STOP = "Chrono stop";
    static final String TYPE_SPLIT = "Chrono split";
    static final int SAMPLE_SPLIT = 10;
    static final String SAMPLE_SPLIT_RESULT = "result";
    static final String SAMPLE_SPLIT_COMMENT = "comment";
    static final String SAMPLE_SPLIT_SUCCESSFUL = "successful";
    static final int SAMPLE_STOP = 11;
    static final String SAMPLE_STOP_RESULT = "result";
    static final String SAMPLE_STOP_COMMENT = "comment";
    static final String SAMPLE_STOP_SUCCESSFUL = "successful";
    static final int CONTROL_START = 7;
    static final int CONTROL_SUSPEND = 8;
    static final int CONTROL_RESUME = 9;
    static final int CONTROL_DROP = 12;
    static final int TEST_IS_GT = 0;
    static final String TEST_IS_GT_VALUE = "value";
    static final int TEST_IS_GTE = 1;
    static final String TEST_IS_GTE_VALUE = "value";
    static final int TEST_IS_LT = 2;
    static final String TEST_IS_LT_VALUE = "value";
    static final int TEST_IS_LTE = 3;
    static final String TEST_IS_LTE_VALUE = "value";
    static final int TEST_IS_ON = 4;
    static final int TEST_IS_OFF = 5;
    static final int TEST_IS_SUSPENDED = 6;
    private long startTime = -1L;
    private long chrono = -1L;
    private boolean suspended = false;
    private long suspendTime = 0L;

    public SessionObject(Hashtable params) {
    }

    private SessionObject(SessionObject so) {
    }

    private int getActualTime() {
        if (this.chrono == -1L) {
            return -1;
        }
        if (this.suspended) {
            return (int)(this.suspendTime - this.chrono);
        }
        return (int)(System.currentTimeMillis() - this.chrono);
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
    }

    public void reset() {
        this.startTime = -1L;
        this.chrono = -1L;
        this.suspended = false;
    }

    public boolean doTest(int number, Map params) {
        switch (number) {
            case 6: {
                return this.suspended && this.chrono != -1L;
            }
            case 5: {
                return this.chrono == -1L;
            }
            case 4: {
                return this.chrono != -1L;
            }
            case 3: {
                if (this.chrono == -1L) {
                    throw new IsacRuntimeException("Illegal attempt to get a stopped chrono's value");
                }
                return (long)this.getActualTime() <= Long.parseLong((String)params.get("value"));
            }
            case 2: {
                if (this.chrono == -1L) {
                    throw new IsacRuntimeException("Illegal attempt to get a stopped chrono's value");
                }
                return (long)this.getActualTime() < Long.parseLong((String)params.get("value"));
            }
            case 1: {
                if (this.chrono == -1L) {
                    throw new IsacRuntimeException("Illegal attempt to get a stopped chrono's value");
                }
                return (long)this.getActualTime() >= Long.parseLong((String)params.get("value"));
            }
            case 0: {
                if (this.chrono == -1L) {
                    throw new IsacRuntimeException("Illegal attempt to get a stopped chrono's value");
                }
                return (long)this.getActualTime() > Long.parseLong((String)params.get("value"));
            }
        }
        throw new Error("Unable to find this test in ~Chrono~ ISAC plugin: " + number);
    }

    public void doControl(int number, Map params) {
        switch (number) {
            case 12: {
                if (this.chrono != -1L) {
                    this.chrono = -1L;
                    break;
                }
                throw new IsacRuntimeException("Illegal attempt to drop a stopped chrono.");
            }
            case 9: {
                if (this.chrono != -1L && this.suspended) {
                    this.chrono += System.currentTimeMillis() - this.suspendTime;
                    this.suspendTime = 0L;
                    this.suspended = false;
                    break;
                }
                throw new IsacRuntimeException("Illegal attempt to resume a chrono that is not suspended.");
            }
            case 8: {
                if (this.chrono != -1L && !this.suspended) {
                    this.suspendTime = System.currentTimeMillis();
                    this.suspended = true;
                    break;
                }
                throw new IsacRuntimeException("Illegal attempt to suspend an inactive chrono.");
            }
            case 7: {
                if (this.chrono == -1L) {
                    this.chrono = this.startTime = System.currentTimeMillis();
                    this.suspended = false;
                    this.suspendTime = 0L;
                    break;
                }
                throw new IsacRuntimeException("Illegal attempt to start an already started chrono.");
            }
            default: {
                throw new Error("Unable to find this control in ~Chrono~ ISAC plugin: " + number);
            }
        }
    }

    public ActionEvent doSample(int number, Map params, ActionEvent report) {
        switch (number) {
            case 11: {
                if (this.chrono != -1L) {
                    report.duration = this.getActualTime();
                    report.comment = (String)params.get("comment");
                    report.result = (String)params.get("result");
                    String successStr = (String)params.get("successful");
                    report.successful = ParameterParser.getCheckBox((String)successStr).contains("successful");
                    report.type = TYPE_STOP;
                    report.setDate(this.startTime);
                    this.startTime = -1L;
                    this.chrono = -1L;
                    this.suspended = false;
                    return report;
                }
                throw new IsacRuntimeException("Illegal attempt to stop an inactive chrono.");
            }
            case 10: {
                if (this.chrono != -1L) {
                    report.duration = this.getActualTime();
                    report.comment = (String)params.get("comment");
                    report.result = (String)params.get("result");
                    String successStr = (String)params.get("successful");
                    report.successful = ParameterParser.getCheckBox((String)successStr).contains("successful");
                    report.type = TYPE_SPLIT;
                    report.setDate(this.startTime);
                    return report;
                }
                throw new IsacRuntimeException("Illegal attempt to split an inactive chrono.");
            }
        }
        throw new Error("Unable to find this sample in ~Chrono~ ISAC plugin: " + number);
    }

    public String doGet(String var) {
        if (this.chrono == -1L) {
            throw new IsacRuntimeException("Illegal attempt to get a stopped chrono's value.");
        }
        return String.valueOf(this.getActualTime());
    }
}

