/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.csvprovider;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.util.ClifClassLoader;

public class SessionObject
implements SessionObjectAction,
TestAction,
ControlAction,
DataProvider {
    static final String PLUGIN_BIGFILE = "bigfile";
    static final int CONTROL_NEXT = 2;
    static final int CONTROL_RESET = 3;
    static final int CONTROL_SKIP = 4;
    static final String CONTROL_SKIP_N = "n";
    static final int TEST_ENDOFFILE = 0;
    static final int TEST_NOTENDOFFILE = 1;
    static final String PLUGIN_FIELDS = "fields";
    static final String PLUGIN_LOOP = "loop";
    static final String PLUGIN_SHARED = "shared";
    static final String PLUGIN_MACINTOSH_LINE_SEPARATOR = "macintosh_line_separator";
    static final String PLUGIN_SEPARATOR = "separator";
    static final String PLUGIN_FILENAME = "filename";
    static final String PLUGIN_COMMENT = "comment";
    static final String ENABLE_CBX = "enable";
    static final String LINES_GET = "#";
    public static final char DEFAULT_SEPARATOR = ',';
    private static final Pattern pattern = Pattern.compile("\\[(\\d+)\\]");
    private String filename;
    private boolean macintoshLineSeparator;
    private char separator;
    private List<String> commentPrefixes;
    private List<String[]> allValues;
    private String[] currentValues;
    private String[] fieldNames;
    private int position = 0;
    private Boolean shared;
    private boolean loop;
    private boolean bigFile;
    private Reader input;
    private SessionObject parent;

    public SessionObject(Map<String, String> params) {
        if (params == null) {
            this.fieldNames = null;
        } else {
            String tmp = params.get(PLUGIN_SEPARATOR);
            this.separator = (char)(tmp != null && tmp.length() >= 1 ? (int)tmp.charAt(0) : 44);
            try {
                tmp = params.get(PLUGIN_FIELDS);
                this.fieldNames = tmp != null ? SessionObject.split(new StringReader(tmp), null, this.separator, false) : null;
            }
            catch (IOException ex) {
                throw new IsacRuntimeException("Incorrect field names in CsvProvider: " + params.get(PLUGIN_FIELDS), (Exception)ex);
            }
            this.macintoshLineSeparator = ParameterParser.getCheckBox((String)params.get(PLUGIN_MACINTOSH_LINE_SEPARATOR)).contains(ENABLE_CBX);
            this.shared = ParameterParser.getCheckBox((String)params.get(PLUGIN_SHARED)).contains(ENABLE_CBX);
            this.loop = ParameterParser.getCheckBox((String)params.get(PLUGIN_LOOP)).contains(ENABLE_CBX);
            this.bigFile = ParameterParser.getCheckBox((String)params.get(PLUGIN_BIGFILE)).contains(ENABLE_CBX);
            this.commentPrefixes = ParameterParser.getNField((String)params.get(PLUGIN_COMMENT));
            try {
                this.filename = params.get(PLUGIN_FILENAME);
                if (this.shared.booleanValue() || !this.bigFile) {
                    this.input = new InputStreamReader(ClifClassLoader.getClassLoader().getResourceAsStream(this.filename));
                }
                if (!this.bigFile) {
                    String[] line;
                    this.allValues = new ArrayList<String[]>();
                    while ((line = SessionObject.split(this.input, this.commentPrefixes, this.separator, this.macintoshLineSeparator)) != null) {
                        this.allValues.add(line);
                    }
                    this.input.close();
                }
                this.position = -1;
            }
            catch (Exception ex) {
                throw new IsacRuntimeException("CsvProvider can't parse file " + params.get(PLUGIN_FILENAME), ex);
            }
        }
    }

    private SessionObject(SessionObject so) {
        this.allValues = so.allValues;
        this.filename = so.filename;
        this.fieldNames = so.fieldNames;
        this.macintoshLineSeparator = so.macintoshLineSeparator;
        this.commentPrefixes = so.commentPrefixes;
        this.separator = so.separator;
        this.shared = so.shared;
        this.loop = so.loop;
        this.bigFile = so.bigFile;
        if (this.shared.booleanValue()) {
            this.parent = so;
            this.input = so.input;
        }
        this.reset();
    }

    private static String[] split(Reader enumeration, List<String> commentPrefixes, char separator, boolean macintoshLineSeparator) throws IOException {
        LinkedList<String> l = new LinkedList<String>();
        StringBuilder s = new StringBuilder();
        int state = 0;
        boolean again = true;
        while (again) {
            int c = enumeration.read();
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case -1: {
                            l.add(new String(s));
                            again = false;
                            break block0;
                        }
                        case 13: {
                            if (!macintoshLineSeparator) break block0;
                            l.add(new String(s));
                            again = false;
                            break block0;
                        }
                        case 10: {
                            if (macintoshLineSeparator) break block0;
                            l.add(new String(s));
                            again = false;
                            break block0;
                        }
                        case 34: {
                            state = 2;
                            break block0;
                        }
                    }
                    if (SessionObject.isComment(s.toString() + (char)c, l, commentPrefixes)) {
                        s.setLength(0);
                        state = 1;
                        break;
                    }
                    if (c == separator) {
                        l.add(new String(s));
                        s.setLength(0);
                        break;
                    }
                    s.append((char)c);
                    break;
                }
                case 1: {
                    switch (c) {
                        case -1: {
                            again = false;
                            break block0;
                        }
                        case 13: {
                            if (!macintoshLineSeparator) break;
                            state = 0;
                            break block0;
                        }
                        case 10: {
                            if (macintoshLineSeparator) break;
                            state = 0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (c) {
                        case -1: {
                            throw new IOException("Ending \" character is missing at end of file.");
                        }
                        case 34: {
                            state = 3;
                            break block0;
                        }
                    }
                    s.append((char)c);
                    break;
                }
                case 3: {
                    switch (c) {
                        case -1: {
                            l.add(new String(s));
                            again = false;
                            break block0;
                        }
                        case 34: {
                            s.append('\"');
                            state = 2;
                            break block0;
                        }
                        case 13: {
                            state = 0;
                            if (!macintoshLineSeparator) break block0;
                            l.add(new String(s));
                            again = false;
                            break block0;
                        }
                        case 10: {
                            state = 0;
                            if (macintoshLineSeparator) break block0;
                            l.add(new String(s));
                            again = false;
                            break block0;
                        }
                    }
                    state = 0;
                    if (c == separator) {
                        l.add(new String(s));
                        s.setLength(0);
                        break;
                    }
                    s.append((char)c);
                }
            }
        }
        return l.size() == 1 && ((String)l.get(0)).length() == 0 ? null : l.toArray(new String[l.size()]);
    }

    private static boolean isComment(String field, List<String> l, List<String> commentPrefixes) {
        if (commentPrefixes != null && l.isEmpty()) {
            for (String prefix : commentPrefixes) {
                if (!field.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
    }

    public void reset() {
        this.position = -1;
        this.currentValues = null;
        if (this.bigFile && !this.shared.booleanValue()) {
            try {
                if (this.input != null) {
                    this.input.close();
                }
                this.input = new InputStreamReader(ClifClassLoader.getClassLoader().getResourceAsStream(this.filename));
            }
            catch (Exception ex) {
                this.input = null;
                throw new IsacRuntimeException("Can't (re)set CsvProvider session object with file \"" + this.filename + "\".", ex);
            }
        }
    }

    public boolean doTest(int number, Map<String, String> params) {
        switch (number) {
            case 0: {
                return this.position != -1 && this.currentValues == null;
            }
            case 1: {
                return this.position == -1 || this.currentValues != null;
            }
        }
        throw new Error("Unable to find this test in ~CSVProvider~ ISAC plugin: " + number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doControl(int number, Map<String, String> params) {
        switch (number) {
            case 2: {
                if (this.shared.booleanValue()) {
                    Boolean bl = this.shared;
                    synchronized (bl) {
                        this.doNext();
                        break;
                    }
                }
                this.doNext();
                break;
            }
            case 3: {
                if (this.shared.booleanValue()) {
                    Boolean bl = this.shared;
                    synchronized (bl) {
                        this.parent.position = -1;
                        if (this.bigFile) {
                            try {
                                this.parent.input.close();
                                this.input = this.parent.input = new InputStreamReader(ClifClassLoader.getClassLoader().getResourceAsStream(this.filename));
                            }
                            catch (Exception ex) {
                                this.input = null;
                                this.parent.input = null;
                                throw new IsacRuntimeException("Can't reset CsvProvider with file \"" + this.filename + "\".", ex);
                            }
                        }
                        this.reset();
                        break;
                    }
                }
                this.reset();
                break;
            }
            case 4: {
                int skip = Integer.parseInt(params.get(CONTROL_SKIP_N));
                if (this.shared.booleanValue()) {
                    Boolean bl = this.shared;
                    synchronized (bl) {
                        while (skip-- > 0) {
                            this.doNext();
                        }
                        break;
                    }
                }
                while (skip-- > 0) {
                    this.doNext();
                }
                break;
            }
            default: {
                throw new Error("Unable to find this control in ~CSVProvider~ ISAC plugin: " + number);
            }
        }
    }

    private void doNext() {
        if (this.shared.booleanValue()) {
            this.position = this.parent.position;
            this.input = this.parent.input;
        }
        ++this.position;
        if (this.bigFile) {
            try {
                this.currentValues = SessionObject.split(this.input, this.commentPrefixes, this.separator, this.macintoshLineSeparator);
            }
            catch (IOException ex) {
                throw new IsacRuntimeException("CsvProvider can't read file \"" + this.filename + "\".", (Exception)ex);
            }
        } else {
            this.currentValues = this.position < this.allValues.size() ? this.allValues.get(this.position) : null;
        }
        if (this.currentValues == null) {
            if (this.loop) {
                this.position = -1;
                if (this.shared.booleanValue()) {
                    this.parent.position = -1;
                }
                if (this.bigFile) {
                    try {
                        if (this.input != null) {
                            this.input.close();
                        }
                        this.input = new InputStreamReader(ClifClassLoader.getClassLoader().getResourceAsStream(this.filename));
                    }
                    catch (Exception ex) {
                        this.input = null;
                        throw new IsacRuntimeException("CsvProvider session object can't access file \"" + this.filename + "\".", ex);
                    }
                    if (this.shared.booleanValue()) {
                        this.parent.input = this.input;
                    }
                }
                this.doNext();
            }
        } else if (this.shared.booleanValue()) {
            this.parent.position = this.position;
        }
    }

    public String doGet(String var) {
        Matcher m;
        int i;
        if (var.equals(LINES_GET)) {
            if (this.bigFile) {
                throw new IsacRuntimeException("CsvProvider for file \"" + this.filename + "\": the number of lines is not available when configured to load lines at runtime.");
            }
            return String.valueOf(this.allValues.size());
        }
        if (this.position == -1) {
            throw new IsacRuntimeException("Can't get variable " + var + " from plug-in CsvProvider for file \"" + this.filename + "\": missing initial call to control \"next\".");
        }
        if (this.currentValues == null) {
            throw new IsacRuntimeException("End of file \"" + this.filename + "\" reached in CsvProvider.");
        }
        if (this.fieldNames != null) {
            int n = this.fieldNames.length;
            for (i = 0; i < n; ++i) {
                if (!this.fieldNames[i].equals(var)) continue;
                return i < this.currentValues.length ? this.currentValues[i] : null;
            }
        }
        return (m = pattern.matcher(var)).matches() && (i = Integer.parseInt(m.group(1))) < this.currentValues.length ? this.currentValues[i] : null;
    }
}

