/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.dnsinjector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SampleAction;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.storage.api.ActionEvent;
import org.ow2.clif.util.ClifClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.Header;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

public class SessionObject
implements SessionObjectAction,
DataProvider,
ControlAction,
SampleAction,
TestAction {
    static final String PLUGIN_DNSSEC_VERIFY_SIG_ARG = "dnssec_verify_sig_arg";
    static final String PLUGIN_DNSSEC_ZONE_FILE_ARG = "dnssec_zone_file_arg";
    static final String PLUGIN_SERVER_IPV6_ARG = "server_ipv6_arg";
    static final String PLUGIN_IP_SRC_ARG = "ip_src_arg";
    private static String PRODUCT = "DnsInjector";
    private static String VERSION = "1.1";
    private static String REVISION = "$Revision: 52 $";
    private static String DATE = "$Date: 2012-10-04 15:15:55 +0200 (jeu., 04 oct. 2012) $";
    private static String AUTHOR = "$Author: yplo6403 $";
    static final int TEST_DNS_ISQUERYANSWEROK = 3;
    static final int SAMPLE_DNS_QUERY = 4;
    static final String SAMPLE_DNS_QUERY_UDP_ARG = "udp_arg";
    static final String SAMPLE_DNS_QUERY_CHECKING_DISABLE_ARG = "checking_disable_arg";
    static final String SAMPLE_DNS_QUERY_DNSSEC_ARG = "dnssec_arg";
    static final String SAMPLE_DNS_QUERY_RECURSION_DESIRED_ARG = "recursion_desired_arg";
    static final String SAMPLE_DNS_QUERY_EXPECTED_RESPONSE_ARG = "expected_response_arg";
    static final String SAMPLE_DNS_QUERY_SRC_ADDRESS_ARG = "src_address_arg";
    static final String SAMPLE_DNS_QUERY_QUERY_TYPE_ARG = "query_type_arg";
    static final String SAMPLE_DNS_QUERY_TARGET_ARG = "target_arg";
    static final String PLUGIN_DELAIL_REPORT_ARG = "delail_report_arg";
    static final String PLUGIN_SIG_KEY_VALUE_ARG = "sig_key_value_arg";
    static final String PLUGIN_SIG_KEY_NAME_ARG = "sig_key_name_arg";
    static final String PLUGIN_SIG_ALGO_ARG = "sig_algo_arg";
    static final String PLUGIN_DELAY_ARG = "delay_arg";
    static final String PLUGIN_SERVER_IPV4_ARG = "server_ipv4_arg";
    static final String PLUGIN_SOURCE_ADDRESS_BASE = "Source address base";
    static final String PLUGIN_PROTOCOL = "protocol";
    static final String PLUGIN_SERVER_PORT_ARG = "server_port_arg";
    static final String DNSSEC_PROPS_DIR = "dnssec.keys.dir";
    private static final String DATAPROVIDER_RESULT = "result";
    private static final Logger logger = LoggerFactory.getLogger((String)SessionObject.class.getSimpleName());
    private static int totalInstanceNb = 0;
    private static boolean detailedTrace = false;
    private static Name tsig_algo = null;
    private static String tsig_key_name = null;
    private static String tsig_key_value = null;
    private static TSIG tsig_key = null;
    private static InetAddress ipV4AddressDst = null;
    private static InetAddress ipV6AddressDst = null;
    private static int delayForAnswer = 30;
    private static int serverPort = 53;
    private static OPTRecord queryOPT = null;
    private int myInstanceNb;
    private boolean success = false;
    private String result = null;
    private static Object syncObject = new Object();
    private static HashSet<InetAddress> ipSrcSet = null;
    private static HashMap<Integer, DNSKEYRecord> dnskeyMap = null;
    private static boolean verifySignature = false;

    public SessionObject(Map<String, String> params) {
        String strLine;
        BufferedReader br;
        InputStream fileInputStream;
        ipSrcSet = new HashSet();
        totalInstanceNb = 0;
        logger.warn("Starting {} program at {}", (Object)PRODUCT, (Object)new Date());
        logger.warn("{} Version: {} ", (Object)PRODUCT, (Object)VERSION);
        logger.warn(PRODUCT + " {} at {}", (Object)REVISION, (Object)DATE);
        logger.debug("{} {}", (Object)PRODUCT, (Object)AUTHOR);
        String getParamStr = params.get(PLUGIN_DELAIL_REPORT_ARG);
        if (getParamStr != null) {
            detailedTrace = !getParamStr.equals("true");
        }
        logger.warn("Detailed report: {}", (Object)detailedTrace);
        getParamStr = params.get(PLUGIN_SIG_ALGO_ARG);
        if (getParamStr == null || !getParamStr.equals("none")) {
            if (getParamStr != null && getParamStr.equals("hmac-md5")) {
                tsig_algo = TSIG.HMAC_MD5;
            } else if (getParamStr != null && getParamStr.equals("hmac-sha1")) {
                tsig_algo = TSIG.HMAC_SHA1;
            } else if (getParamStr != null && getParamStr.equals("hmac-sha224")) {
                tsig_algo = TSIG.HMAC_SHA224;
            } else if (getParamStr != null && getParamStr.equals("hmac-sha256")) {
                tsig_algo = TSIG.HMAC_SHA256;
            } else if (getParamStr != null && getParamStr.equals("hmac-sha384")) {
                tsig_algo = TSIG.HMAC_SHA384;
            } else if (getParamStr != null && getParamStr.equals("hmac-sha512")) {
                tsig_algo = TSIG.HMAC_SHA512;
            }
        }
        if (tsig_algo != null && (getParamStr = params.get(PLUGIN_SIG_ALGO_ARG)) != null && getParamStr.length() > 0) {
            tsig_key_name = getParamStr;
            logger.warn("TSIG shared key name: {}", (Object)tsig_key_name);
            getParamStr = params.get(PLUGIN_SIG_KEY_VALUE_ARG);
            if (getParamStr != null && getParamStr.length() > 0) {
                tsig_key_value = getParamStr;
                logger.warn("TSIG shared key value: {}", (Object)tsig_key_value);
                tsig_key = new TSIG(tsig_algo, tsig_key_name, tsig_key_value);
                logger.warn("DNS transactions are signed with algorithm {}", (Object)tsig_algo);
            }
        }
        if (tsig_key == null) {
            logger.warn("No TSIG Signature of DNS queries");
        }
        if ((getParamStr = params.get(PLUGIN_SERVER_IPV4_ARG)) != null && getParamStr.length() != 0) {
            try {
                ipV4AddressDst = InetAddress.getByName(getParamStr);
                if (!(ipV4AddressDst instanceof Inet4Address)) {
                    logger.error("Bad server IPv4 address: {}", (Object)getParamStr);
                    throw new IsacRuntimeException("Could not instantiate DnsInjector session object: bad server IPv4 address " + getParamStr);
                }
            }
            catch (UnknownHostException e) {
                logger.error("Bad server IP address: {}", (Object)getParamStr);
                throw new IsacRuntimeException("Could not instantiate DnsInjector session object: bad server IP address " + getParamStr, (Exception)e);
            }
        }
        logger.warn("Server IPv4 address: {}", (Object)ipV4AddressDst);
        getParamStr = params.get(PLUGIN_SERVER_IPV6_ARG);
        if (getParamStr != null && getParamStr.length() != 0) {
            try {
                ipV6AddressDst = InetAddress.getByName(getParamStr);
                if (!(ipV6AddressDst instanceof Inet6Address)) {
                    logger.error("Bad server IPv6 address: {}", (Object)getParamStr);
                    throw new IsacRuntimeException("Could not instantiate DnsInjector session object: bad server IPv6 address " + getParamStr);
                }
            }
            catch (UnknownHostException e) {
                logger.error("Bad server IP address: {}", (Object)getParamStr);
                throw new IsacRuntimeException("Could not instantiate DnsInjector session object: bad server IP address " + getParamStr, (Exception)e);
            }
        }
        logger.warn("Server IPv6 address: {}", (Object)ipV6AddressDst);
        if (ipV4AddressDst == null && ipV6AddressDst == null) {
            logger.error("Cannot instantiate DnsInjector: no server IP address");
            throw new IsacRuntimeException("Cannot instantiate DnsInjector: no server IP address");
        }
        getParamStr = params.get(PLUGIN_SERVER_PORT_ARG);
        if (getParamStr != null) {
            try {
                serverPort = Integer.valueOf(getParamStr);
            }
            catch (NumberFormatException e) {
                logger.error("Bad number format for server IP port: {}", (Object)getParamStr);
                throw new IsacRuntimeException("Could not instantiate DnsInjector session object: Bad number format for server IP port " + getParamStr, (Exception)e);
            }
        }
        logger.warn("DNS server IP port: {}", (Object)serverPort);
        getParamStr = params.get(PLUGIN_IP_SRC_ARG);
        if (getParamStr != null && !getParamStr.equals("")) {
            try {
                fileInputStream = ClifClassLoader.getClassLoader().getResourceAsStream(getParamStr);
            }
            catch (Exception e) {
                logger.error("Cannot instantiate DnsInjector: unable to read {}", (Object)getParamStr);
                throw new IsacRuntimeException("Cannot instantiate DnsInjector: unable to read " + getParamStr, e);
            }
            if (fileInputStream != null) {
                br = new BufferedReader(new InputStreamReader(fileInputStream));
                try {
                    while ((strLine = br.readLine()) != null) {
                        try {
                            InetAddress addr = InetAddress.getByName(strLine);
                            if (NetworkInterface.getByInetAddress(addr) == null) {
                                logger.error("Source IP address {} is not local", (Object)strLine);
                                throw new IsacRuntimeException("Could not instantiate DnsInjector session object: source IP address is not local " + strLine);
                            }
                            if (addr.getClass() == Inet4Address.class && ipV4AddressDst != null) {
                                ipSrcSet.add(addr);
                            } else if (addr.getClass() == Inet6Address.class && ipV6AddressDst != null) {
                                ipSrcSet.add(addr);
                            } else {
                                logger.error("Source IP address {} is not compatible with server address", (Object)strLine);
                            }
                        }
                        catch (SocketException e) {
                            logger.error("Bad source IP address: {}", (Object)strLine);
                            throw new IsacRuntimeException("Could not instantiate DnsInjector session object: bad source IP address " + strLine, (Exception)e);
                        }
                        if (ipSrcSet.size() != 0) continue;
                        logger.error("No valid IP sources in file: {}", (Object)getParamStr);
                        throw new IsacRuntimeException("Could not instantiate DnsInjector session object: No valid source IP address !");
                    }
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error("Cannot load IP sources file: {}", (Object)getParamStr);
                    throw new IsacRuntimeException("Could not instantiate DnsInjector session object: cannot load IP sources file " + getParamStr, (Exception)e);
                }
            }
            logger.error("Cannot locate IP sources file: {}", (Object)getParamStr);
            throw new IsacRuntimeException("Could not instantiate DnsInjector session object:cannot locate IP sources file " + getParamStr);
        }
        logger.error("No IP sources file: {}", (Object)getParamStr);
        throw new IsacRuntimeException("Could not instantiate DnsInjector session object: no IP sources file " + getParamStr);
        dnskeyMap = new HashMap();
        getParamStr = params.get(PLUGIN_DNSSEC_VERIFY_SIG_ARG);
        if (getParamStr != null && getParamStr.equals("Verify;")) {
            verifySignature = true;
        }
        if ((getParamStr = params.get(PLUGIN_DNSSEC_ZONE_FILE_ARG)) != null && !getParamStr.equals("")) {
            try {
                fileInputStream = ClifClassLoader.getClassLoader().getResourceAsStream(getParamStr);
            }
            catch (Exception e) {
                logger.error("Cannot instantiate DnsInjector: unable to read {}", (Object)getParamStr);
                throw new IsacRuntimeException("Cannot instantiate DnsInjector: unable to read " + getParamStr, e);
            }
            if (fileInputStream != null) {
                try {
                    br = new BufferedReader(new InputStreamReader(fileInputStream));
                    while ((strLine = br.readLine()) != null) {
                        if (strLine.charAt(strLine.length() - 1) != '.') {
                            strLine = strLine + ".";
                        }
                        Name zone = null;
                        try {
                            zone = new Name(strLine);
                        }
                        catch (Exception e) {
                            logger.error("DNSSEC zone '{}' is not valid", (Object)strLine);
                            continue;
                        }
                        logger.warn("DNSSEC signature for zone '{}' must be verified", (Object)strLine);
                        InetAddress server = ipV4AddressDst;
                        if (server == null) {
                            server = ipV6AddressDst;
                        }
                        SimpleResolver resolver = new SimpleResolver(server.getHostName());
                        resolver.setPort(serverPort);
                        resolver.setEDNS(0);
                        if (tsig_key != null) {
                            resolver.setTSIGKey(tsig_key);
                        }
                        Record question = Record.newRecord((Name)zone, (int)48, (int)1);
                        Message query = Message.newQuery((Record)question);
                        Message response = null;
                        try {
                            response = resolver.send(query);
                            Header header = response.getHeader();
                            if (header.getRcode() == 0) {
                                if (header.getCount(1) > 0) {
                                    RRset[] rrSets;
                                    boolean found = false;
                                    for (RRset rrSet : rrSets = response.getSectionRRsets(1)) {
                                        if (rrSet.getType() != 48) continue;
                                        Iterator it = rrSet.rrs();
                                        while (it.hasNext()) {
                                            DNSKEYRecord dnskey;
                                            Record record = (Record)it.next();
                                            if (!(record instanceof DNSKEYRecord) || ((dnskey = (DNSKEYRecord)record).getFlags() & 0x100) != 256 || (dnskey.getFlags() & 1) != 0) continue;
                                            logger.info("Zone DNSKEY RRset found for zone '{}'", (Object)dnskey.getName());
                                            dnskeyMap.put(dnskey.getFootprint(), dnskey);
                                            found = true;
                                        }
                                    }
                                    if (found) continue;
                                    logger.warn("No ZSK for zone '{}'", (Object)zone);
                                    continue;
                                }
                                logger.warn("No DNSKEY for zone '{}'", (Object)zone);
                                continue;
                            }
                            int rcode = header.getRcode();
                            logger.warn("Cannot retreive DNSKEY for zone '{}', Rcode: '{}'", (Object)zone, (Object)Rcode.string((int)rcode));
                        }
                        catch (IOException e) {
                            logger.error("Error occurred while sending or receiving query to retreive DNSKEY for zone: " + zone);
                            e.printStackTrace();
                        }
                    }
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error("Cannot load DNSSEC zone file: {}", (Object)getParamStr);
                    throw new IsacRuntimeException("Could not instantiate DnsInjector session object, cannot load DNSSEC zone file: " + getParamStr, (Exception)e);
                }
            }
            logger.error("Cannot locate DNSSEC zone file: {}", (Object)getParamStr);
        }
        if ((getParamStr = params.get(PLUGIN_DELAY_ARG)) != null) {
            try {
                delayForAnswer = Integer.valueOf(getParamStr);
            }
            catch (NumberFormatException e) {
                logger.error("Bad number format for response delay: {}", (Object)getParamStr);
                throw new IsacRuntimeException("Could not instantiate DnsInjector session object:Bad number format for response delay " + getParamStr, (Exception)e);
            }
        }
        logger.warn("Response delay: {}", (Object)delayForAnswer);
        queryOPT = new OPTRecord(4096, 0, 0, 32768, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionObject(SessionObject so) {
        Object object = syncObject;
        synchronized (object) {
            this.myInstanceNb = ++totalInstanceNb;
        }
        if (logger.isInfoEnabled()) {
            logger.info("DNS SessionObject created {}", (Object)this.myInstanceNb);
        }
    }

    public void close() {
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void reset() {
    }

    public void doControl(int number, Map<String, String> params) {
        switch (number) {
            default: 
        }
        throw new Error("Unable to find this control in ~DnsInjector~ ISAC plugin: " + number);
    }

    public ActionEvent doSample(int number, Map<String, String> params, ActionEvent report) {
        try {
            switch (number) {
                case 4: {
                    return this.sample_dns_query(params, report);
                }
            }
            throw new Error("Unable to find this sample in ~DnsInjector~ ISAC plugin: " + number);
        }
        catch (Exception e) {
            report.successful = false;
            report.comment = e.getMessage();
            logger.error("Exception occurred ", (Throwable)e);
            return report;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ActionEvent sample_dns_query(Map<String, String> params, ActionEvent report) {
        RRset respRRset;
        Record respRecord;
        StringBuffer sb;
        String expectedAnswer;
        int queryType;
        block70: {
            int n;
            RRset[] rRsetArray;
            block69: {
                Header header;
                block67: {
                    block68: {
                        RRset[] rrSets;
                        Name target = null;
                        queryType = 1;
                        expectedAnswer = null;
                        boolean flagRD = true;
                        boolean flagCD = false;
                        boolean dnssec = false;
                        boolean udp = true;
                        InetAddress srcIp = null;
                        String queryTypeStr = null;
                        String targetStr = null;
                        SimpleResolver resolver = null;
                        InetAddress destIp = null;
                        targetStr = params.get(SAMPLE_DNS_QUERY_TARGET_ARG);
                        if (targetStr != null && targetStr.length() > 0) {
                            try {
                                if (targetStr.charAt(targetStr.length() - 1) != '.') {
                                    targetStr = targetStr + ".";
                                }
                                target = Name.fromString((String)targetStr);
                            }
                            catch (TextParseException e) {
                                logger.error("TextParseException, bad target name {}", (Object)targetStr);
                                throw new IsacRuntimeException("DnsInjector ISAC plug-in: TextParseException, bad target name " + targetStr);
                            }
                        } else {
                            logger.error("Invalid target name {}", (Object)targetStr);
                            throw new IsacRuntimeException("DnsInjector ISAC plug-in: Invalid target name " + targetStr);
                        }
                        queryTypeStr = params.get(SAMPLE_DNS_QUERY_QUERY_TYPE_ARG);
                        if (queryTypeStr == null) {
                            logger.error("TextParseException, null query type");
                            throw new IsacRuntimeException("DnsInjector ISAC plug-in: TextParseException, null query type");
                        }
                        queryType = Type.value((String)queryTypeStr);
                        if (queryType == -1) {
                            logger.error("Invalid query type: {}", (Object)queryTypeStr);
                            throw new IsacRuntimeException("DnsInjector ISAC plug-in: Invalid query type " + queryTypeStr);
                        }
                        String getParamStr = params.get(SAMPLE_DNS_QUERY_SRC_ADDRESS_ARG);
                        if (getParamStr == null) {
                            logger.error("IP source address is null");
                            throw new IsacRuntimeException("DnsInjector ISAC plug-in: IP source address is null");
                        }
                        try {
                            srcIp = InetAddress.getByName(getParamStr);
                            if (!ipSrcSet.contains(srcIp)) {
                                logger.error("source IP address {} is not within IP allowed range", (Object)getParamStr);
                                throw new IsacRuntimeException("DnsInjector ISAC plug-in: source IP address is not within IP allowed range " + getParamStr);
                            }
                            if (srcIp instanceof Inet4Address) {
                                destIp = ipV4AddressDst;
                                resolver = new SimpleResolver(ipV4AddressDst.getHostName());
                            } else {
                                destIp = ipV6AddressDst;
                                resolver = new SimpleResolver(ipV6AddressDst.getHostName());
                            }
                            resolver.setTimeout(delayForAnswer);
                            resolver.setLocalAddress(srcIp);
                            resolver.setPort(serverPort);
                            if (tsig_key != null) {
                                resolver.setTSIGKey(tsig_key);
                            }
                        }
                        catch (UnknownHostException e) {
                            logger.error("UnknownHostException, bad source IP address {}", (Object)getParamStr);
                            throw new IsacRuntimeException("DnsInjector ISAC plug-in: UnknownHostException, bad source IP address " + getParamStr);
                        }
                        getParamStr = params.get(SAMPLE_DNS_QUERY_EXPECTED_RESPONSE_ARG);
                        if (getParamStr != null && getParamStr.length() > 0) {
                            expectedAnswer = getParamStr;
                        }
                        if ((getParamStr = params.get(SAMPLE_DNS_QUERY_RECURSION_DESIRED_ARG)) != null && getParamStr.equals("0")) {
                            flagRD = false;
                        }
                        if ((getParamStr = params.get(SAMPLE_DNS_QUERY_DNSSEC_ARG)) != null && getParamStr.equals("1")) {
                            dnssec = true;
                        }
                        if ((getParamStr = params.get(SAMPLE_DNS_QUERY_CHECKING_DISABLE_ARG)) != null && getParamStr.equals("1")) {
                            flagCD = true;
                        }
                        if ((getParamStr = params.get(SAMPLE_DNS_QUERY_UDP_ARG)) != null && getParamStr.equals("0")) {
                            udp = false;
                        }
                        if (logger.isInfoEnabled()) {
                            logger.info("Send DNS Query type '" + Type.string((int)queryType) + "' via '" + destIp.getHostAddress() + "' for '" + target + "' RD=" + flagRD + " CD=" + flagCD + " D0=" + dnssec + " UDP=" + udp);
                        }
                        if (expectedAnswer != null) {
                            logger.debug("Expected answer: '{}'", (Object)expectedAnswer);
                        }
                        Record question = Record.newRecord((Name)target, (int)queryType, (int)1);
                        Message query = Message.newQuery((Record)question);
                        if (dnssec) {
                            query.addRecord((Record)queryOPT, 3);
                        }
                        if (flagCD) {
                            query.getHeader().setFlag(11);
                        }
                        if (!flagRD) {
                            query.getHeader().unsetFlag(7);
                        }
                        if (!udp) {
                            resolver.setTCP(true);
                        }
                        sb = new StringBuffer(targetStr);
                        sb.append(" -t ");
                        sb.append(queryTypeStr);
                        sb.append(" via ");
                        sb.append(destIp.getHostAddress());
                        if (detailedTrace) {
                            report.comment = sb.toString();
                        }
                        report.type = "dnsQuery";
                        report.setDate(System.currentTimeMillis());
                        Message msg = null;
                        try {
                            msg = resolver.send(query);
                        }
                        catch (IOException e) {
                            report.duration = (int)(System.currentTimeMillis() - report.getDate());
                            logger.warn("Timeout for query: '{}' after {}", (Object)sb.toString(), (Object)report.duration);
                            report.result = "timeout";
                            report.successful = false;
                            return report;
                        }
                        header = msg.getHeader();
                        report.duration = (int)(System.currentTimeMillis() - report.getDate());
                        report.successful = true;
                        this.success = true;
                        respRecord = null;
                        respRRset = null;
                        if (header.getRcode() != 0) break block67;
                        if (header.getCount(1) <= 0) break block68;
                        rRsetArray = rrSets = msg.getSectionRRsets(1);
                        n = rRsetArray.length;
                        break block69;
                    }
                    if (!logger.isInfoEnabled()) break block70;
                    logger.info("Answer to query '{}' with NOERROR and no record after '{}'", (Object)sb.toString(), (Object)report.duration);
                    break block70;
                }
                int rcode = header.getRcode();
                logger.warn("Answer to query '{}' with Rcode: '{}' after " + report.duration, (Object)sb.toString(), (Object)Rcode.string((int)rcode));
                break block70;
            }
            for (int i = 0; i < n; ++i) {
                RRset rrSet = rRsetArray[i];
                if (rrSet.getType() != queryType) continue;
                respRRset = rrSet;
                Iterator it = rrSet.rrs();
                if (!it.hasNext()) break;
                respRecord = (Record)it.next();
                break;
            }
        }
        if (verifySignature && respRRset != null) {
            Iterator it = respRRset.sigs();
            boolean signatureIsAvailable = false;
            boolean dnskeyFound = false;
            if (it.hasNext()) {
                signatureIsAvailable = true;
            }
            while (it.hasNext()) {
                RRSIGRecord rrsig;
                Record record = (Record)it.next();
                if (!(record instanceof RRSIGRecord) || !dnskeyMap.containsKey((rrsig = (RRSIGRecord)record).getFootprint())) continue;
                dnskeyFound = true;
                try {
                    DNSSEC.verify((RRset)respRRset, (RRSIGRecord)rrsig, (DNSKEYRecord)dnskeyMap.get(rrsig.getFootprint()));
                    logger.info("DNSSEC Signature is verified OK for query '{}'", (Object)sb.toString());
                }
                catch (DNSSEC.DNSSECException e) {
                    logger.error("DNSSEC Signature '{}' is wrong for query '{}'", (Object)rrsig, (Object)sb.toString());
                    break;
                }
            }
            if (signatureIsAvailable && !dnskeyFound) {
                logger.warn("Response is signed but no DNSSEC key was found for query '{}'", (Object)sb.toString());
            }
        }
        this.result = null;
        if (respRecord == null) {
            if (expectedAnswer == null) return report;
            report.successful = false;
            this.success = false;
            logger.warn("No matching answer for query '{}' / '{}' after " + report.duration, (Object)sb.toString(), (Object)expectedAnswer);
            return report;
        }
        switch (queryType) {
            case 1: {
                ARecord record = (ARecord)respRecord;
                this.result = record.getAddress().getHostAddress();
                if (detailedTrace) {
                    report.result = this.result;
                }
                if (expectedAnswer != null && !expectedAnswer.equals(this.result)) {
                    report.successful = false;
                    this.success = false;
                    logger.warn("Unexpected answer for '{}': '" + this.result + "' instead of '{}' after " + report.duration, (Object)sb.toString(), (Object)expectedAnswer);
                    return report;
                }
                if (!logger.isInfoEnabled()) return report;
                logger.info("Answer to query '{}' is '{}' after " + report.duration, (Object)sb.toString(), (Object)this.result);
                return report;
            }
            case 28: {
                ARecord record = (AAAARecord)respRecord;
                this.result = record.getAddress().getHostAddress();
                if (detailedTrace) {
                    report.result = this.result;
                }
                if (expectedAnswer != null && !expectedAnswer.equals(this.result)) {
                    report.successful = false;
                    this.success = false;
                    logger.warn("Unexpected answer for query '{}': '" + this.result + "' instead of '{}' after " + report.duration, (Object)sb.toString(), (Object)expectedAnswer);
                    return report;
                }
                if (!logger.isInfoEnabled()) return report;
                logger.info("Answer to query '{}' is '{}' after " + report.duration, (Object)sb.toString(), (Object)this.result);
                return report;
            }
            case 2: {
                ARecord record = (NSRecord)respRecord;
                this.result = record.getTarget().toString();
                if (detailedTrace) {
                    report.result = this.result;
                }
                if (expectedAnswer != null && !expectedAnswer.equals(this.result)) {
                    report.successful = false;
                    this.success = false;
                    logger.warn("Unexpected answer for query '{}': '" + this.result + "' instead of '{}' after " + report.duration, (Object)sb.toString(), (Object)expectedAnswer);
                    return report;
                }
                if (!logger.isInfoEnabled()) return report;
                logger.info("Answer to query '{}' is '{}' after " + report.duration, (Object)sb.toString(), (Object)this.result);
                return report;
            }
            case 5: {
                ARecord record = (CNAMERecord)respRecord;
                this.result = record.getTarget().toString();
                if (detailedTrace) {
                    report.result = this.result;
                }
                if (expectedAnswer != null && !expectedAnswer.equals(this.result)) {
                    report.successful = false;
                    this.success = false;
                    logger.warn("Unexpected answer for query '{}': '" + this.result + "' instead of '{}' after " + report.duration, (Object)sb.toString(), (Object)expectedAnswer);
                    return report;
                }
                if (!logger.isInfoEnabled()) return report;
                logger.info("Answer to query '{}' is '{}' after " + report.duration, (Object)sb.toString(), (Object)this.result);
                return report;
            }
            case 39: {
                ARecord record = (DNAMERecord)respRecord;
                this.result = record.getTarget().toString();
                if (detailedTrace) {
                    report.result = this.result;
                }
                if (expectedAnswer != null && !expectedAnswer.equals(this.result)) {
                    report.successful = false;
                    this.success = false;
                    logger.warn("Unexpected answer for query '{}': '" + this.result + "' instead of '{}' after " + report.duration, (Object)sb.toString(), (Object)expectedAnswer);
                    return report;
                }
                if (!logger.isInfoEnabled()) return report;
                logger.info("Answer to query '{}' is '{}' after " + report.duration, (Object)sb.toString(), (Object)this.result);
                return report;
            }
            case 6: {
                ARecord record = (SOARecord)respRecord;
                this.result = record.rdataToString();
                if (detailedTrace) {
                    report.result = this.result;
                }
                if (expectedAnswer != null && !expectedAnswer.equals(this.result)) {
                    report.successful = false;
                    this.success = false;
                    logger.warn("Unexpected answer for query '{}': '" + this.result + "' instead of '{}' after " + report.duration, (Object)sb.toString(), (Object)expectedAnswer);
                    return report;
                }
                if (!logger.isInfoEnabled()) return report;
                logger.info("Answer to query '{}' is '{}' after " + report.duration, (Object)sb.toString(), (Object)this.result);
                return report;
            }
            case 16: {
                ARecord record = (TXTRecord)respRecord;
                ArrayList list = (ArrayList)record.getStrings();
                if (list != null && list.size() > 0) {
                    this.result = (String)list.get(0);
                }
                if (detailedTrace) {
                    report.result = this.result;
                }
                if (expectedAnswer != null && !expectedAnswer.equals(this.result)) {
                    report.successful = false;
                    this.success = false;
                    logger.warn("Unexpected answer for query '{}': '" + this.result + "' instead of '{}' after " + report.duration, (Object)sb.toString(), (Object)expectedAnswer);
                    return report;
                }
                if (!logger.isInfoEnabled()) return report;
                logger.info("Answer to query '{}' is '{}' after " + report.duration, (Object)sb.toString(), (Object)this.result);
                return report;
            }
            case 12: {
                ARecord record = (PTRRecord)respRecord;
                this.result = record.getTarget().toString();
                if (detailedTrace) {
                    report.result = this.result;
                }
                if (expectedAnswer != null && !expectedAnswer.equals(this.result)) {
                    report.successful = false;
                    this.success = false;
                    logger.warn("Unexpected answer for query '{}': '" + this.result + "' instead of '{}' after " + report.duration, (Object)sb.toString(), (Object)expectedAnswer);
                    return report;
                }
                if (!logger.isInfoEnabled()) return report;
                logger.info("Answer to query '{}' is '{}' after " + report.duration, (Object)sb.toString(), (Object)this.result);
                return report;
            }
            case 15: {
                ARecord record = (MXRecord)respRecord;
                this.result = record.getTarget().toString();
                if (detailedTrace) {
                    report.result = this.result;
                }
                if (expectedAnswer != null && !expectedAnswer.equals(this.result)) {
                    report.successful = false;
                    this.success = false;
                    logger.warn("Unexpected answer for query '{}': '" + this.result + "' instead of '{}' after " + report.duration, (Object)sb.toString(), (Object)expectedAnswer);
                    return report;
                }
                if (!logger.isInfoEnabled()) return report;
                logger.info("Answer to query '{}' is '{}' after " + report.duration, (Object)sb.toString(), (Object)this.result);
                return report;
            }
        }
        if (detailedTrace) {
            report.result = respRecord;
        }
        if (!logger.isInfoEnabled()) return report;
        logger.info("Answer to query '{}' is {} after " + report.duration, (Object)sb.toString(), respRecord);
        return report;
    }

    public boolean doTest(int number, Map<String, String> params) {
        switch (number) {
            case 3: {
                return this.success;
            }
        }
        throw new Error("Unable to find this test in ~DnsInjector~ ISAC plugin: " + number);
    }

    public String doGet(String var) {
        if (var.equals(DATAPROVIDER_RESULT)) {
            String doGet = "";
            if (this.result != null) {
                doGet = this.result;
            }
            return doGet;
        }
        throw new IsacRuntimeException("Unknown parameter value in ~DnsInjector~ ISAC plugin: " + var);
    }
}

