/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.dnsprovider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.util.ClifClassLoader;
import org.ow2.isac.plugin.dnsprovider.Utils;
import org.ow2.isac.plugin.dnsprovider.WeightedTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionObject
implements SessionObjectAction,
ControlAction,
DataProvider {
    static final String PLUGIN_IP4REVERSE = "IP4reverse";
    static final String PLUGIN_IP6REVERSE = "IP6reverse";
    static final String PLUGIN_DNSSEC_ARG = "dnssec_arg";
    static final String PLUGIN_UDP_ARG = "udp_arg";
    static final String PLUGIN_RD_FLAG_ARG = "rd_flag_arg";
    static final String PLUGIN_ZONE_ARG = "zone_arg";
    static final String PLUGIN_INDEX_LENGTH_ARG = "index_length_arg";
    static final int CONTROL_NEXT = 0;
    static final String PLUGIN_IP_SRC_ARG = "ip_src_arg";
    static final String PLUGIN_QTYPE_ARG = "qtype_arg";
    static final String PLUGIN_LAST_INDEX_DOMAIN_ARG = "last_index_domain_arg";
    static final String PLUGIN_FIRST_INDEX_DOMAIN_ARG = "first_index_domain_arg";
    static final String PLUGIN_FORMAT_ARG = "format_arg";
    private static long domainIndex = 0L;
    private static long startDomainIndex = 0L;
    private static long endDomainIndex = -1L;
    private static String domainFormat = null;
    private static int indexLength = 6;
    private static final Logger logger = LoggerFactory.getLogger((String)SessionObject.class.getSimpleName());
    private static WeightedTable<String> ipSrcTable = null;
    private static WeightedTable<String> queryTypeTable = null;
    private static WeightedTable<String> zoneTable = null;
    private static WeightedTable<String> dnsSecTable = null;
    private static WeightedTable<String> flagRdTable = null;
    private static WeightedTable<String> udpTable = null;
    private static WeightedTable<BigInteger> ip6revTable = null;
    private static WeightedTable<Integer> ip4revTable = null;
    private static Object syncObject = new Object();
    private String domainName;
    private String ipSource;
    private String queryType;
    private String dnssec;
    private String rd;
    private String udp;
    private BigInteger ip6rev = null;
    private Integer ip4rev = null;
    static int counterGet = 0;
    static BigInteger counterGetBI = BigInteger.ZERO;
    private static final char[] hex = "0123456789abcdef".toCharArray();

    public SessionObject(Map<String, String> params) {
        byte[] s;
        InetAddress in;
        HashMap<Number, Integer> map2;
        Map<String, Integer> map;
        String zoneFileLocation = null;
        String qtypeFileLocation = null;
        String ipSrcFileLocation = null;
        String ip6revFileLocation = null;
        String ip4revFileLocation = null;
        String PRODUCT = "DnsProvider";
        String VERSION = "1.0";
        String REVISION = "$LastChangedRevision: 1999 $";
        String DATE = "$LastChangedDate: 2013-01-31 16:56:36 +0100 (jeu., 31 janv. 2013) $";
        String AUTHOR = "$LastChangedBy: yplo6403 $";
        int ratioDnsSec = 0;
        int ratioRDflag = 100;
        int ratioUdp = 100;
        logger.warn("Starting {} program at {}", (Object)PRODUCT, (Object)new Date());
        logger.warn("{} Version: {} ", (Object)PRODUCT, (Object)VERSION);
        logger.warn(PRODUCT + " {} at {}", (Object)REVISION, (Object)DATE);
        logger.warn("{} {}", (Object)PRODUCT, (Object)AUTHOR);
        domainFormat = params.get(PLUGIN_FORMAT_ARG);
        logger.warn("Domain name target format: {}", (Object)domainFormat);
        try {
            startDomainIndex = Long.valueOf(params.get(PLUGIN_FIRST_INDEX_DOMAIN_ARG));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        logger.warn("Start index for Domain name target: {}", (Object)startDomainIndex);
        domainIndex = startDomainIndex;
        try {
            endDomainIndex = Long.valueOf(params.get(PLUGIN_LAST_INDEX_DOMAIN_ARG));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (endDomainIndex != -1L) {
            if (startDomainIndex < endDomainIndex) {
                logger.warn("Last index for Domain name target: {}", (Object)endDomainIndex);
            } else {
                logger.error("Last index for Domain name target: {} mus be greater thant start index: {}", (Object)endDomainIndex, (Object)startDomainIndex);
            }
        }
        try {
            indexLength = Integer.valueOf(params.get(PLUGIN_INDEX_LENGTH_ARG));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        logger.warn("Index length for Domain name target: {}", (Object)indexLength);
        try {
            ratioDnsSec = Integer.valueOf(params.get(PLUGIN_DNSSEC_ARG));
            if (ratioDnsSec < 0 || ratioDnsSec > 100) {
                ratioDnsSec = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        logger.warn("DNSSEC ratio: {}", (Object)ratioDnsSec);
        dnsSecTable = this.initRatioTable(ratioDnsSec, "DNSSEC");
        dnsSecTable.display();
        try {
            ratioRDflag = Integer.valueOf(params.get(PLUGIN_RD_FLAG_ARG));
            if (ratioRDflag < 0 || ratioRDflag > 100) {
                ratioRDflag = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        logger.warn("Recursion Desired (RD flag) ratio: {}", (Object)ratioRDflag);
        flagRdTable = this.initRatioTable(ratioRDflag, "Recursion Desired (RD flag)");
        flagRdTable.display();
        try {
            ratioUdp = Integer.valueOf(params.get(PLUGIN_UDP_ARG));
            if (ratioUdp < 0 || ratioUdp > 100) {
                ratioUdp = 100;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        logger.warn("UDP protocol (vs. TCP) ratio: {}", (Object)ratioUdp);
        udpTable = this.initRatioTable(ratioUdp, "UDP protocol (vs TCP)");
        udpTable.display();
        zoneFileLocation = params.get(PLUGIN_ZONE_ARG);
        if (zoneFileLocation != null && zoneFileLocation.length() != 0) {
            if (domainFormat.charAt(domainFormat.length() - 1) != '.') {
                domainFormat = domainFormat.concat(".");
            }
            map = this.readWeightedFile(zoneFileLocation, "Zone");
            zoneTable = new WeightedTable<String>(map, "zone");
            zoneTable.display();
        }
        if ((qtypeFileLocation = params.get(PLUGIN_QTYPE_ARG)) != null && qtypeFileLocation.length() != 0) {
            map = this.readWeightedFile(qtypeFileLocation, "Query");
            queryTypeTable = new WeightedTable<String>(map, "Query");
            queryTypeTable.display();
        }
        if ((ipSrcFileLocation = params.get(PLUGIN_IP_SRC_ARG)) != null && ipSrcFileLocation.length() != 0) {
            map = this.readWeightedFile(ipSrcFileLocation, "IP source");
            ipSrcTable = new WeightedTable<String>(map, "IP source");
            ipSrcTable.display();
        }
        if ((ip6revFileLocation = params.get(PLUGIN_IP6REVERSE)) != null && ip6revFileLocation.length() != 0) {
            map = this.readWeightedFile(ip6revFileLocation, "IPv6 reverse");
            map2 = new HashMap<Number, Integer>();
            for (String ip6 : map.keySet()) {
                try {
                    in = InetAddress.getByName(ip6);
                    if (in instanceof Inet6Address) {
                        s = ((Inet6Address)in).getAddress();
                        map2.put(new BigInteger(s), map.get(ip6));
                        continue;
                    }
                    logger.error("Address '{}' is not IPv6 for IPv6 reverse", (Object)ip6);
                }
                catch (Exception e) {
                    logger.error("Fail to load IPv6 addresses '{}' for IPv6 reverse", (Object)ip6);
                }
            }
            if (map2.size() != 0) {
                ip6revTable = new WeightedTable(map2, "IPv6 reverse");
            }
        }
        if ((ip4revFileLocation = params.get(PLUGIN_IP4REVERSE)) != null && ip4revFileLocation.length() != 0) {
            map = this.readWeightedFile(ip4revFileLocation, "IPv4 reverse");
            map2 = new HashMap();
            for (String ip4 : map.keySet()) {
                try {
                    in = InetAddress.getByName(ip4);
                    if (in instanceof Inet4Address) {
                        s = ((Inet4Address)in).getAddress();
                        map2.put(Utils.byteArrayToInt(s), map.get(ip4));
                        continue;
                    }
                    logger.error("Address '{}' is not IPv4 for IPv4 reverse", (Object)ip4);
                }
                catch (Exception e) {
                    logger.error("Fail to load IPv4 addresses '{}' for IPv4 reverse", (Object)ip4);
                }
            }
            if (map2.size() != 0) {
                ip4revTable = new WeightedTable(map2, "IPv4 reverse");
            }
        }
    }

    private SessionObject(SessionObject so) {
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
    }

    public void reset() {
    }

    public void doControl(int number, Map<String, String> params) {
        switch (number) {
            case 0: {
                this.getNext();
                return;
            }
        }
        throw new Error("Unable to find this control in ~DnsProvider~ ISAC plugin: " + number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNext() {
        Object object = syncObject;
        synchronized (object) {
            ++counterGet;
            counterGetBI = counterGetBI.add(BigInteger.ONE);
            domainIndex = endDomainIndex != -1L ? startDomainIndex + domainIndex % (endDomainIndex - startDomainIndex + 1L) : ++domainIndex;
            String indexStr = SessionObject.getIndexStr(domainIndex, indexLength);
            this.domainName = domainFormat.replaceAll("<index>", indexStr);
            if (zoneTable != null) {
                this.domainName = this.domainName.concat(zoneTable.getNext());
            }
            this.queryType = queryTypeTable.getNext();
            this.ipSource = ipSrcTable.getNext();
            this.dnssec = dnsSecTable.getNext();
            this.rd = flagRdTable.getNext();
            this.udp = udpTable.getNext();
            if (ip4revTable != null) {
                this.ip4rev = ip4revTable.getNext() + counterGet;
            }
            if (ip6revTable != null) {
                this.ip6rev = ip6revTable.getNext().add(counterGetBI);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("DnsProvides domain:'{}' query: '{}' ip-src: '" + this.ipSource + "' DNSSEC: " + this.dnssec + " RD: " + this.rd + " UDP: " + this.udp, (Object)this.domainName, (Object)this.queryType);
                if (this.ip4rev != null) {
                    logger.trace("IPv4 reverse, reverse @:'{}'", (Object)this.ip4toReverseDotted(this.ip4rev));
                }
                if (this.ip6rev != null) {
                    logger.trace("IPv6 reverse: reverse @:'{}'", (Object)this.ip6toReverseDotted(this.ip6rev));
                    logger.trace("IPv6 reverse: undotted @:'{}'", (Object)this.ip6toForwardUndotted(this.ip6rev));
                }
            }
        }
    }

    private static String getIndexStr(long index, int len) {
        String indexStr = String.valueOf(index);
        if (indexStr.length() > len) {
            indexStr = indexStr.substring(indexStr.length() - len, indexStr.length());
        } else {
            while (indexStr.length() < len) {
                indexStr = "0" + indexStr;
            }
        }
        return indexStr;
    }

    public String doGet(String var) {
        if (var.equals("domain")) {
            return this.domainName;
        }
        if (var.equals("query")) {
            return this.queryType;
        }
        if (var.equals("ip")) {
            return this.ipSource;
        }
        if (var.equals("dnssec")) {
            return this.dnssec;
        }
        if (var.equals("rd")) {
            return this.rd;
        }
        if (var.equals("udp")) {
            return this.udp;
        }
        if (var.equals("ip6rev")) {
            if (this.ip6rev != null) {
                return this.ip6toReverseDotted(this.ip6rev);
            }
            throw new IsacRuntimeException("IPv6 address is not defined for reverse DNS");
        }
        if (var.equals("ip6for")) {
            if (this.ip6rev != null) {
                return this.ip6toForwardUndotted(this.ip6rev);
            }
            throw new IsacRuntimeException("IPv6 address is not defined for reverse DNS");
        }
        if (var.equals("ip4rev")) {
            if (this.ip4rev != null) {
                return this.ip4toReverseDotted(this.ip4rev);
            }
            throw new IsacRuntimeException("IPv4 address is not defined for reverse DNS");
        }
        throw new IsacRuntimeException("Unknown parameter value in ~DnsProvider~ ISAC plugin: " + var);
    }

    public Map<String, Integer> readWeightedFile(String fileLocation, String title) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            String strLine;
            InputStream weightedFileIS;
            try {
                weightedFileIS = ClifClassLoader.getClassLoader().getResourceAsStream(fileLocation);
            }
            catch (Exception e) {
                logger.error("Could not instantiate DnsProvider: unable to read {}", (Object)fileLocation);
                throw new IsacRuntimeException("Could not instantiate DnsProvider session object: unable to read " + fileLocation, e);
            }
            if (weightedFileIS == null) {
                logger.error("Cannot load file: " + fileLocation);
                throw new IsacRuntimeException("Could not instantiate DnsProvider session object:cannot load file " + fileLocation);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(weightedFileIS));
            while ((strLine = br.readLine()) != null) {
                String[] str = strLine.split(",");
                if (str.length != 2) continue;
                try {
                    Integer val = new Integer(str[1]);
                    map.put(str[0], val);
                }
                catch (NumberFormatException e) {
                    logger.error("Line '{}' of file is discarded", (Object)strLine);
                }
            }
            weightedFileIS.close();
            logger.warn("'{}' File '{}' is loaded", (Object)title, (Object)fileLocation);
            return map;
        }
        catch (IOException ioe) {
            logger.error("Cannot open zone file", (Throwable)ioe);
            throw new IsacRuntimeException("Could not instantiate DnsProvider session object:cannot locate file " + fileLocation);
        }
    }

    public WeightedTable<String> initRatioTable(Integer ratio, String title) {
        if (ratio < 0 || ratio > 100) {
            throw new IllegalArgumentException("Cannot create weighted table '" + title + "'");
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("1", ratio);
        map.put("0", 100 - ratio);
        return new WeightedTable<String>(map, title);
    }

    private String ip4toReverseDotted(int ip4) {
        byte[] tab = Utils.intToByteArray(ip4);
        StringBuffer sb = new StringBuffer();
        sb.append(tab[3] & 0xFF);
        sb.append(".");
        sb.append(tab[2] & 0xFF);
        sb.append(".");
        sb.append(tab[1] & 0xFF);
        sb.append(".");
        sb.append(tab[0] & 0xFF);
        return sb.toString();
    }

    private String ip6toReverseDotted(BigInteger ip6) {
        byte[] tab = ip6.toByteArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            sb.append(hex[tab[15 - i] & 0xF]);
            sb.append(".");
            sb.append(hex[tab[15 - i] >> 4 & 0xF]);
            if (i == 15) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    private String ip6toForwardUndotted(BigInteger ip6) {
        byte[] tab = ip6.toByteArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            sb.append(hex[tab[i] >> 4 & 0xF]);
            sb.append(hex[tab[i] & 0xF]);
        }
        return sb.toString();
    }
}

