/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.dnsprovider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ow2.isac.plugin.dnsprovider.GreatestCommonDivisor;
import org.ow2.isac.plugin.dnsprovider.WeightedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightedTable<T> {
    String title = null;
    int index = 0;
    int total = 0;
    List<T> elts = null;
    List<WeightedElement<T>> table = null;
    private static final Logger logger = LoggerFactory.getLogger((String)WeightedTable.class.getSimpleName());

    /*
     * WARNING - void declaration
     */
    public WeightedTable(Map<T, Integer> map, String title) {
        this.title = title;
        this.table = new ArrayList<WeightedElement<T>>();
        this.index = 0;
        for (T key : map.keySet()) {
            try {
                int weight = map.get(key);
                this.table.add(new WeightedElement<T>(key, weight));
            }
            catch (NumberFormatException e) {
                logger.error("Data: {} has invalid weight {}", key, (Object)map.get(key));
            }
        }
        switch (this.table.size()) {
            case 0: {
                logger.error("Weitghted table is empty !");
                throw new IllegalArgumentException("Cannot load weighted table '" + title + "'");
            }
            case 1: {
                this.table.get(0).setWeight(1);
                this.total = 1;
                break;
            }
            default: {
                int[] tableWeight = new int[this.table.size()];
                int i = 0;
                for (WeightedElement<T> weightedElement : this.table) {
                    tableWeight[i++] = weightedElement.getWeight();
                }
                int gcd = GreatestCommonDivisor.greatestCommonDivisor(tableWeight);
                for (WeightedElement<T> weightedElement : this.table) {
                    weightedElement.setWeight(weightedElement.getWeight() / gcd);
                    this.total += weightedElement.getWeight();
                }
            }
        }
        this.elts = new ArrayList<T>();
        int i = 0;
        for (WeightedElement<T> weightedElement : this.table) {
            void var6_15;
            boolean bl = false;
            while (var6_15 < weightedElement.getWeight()) {
                this.elts.add(i++, weightedElement.getElement());
                ++var6_15;
            }
        }
        Collections.shuffle(this.elts);
    }

    public T getNext() {
        this.index = (this.index + 1) % this.total;
        return this.elts.get(this.index);
    }

    public void display() {
        for (WeightedElement<T> elt : this.table) {
            logger.debug(this.title + " '{}' has weight '{}'", elt.getElement(), (Object)elt.getWeight());
        }
    }

    public int getTotal() {
        return this.total;
    }
}

