/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.filewriter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;

public class SessionObject
implements SessionObjectAction,
ControlAction,
DataProvider,
TestAction {
    static final int TEST_ISOPEN = 7;
    static final int TEST_ISNOTOPEN = 8;
    static final int TEST_EXISTS = 10;
    static final String TEST_EXISTS_PATH = "path";
    static final int TEST_EXISTSNOT = 11;
    static final String TEST_EXISTSNOT_PATH = "path";
    static final int CONTROL_WRITE = 2;
    static final String CONTROL_WRITE_STRING = "string";
    static final int CONTROL_WRITELN = 3;
    static final String CONTROL_WRITELN_STRING = "string";
    static final int CONTROL_NEWLINE = 4;
    static final int CONTROL_FLUSH = 5;
    static final int CONTROL_CLOSE = 6;
    static final int CONTROL_OPEN = 9;
    static final String CONTROL_OPEN_PATH = "path";
    static final String CONTROL_OPEN_APPEND = "append";
    static final String PLUGIN_CHARSET = "charset";
    private BufferedWriter writer = null;
    private String charset = null;
    private File current = null;

    public SessionObject(Map<String, String> params) {
        this.charset = ParameterParser.getCombo((String)params.get(PLUGIN_CHARSET));
    }

    private SessionObject(SessionObject so) {
        this.charset = so.charset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFile(String content, boolean newline) {
        if (this.writer == null) throw new IsacRuntimeException("~FileWriter~ plug-in can't write: no open file");
        try {
            if (content != null) {
                this.writer.write(content);
            }
            if (newline) {
                this.writer.newLine();
            }
            if (newline || content != null) return;
            this.writer.flush();
            return;
        }
        catch (Exception ex) {
            throw new IsacRuntimeException("~FileWriter~ plug-in can't write to file " + this.current, ex);
        }
    }

    private void openFile(String path, boolean append) {
        this.close();
        try {
            this.current = new File(path);
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.current, append), this.charset));
        }
        catch (Exception ex) {
            this.current = null;
            this.writer = null;
            throw new IsacRuntimeException("~FileWriter~ plug-in could not open file " + path, ex);
        }
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException ex) {
                throw new IsacRuntimeException("~FileWriter~ plug-in could not close file " + this.current, (Exception)ex);
            }
            finally {
                this.writer = null;
                this.current = null;
            }
        }
    }

    public void reset() {
        this.close();
    }

    public void doControl(int number, Map<String, String> params) {
        switch (number) {
            case 9: {
                String option = ParameterParser.getRadioGroup((String)params.get(CONTROL_OPEN_APPEND));
                this.openFile(params.get("path"), !option.equalsIgnoreCase("overwrite"));
                break;
            }
            case 6: {
                this.close();
                break;
            }
            case 5: {
                this.writeFile(null, false);
                break;
            }
            case 4: {
                this.writeFile(null, true);
                break;
            }
            case 3: {
                this.writeFile(params.get("string"), true);
                break;
            }
            case 2: {
                this.writeFile(params.get("string"), false);
                break;
            }
            default: {
                throw new Error("Unable to find this control in ~FileWriter~ ISAC plugin: " + number);
            }
        }
    }

    public String doGet(String var) {
        if (var.equals("pathname")) {
            return this.current.toString();
        }
        if (var.equals("dirname")) {
            return this.current.getParent();
        }
        if (var.equals("basename")) {
            return this.current.getName();
        }
        if (var.equals("length")) {
            return String.valueOf(this.current.length());
        }
        throw new IsacRuntimeException("Unknown variable in ~FileWriter~ plug-in: " + var);
    }

    public boolean doTest(int number, Map<String, String> params) {
        switch (number) {
            case 11: {
                return !new File(params.get("path")).exists();
            }
            case 10: {
                return new File(params.get("path")).exists();
            }
            case 8: {
                return this.current == null;
            }
            case 7: {
                return this.current != null;
            }
        }
        throw new Error("Unable to find this test #" + number + " in ~FileWriter~ ISAC plugin");
    }
}

