/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.ftpinjector;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SampleAction;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.storage.api.ActionEvent;
import org.ow2.clif.util.Random;

public class SessionObject
implements SessionObjectAction,
SampleAction,
TestAction,
ControlAction,
DataProvider {
    static final int CONTROL_LCD = 4;
    static final String CONTROL_LCD_PATH = "path";
    static final int TEST_CONNECTED = 3;
    static final String TEST_CONNECTED_OPTIONS = "options";
    static final int TEST_LOGGEDIN = 7;
    static final String TEST_LOGGEDIN_OPTIONS = "options";
    static final int TEST_REPLYCODEIS = 9;
    static final String TEST_REPLYCODEIS_OPTIONS = "options";
    static final String TEST_REPLYCODEIS_CODE = "code";
    static final int SAMPLE_CONNECT = 0;
    static final String SAMPLE_CONNECT_COMMENT = "comment";
    static final String SAMPLE_CONNECT_LOCALADDRESS = "localaddress";
    static final String SAMPLE_CONNECT_PORT = "port";
    static final String SAMPLE_CONNECT_HOST = "host";
    static final int SAMPLE_STORE = 1;
    static final String SAMPLE_STORE_REMOTE_FILE = "remote file";
    static final String SAMPLE_STORE_TIME = "time";
    static final String SAMPLE_STORE_SIZE = "size";
    static final String SAMPLE_STORE_LIMIT = "limit";
    static final String SAMPLE_STORE_FILE = "file";
    static final String SAMPLE_STORE_CONTENT = "content";
    static final int SAMPLE_DISCONNECT = 2;
    static final String SAMPLE_DISCONNECT_COMMENT = "comment";
    static final int SAMPLE_CD = 5;
    static final String SAMPLE_CD_PATH = "path";
    static final int SAMPLE_LOGIN = 6;
    static final String SAMPLE_LOGIN_COMMENT = "comment";
    static final String SAMPLE_LOGIN_PASSWORD = "password";
    static final String SAMPLE_LOGIN_LOGIN = "login";
    static final int SAMPLE_LOGOUT = 8;
    static final String SAMPLE_LOGOUT_COMMENT = "comment";
    static final int SAMPLE_NOOP = 10;
    static final String SAMPLE_NOOP_COMMENT = "comment";
    static final int SAMPLE_SETFILETYPE = 11;
    static final String SAMPLE_SETFILETYPE_FORMAT = "format";
    static final String SAMPLE_SETFILETYPE_BYTE_SIZE = "byte size";
    static final String SAMPLE_SETFILETYPE_TYPE = "type";
    static final int SAMPLE_RETRIEVE = 12;
    static final String SAMPLE_RETRIEVE_TIME = "time";
    static final String SAMPLE_RETRIEVE_SIZE = "size";
    static final String SAMPLE_RETRIEVE_POLICY = "policy";
    static final String SAMPLE_RETRIEVE_LOCAL_FILE = "local file";
    static final String SAMPLE_RETRIEVE_DESTINATION = "destination";
    static final String SAMPLE_RETRIEVE_REMOTE_FILE = "remote file";
    static final int SAMPLE_DELETE = 13;
    static final String SAMPLE_DELETE_FILE = "file";
    protected FTPClient ftp = null;
    protected boolean loggedIn = false;
    protected int lastReplyCode = -1;
    protected String lastReplyString = "";
    protected File currentDirectory = new File(".");

    protected static String replyString(FTP ftp) {
        String result = ftp.getReplyString();
        if (result == null) {
            result = String.valueOf(ftp.getReplyCode());
        } else if ((result = result.replace("\r\n", "|")).endsWith("|")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public SessionObject(Hashtable<String, String> params) {
    }

    private SessionObject(SessionObject so) {
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
        if (this.ftp != null && this.ftp.isConnected()) {
            try {
                this.ftp.disconnect();
            }
            catch (Exception ex) {
                throw new IsacRuntimeException("Warning: cannot disconnect FTP client.", ex);
            }
        }
        this.ftp = null;
        this.loggedIn = false;
        this.lastReplyCode = -1;
        this.lastReplyString = "";
        this.currentDirectory = new File(".");
    }

    public void reset() {
        this.ftp = null;
        this.loggedIn = false;
        this.lastReplyCode = -1;
        this.lastReplyString = "";
        this.currentDirectory = new File(".");
    }

    public ActionEvent doSample(int number, Map<String, String> params, ActionEvent report) {
        switch (number) {
            case 13: {
                if (this.ftp == null || !this.ftp.isConnected()) {
                    throw new IsacRuntimeException("FTP delete is not possible when not connected.");
                }
                this.sampleDelete(params, report);
                break;
            }
            case 12: {
                if (this.ftp == null || !this.ftp.isConnected()) {
                    throw new IsacRuntimeException("FTP retrieve is not possible when not connected.");
                }
                this.sampleRetrieve(params, report);
                break;
            }
            case 11: {
                if (this.ftp == null || !this.ftp.isConnected()) {
                    throw new IsacRuntimeException("FTP setFileType is not possible when not connected.");
                }
                this.sampleSetFileType(params, report);
                break;
            }
            case 10: {
                if (this.ftp == null || !this.ftp.isConnected()) {
                    throw new IsacRuntimeException("FTP noop is not possible when not connected.");
                }
                this.sampleNoOp(params, report);
                break;
            }
            case 8: {
                if (this.ftp == null || !this.ftp.isConnected()) {
                    throw new IsacRuntimeException("FTP logout is not possible when not connected.");
                }
                this.sampleLogout(params, report);
                break;
            }
            case 6: {
                if (this.ftp == null || !this.ftp.isConnected()) {
                    throw new IsacRuntimeException("FTP login is not possible when not connected.");
                }
                this.sampleLogin(params, report);
                break;
            }
            case 5: {
                if (this.ftp == null || !this.ftp.isConnected()) {
                    throw new IsacRuntimeException("FTP cd is not possible when not connected.");
                }
                this.sampleCd(params, report);
                break;
            }
            case 2: {
                if (this.ftp == null || !this.ftp.isConnected()) {
                    throw new IsacRuntimeException("FTP disconnect is not possible when not connected.");
                }
                this.sampleDisconnect(params, report);
                break;
            }
            case 1: {
                if (this.ftp == null || !this.ftp.isConnected()) {
                    throw new IsacRuntimeException("FTP store is not possible when not connected.");
                }
                this.sampleStore(params, report);
                break;
            }
            case 0: {
                if (this.ftp != null && this.ftp.isConnected()) {
                    throw new IsacRuntimeException("FTP connect is not possible when already connected.");
                }
                this.sampleConnect(params, report);
                break;
            }
            default: {
                throw new Error("Unable to find this sample in ~FtpInjector~ ISAC plugin: " + number);
            }
        }
        return report;
    }

    private void sampleDelete(Map<String, String> params, ActionEvent report) {
        String file = params.get("file");
        report.setDate(System.currentTimeMillis());
        try {
            this.ftp.deleteFile(file);
            report.duration = (int)(System.currentTimeMillis() - report.getDate());
            report.successful = true;
            this.lastReplyCode = this.ftp.getReplyCode();
            this.lastReplyString = SessionObject.replyString((FTP)this.ftp);
            report.result = this.lastReplyString;
        }
        catch (IOException ex) {
            report.successful = false;
            report.result = ex.toString();
            this.lastReplyCode = -1;
            this.lastReplyString = "";
        }
        report.comment = file;
        report.type = "FTP delete";
    }

    private void sampleConnect(Map<String, String> params, ActionEvent report) {
        String host = params.get(SAMPLE_CONNECT_HOST);
        String portStr = params.get(SAMPLE_CONNECT_PORT);
        String localAddr = params.get(SAMPLE_CONNECT_LOCALADDRESS);
        this.ftp = new FTPClient();
        report.type = "FTP connection";
        report.setDate(System.currentTimeMillis());
        try {
            if (localAddr == null || localAddr.length() == 0) {
                this.ftp.connect(host, Integer.parseInt(portStr));
            } else {
                this.ftp.connect(host, Integer.parseInt(portStr), InetAddress.getByAddress(localAddr, new byte[4]), 0);
            }
            report.duration = (int)(System.currentTimeMillis() - report.getDate());
            this.lastReplyCode = this.ftp.getReplyCode();
            this.lastReplyString = SessionObject.replyString((FTP)this.ftp);
            if (!FTPReply.isPositiveCompletion((int)this.lastReplyCode)) {
                this.ftp.disconnect();
            }
            report.successful = true;
            report.result = this.lastReplyString;
        }
        catch (IOException ex) {
            report.successful = false;
            report.result = ex.toString();
            this.lastReplyCode = -1;
            this.lastReplyString = "";
        }
        report.comment = params.get("comment");
    }

    private void sampleStore(Map<String, String> params, ActionEvent report) {
        BufferedInputStream input;
        if (ParameterParser.getRadioGroup((String)params.get(SAMPLE_STORE_CONTENT)).equals("generated")) {
            input = new BufferedInputStream(new Random().getInputStream());
        } else {
            String inputFileStr = params.get("file");
            File inputFile = new File(this.currentDirectory, inputFileStr);
            try {
                input = new BufferedInputStream(new FileInputStream(inputFile));
            }
            catch (IOException ex) {
                throw new IsacRuntimeException("FTP store can not find local file " + inputFile);
            }
        }
        LimitPolicy policy = LimitPolicy.NONE;
        String policyStr = ParameterParser.getRadioGroup((String)params.get(SAMPLE_STORE_LIMIT));
        if (policyStr.equals("size")) {
            policy = LimitPolicy.SIZE;
        } else if (policyStr.equals("time")) {
            policy = LimitPolicy.TIME;
        } else if (policyStr.equals("size or time")) {
            policy = LimitPolicy.ANY;
        } else if (policyStr.equals("size and time")) {
            policy = LimitPolicy.BOTH;
        }
        long maxBytes = -1L;
        if (policy != LimitPolicy.NONE && policy != LimitPolicy.TIME) {
            maxBytes = Long.parseLong(params.get("size"));
        }
        int timeOut = -1;
        if (policy != LimitPolicy.NONE && policy != LimitPolicy.SIZE) {
            timeOut = Integer.parseInt(params.get("time"));
        }
        String remoteFile = params.get("remote file");
        long startTime = System.currentTimeMillis();
        report.setDate(startTime);
        try {
            OutputStream output = this.ftp.storeFileStream(remoteFile);
            this.lastReplyCode = this.ftp.getReplyCode();
            if (output != null && (FTPReply.isPositiveIntermediate((int)this.lastReplyCode) || FTPReply.isPositivePreliminary((int)this.lastReplyCode))) {
                output = new BufferedOutputStream(output);
                long bytes = 0L;
                int val = ((InputStream)input).read();
                while (val != -1 && this.evalStoreLimitPolicy(bytes, policy, startTime, maxBytes, timeOut)) {
                    output.write(val);
                    ++bytes;
                    val = ((InputStream)input).read();
                }
                output.close();
                ((InputStream)input).close();
                if (this.ftp.completePendingCommand()) {
                    report.duration = (int)(System.currentTimeMillis() - startTime);
                    report.successful = true;
                    this.lastReplyCode = this.ftp.getReplyCode();
                    this.lastReplyString = SessionObject.replyString((FTP)this.ftp);
                    report.result = this.lastReplyString;
                    report.comment = bytes + " bytes sent";
                } else {
                    report.successful = false;
                    this.lastReplyCode = this.ftp.getReplyCode();
                    this.lastReplyString = SessionObject.replyString((FTP)this.ftp);
                    report.result = this.lastReplyString;
                    report.comment = remoteFile;
                }
            } else {
                report.successful = false;
                this.lastReplyCode = this.ftp.getReplyCode();
                this.lastReplyString = SessionObject.replyString((FTP)this.ftp);
                report.result = this.lastReplyString;
                report.comment = remoteFile;
                ((InputStream)input).close();
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (IOException ex) {
            report.successful = false;
            report.result = ex.toString();
            this.lastReplyCode = -1;
            this.lastReplyString = "";
        }
        report.type = "FTP store";
    }

    private void sampleDisconnect(Map<String, String> params, ActionEvent report) {
        report.setDate(System.currentTimeMillis());
        try {
            this.ftp.disconnect();
            report.duration = (int)(System.currentTimeMillis() - report.getDate());
            this.lastReplyCode = this.ftp.getReplyCode();
            this.lastReplyString = SessionObject.replyString((FTP)this.ftp);
            report.successful = true;
            report.result = this.lastReplyString;
            this.ftp = null;
        }
        catch (IOException ex) {
            report.result = ex.toString();
            report.successful = false;
            this.lastReplyCode = -1;
            this.lastReplyString = "";
        }
        report.type = "FTP disconnect";
        report.comment = params.get("comment");
    }

    private void sampleCd(Map<String, String> params, ActionEvent report) {
        String newDir = params.get("path");
        report.setDate(System.currentTimeMillis());
        try {
            this.ftp.changeWorkingDirectory(newDir);
            report.duration = (int)(System.currentTimeMillis() - report.getDate());
            this.lastReplyCode = this.ftp.getReplyCode();
            this.lastReplyString = SessionObject.replyString((FTP)this.ftp);
            report.successful = true;
            report.result = this.lastReplyString;
        }
        catch (IOException ex) {
            report.successful = false;
            report.result = ex.toString();
            this.lastReplyCode = -1;
            this.lastReplyString = "";
        }
        report.type = "FTP cd";
        report.comment = newDir;
    }

    private void sampleLogin(Map<String, String> params, ActionEvent report) {
        String login = params.get(SAMPLE_LOGIN_LOGIN);
        String passwd = params.get(SAMPLE_LOGIN_PASSWORD);
        report.setDate(System.currentTimeMillis());
        try {
            if (!this.loggedIn) {
                this.loggedIn = this.ftp.login(login, passwd);
            } else {
                this.ftp.login(login, passwd);
            }
            report.duration = (int)(System.currentTimeMillis() - report.getDate());
            this.lastReplyCode = this.ftp.getReplyCode();
            this.lastReplyString = SessionObject.replyString((FTP)this.ftp);
            report.result = this.lastReplyString;
            report.successful = true;
        }
        catch (IOException ex) {
            report.successful = false;
            report.result = ex.toString();
            this.lastReplyCode = -1;
            this.lastReplyString = "";
        }
        report.type = "FTP login";
        report.comment = params.get("comment");
    }

    private void sampleLogout(Map<String, String> params, ActionEvent report) {
        report.setDate(System.currentTimeMillis());
        try {
            if (this.loggedIn) {
                this.loggedIn = !this.ftp.logout();
            } else {
                this.ftp.logout();
            }
            report.duration = (int)(System.currentTimeMillis() - report.getDate());
            this.lastReplyCode = this.ftp.getReplyCode();
            this.lastReplyString = SessionObject.replyString((FTP)this.ftp);
            report.result = this.lastReplyString;
            report.successful = true;
        }
        catch (IOException ex) {
            report.successful = false;
            report.result = ex.toString();
            this.lastReplyCode = -1;
            this.lastReplyString = "";
        }
        report.type = "FTP logout";
        report.comment = params.get("comment");
    }

    private void sampleNoOp(Map<String, String> params, ActionEvent report) {
        report.setDate(System.currentTimeMillis());
        try {
            this.ftp.sendNoOp();
            report.duration = (int)(System.currentTimeMillis() - report.getDate());
            this.lastReplyCode = this.ftp.getReplyCode();
            this.lastReplyString = SessionObject.replyString((FTP)this.ftp);
            report.result = this.lastReplyString;
            report.successful = true;
        }
        catch (IOException ex) {
            report.successful = false;
            report.result = ex.toString();
            this.lastReplyCode = -1;
            this.lastReplyString = "";
        }
        report.type = "FTP noop";
        report.comment = params.get("comment");
    }

    private void sampleSetFileType(Map<String, String> params, ActionEvent report) {
        String fileTypeStr = ParameterParser.getCombo((String)params.get(SAMPLE_SETFILETYPE_TYPE));
        int fileType = -1;
        if (fileTypeStr.equals("ASCII")) {
            fileType = 0;
        } else if (fileTypeStr.equals("binary")) {
            fileType = 2;
        } else if (fileTypeStr.equals("EBCDIC")) {
            fileType = 1;
        } else if (fileTypeStr.equals("local")) {
            fileType = 3;
        }
        String textFormatStr = ParameterParser.getCombo((String)params.get(SAMPLE_SETFILETYPE_FORMAT));
        int textFormat = -1;
        if (textFormatStr.equals("non print")) {
            textFormat = 4;
        } else if (textFormatStr.equals("telnet")) {
            textFormat = 5;
        } else if (textFormatStr.equals("carriage control")) {
            textFormat = 6;
        }
        String byteSizeStr = params.get(SAMPLE_SETFILETYPE_BYTE_SIZE);
        int byteSize = -1;
        if (byteSizeStr.length() > 0) {
            byteSize = Integer.parseInt(byteSizeStr);
        }
        report.setDate(System.currentTimeMillis());
        try {
            switch (fileType) {
                case 2: {
                    this.ftp.setFileType(fileType);
                    break;
                }
                case 3: {
                    this.ftp.setFileType(fileType, byteSize);
                    break;
                }
                default: {
                    this.ftp.setFileType(fileType, textFormat);
                }
            }
            report.duration = (int)(System.currentTimeMillis() - report.getDate());
            this.lastReplyCode = this.ftp.getReplyCode();
            this.lastReplyString = SessionObject.replyString((FTP)this.ftp);
            report.type = "FTP type";
            report.result = this.lastReplyString;
            report.successful = true;
            report.comment = fileTypeStr + "/" + textFormatStr;
        }
        catch (IOException ex) {
            report.successful = false;
            report.result = ex.toString();
            this.lastReplyCode = -1;
            this.lastReplyString = "";
        }
    }

    private void sampleRetrieve(Map<String, String> params, ActionEvent report) {
        BufferedOutputStream output = null;
        String remoteFile = params.get("remote file");
        if (ParameterParser.getRadioGroup((String)params.get(SAMPLE_RETRIEVE_DESTINATION)).equals("write to local file")) {
            String localFileStr = params.get(SAMPLE_RETRIEVE_LOCAL_FILE);
            if (localFileStr.length() == 0) {
                localFileStr = remoteFile;
            }
            File localFile = new File(this.currentDirectory, localFileStr);
            try {
                output = new BufferedOutputStream(new FileOutputStream(localFile));
            }
            catch (IOException ex) {
                throw new IsacRuntimeException("FTP retrieve can not write to file " + localFile);
            }
        }
        LimitPolicy policy = LimitPolicy.NONE;
        String policyStr = ParameterParser.getRadioGroup((String)params.get(SAMPLE_RETRIEVE_POLICY));
        if (policyStr.equals("size")) {
            policy = LimitPolicy.SIZE;
        } else if (policyStr.equals("time")) {
            policy = LimitPolicy.TIME;
        } else if (policyStr.equals("size or time")) {
            policy = LimitPolicy.ANY;
        } else if (policyStr.equals("size and time")) {
            policy = LimitPolicy.BOTH;
        }
        long maxBytes = -1L;
        if (policy != LimitPolicy.NONE && policy != LimitPolicy.TIME) {
            maxBytes = Long.parseLong(params.get("size"));
        }
        int timeOut = -1;
        if (policy != LimitPolicy.NONE && policy != LimitPolicy.SIZE) {
            timeOut = Integer.parseInt(params.get("time"));
        }
        long startTime = System.currentTimeMillis();
        report.setDate(startTime);
        try {
            InputStream input = this.ftp.retrieveFileStream(remoteFile);
            if (input == null) {
                report.successful = false;
                report.result = SessionObject.replyString((FTP)this.ftp);
                report.comment = remoteFile;
            } else {
                BufferedInputStream bufInput = new BufferedInputStream(input);
                long bytes = 0L;
                int val = bufInput.read();
                while (val != -1 && this.evalStoreLimitPolicy(bytes, policy, startTime, maxBytes, timeOut)) {
                    if (output != null) {
                        ((OutputStream)output).write(val);
                    }
                    ++bytes;
                    val = bufInput.read();
                }
                bufInput.close();
                this.ftp.completePendingCommand();
                report.duration = (int)(System.currentTimeMillis() - startTime);
                report.successful = true;
                this.lastReplyCode = this.ftp.getReplyCode();
                this.lastReplyString = SessionObject.replyString((FTP)this.ftp);
                report.result = this.lastReplyString;
                report.comment = bytes + " bytes received";
            }
            if (output != null) {
                ((OutputStream)output).close();
            }
        }
        catch (IOException ex) {
            report.successful = false;
            report.result = ex.toString();
            this.lastReplyCode = -1;
            this.lastReplyString = "";
        }
        report.type = "FTP retrieve";
    }

    private boolean evalStoreLimitPolicy(long bytes, LimitPolicy policy, long startTime, long maxBytes, int timeOut) {
        switch (policy) {
            case SIZE: {
                return bytes < maxBytes;
            }
            case TIME: {
                return System.currentTimeMillis() < startTime + (long)timeOut;
            }
            case ANY: {
                return bytes < maxBytes && System.currentTimeMillis() < startTime + (long)timeOut;
            }
            case BOTH: {
                return bytes < maxBytes || System.currentTimeMillis() < startTime + (long)timeOut;
            }
        }
        return true;
    }

    public boolean doTest(int number, Map<String, String> params) {
        switch (number) {
            case 9: {
                boolean equals;
                List options = ParameterParser.getCheckBox((String)params.get("options"));
                try {
                    equals = Integer.parseInt(params.get(TEST_REPLYCODEIS_CODE)) == this.lastReplyCode;
                }
                catch (NumberFormatException ex) {
                    equals = String.valueOf(this.lastReplyCode).startsWith(params.get(TEST_REPLYCODEIS_CODE).substring(0, 1));
                }
                return options.contains("not") ? !equals : equals;
            }
            case 7: {
                List options = ParameterParser.getCheckBox((String)params.get("options"));
                return options.contains("not") ? !this.loggedIn : this.loggedIn;
            }
            case 3: {
                List options = ParameterParser.getCheckBox((String)params.get("options"));
                return options.contains("not") ? this.ftp == null : this.ftp != null;
            }
        }
        throw new Error("Unable to find this test in ~FtpInjector~ ISAC plugin: " + number);
    }

    public void doControl(int number, Map<String, String> params) {
        switch (number) {
            case 4: {
                String pathStr = params.get("path");
                File path = new File(pathStr);
                try {
                    this.currentDirectory = path.isAbsolute() ? path : new File(this.currentDirectory, pathStr);
                    this.currentDirectory = this.currentDirectory.getCanonicalFile();
                    break;
                }
                catch (IOException ex) {
                    throw new IsacRuntimeException("Problem with path in FTP lcd: " + path, (Exception)ex);
                }
            }
            default: {
                throw new Error("Unable to find this control in ~FtpInjector~ ISAC plugin: " + number);
            }
        }
    }

    public String doGet(String var) {
        if (var.equalsIgnoreCase("reply code")) {
            return String.valueOf(this.lastReplyCode);
        }
        if (var.equalsIgnoreCase("reply string")) {
            return this.lastReplyString;
        }
        throw new IsacRuntimeException("Unknown parameter value in ~FtpInjector~ ISAC plugin: " + var);
    }

    protected static enum LimitPolicy {
        NONE,
        SIZE,
        TIME,
        ANY,
        BOTH;

    }
}

