/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.isac.plugin.imapinjector;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.BodyTerm;
import javax.mail.search.SearchTerm;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.SampleAction;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.storage.api.ActionEvent;

public class SessionObject
implements SessionObjectAction,
SampleAction {
    static final int SAMPLE_CONNECT = 0;
    static final String SAMPLE_CONNECT_PORT = "port";
    static final String SAMPLE_CONNECT_HOSTNAME = "hostname";
    static final String SAMPLE_CONNECT_PASSWORD = "password";
    static final String SAMPLE_CONNECT_USERNAME = "username";
    static final int SAMPLE_LOGOFF = 1;
    static final int SAMPLE_SELECT = 2;
    static final String SAMPLE_SELECT_NAME = "name";
    static final int SAMPLE_SEARCH = 3;
    static final String SAMPLE_SEARCH_CRITERIA = "criteria";
    static final int SAMPLE_FETCH = 4;
    static final String SAMPLE_FETCH_MESSAGEID = "messageID";
    static final int SAMPLE_MOVE = 5;
    static final String SAMPLE_MOVE_MAILBOX = "mailbox";
    static final String SAMPLE_MOVE_MESSAGEID = "messageID";
    static final String PLUGIN_PORT = "port";
    static final String PLUGIN_HOSTNAME = "hostname";
    private Properties props;
    private Session imapSession;
    private Store imapStore;
    private Folder imapFolder;

    public SessionObject(Hashtable params) {
        this.props = new Properties();
        String value = (String)params.get("hostname");
        if (value != null && value.length() > 0) {
            try {
                this.props.put("mail.imaps.host", value);
            }
            catch (Exception ex) {
                throw new IsacRuntimeException("Specified hostname is invalid:" + value, ex);
            }
        } else {
            throw new IsacRuntimeException("Hostname cannot be empty.");
        }
        value = (String)params.get("port");
        if (value != null && value.length() > 0) {
            try {
                this.props.put("mail.imaps.port", value);
            }
            catch (Exception ex) {
                throw new IsacRuntimeException("Specified port is invalid:" + value, ex);
            }
        } else {
            throw new IsacRuntimeException("Port cannot be empty.");
        }
        this.props.setProperty("mail.store.protocol", "imaps");
        this.imapSession = Session.getInstance((Properties)this.props);
    }

    private SessionObject(SessionObject so) {
        this.props = so.props;
        this.imapSession = so.imapSession;
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
    }

    public void reset() {
    }

    public ActionEvent doSample(int number, Map params, ActionEvent report) {
        switch (number) {
            case 5: {
                return this.doMove(number, params, report);
            }
            case 4: {
                return this.doFetch(number, params, report);
            }
            case 3: {
                return this.doSearch(number, params, report);
            }
            case 2: {
                return this.doSelect(number, params, report);
            }
            case 1: {
                return this.doLogoff(number, params, report);
            }
            case 0: {
                return this.doConnect(number, params, report);
            }
        }
        throw new Error("Unable to find this sample in ~ImapInjector~ ISAC plugin: " + number);
    }

    private ActionEvent doConnect(int number, Map params, ActionEvent report) {
        long timeStart = 0L;
        boolean overrideHost = false;
        boolean overridePort = false;
        String user = (String)params.get(SAMPLE_CONNECT_USERNAME);
        String pass = (String)params.get(SAMPLE_CONNECT_PASSWORD);
        String host = (String)params.get("hostname");
        String port = (String)params.get("port");
        report.type = "CONNECT";
        report.setDate(System.currentTimeMillis());
        report.result = null;
        if (host != null && host.length() > 0) {
            if (this.imapStore != null && this.imapStore.isConnected()) {
                try {
                    this.imapStore.close();
                }
                catch (Exception e) {
                    System.err.println("Problem closing store while setting host=" + host + ".");
                    e.printStackTrace();
                }
            }
            try {
                this.props.setProperty("mail.imaps.host", host);
                overrideHost = true;
            }
            catch (Exception ex) {
                throw new IsacRuntimeException("Specified hostname is invalid:" + host, ex);
            }
        }
        if (port != null && port.length() > 0) {
            if (this.imapStore != null && this.imapStore.isConnected()) {
                try {
                    this.imapStore.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.props.put("mail.imaps.port", port);
                overridePort = true;
            }
            catch (Exception ex) {
                throw new IsacRuntimeException("Specified hostname is invalid:" + host, ex);
            }
        }
        if (overrideHost) {
            while (this.imapSession.getProperty("mail.imaps.host") != host) {
                this.imapSession = Session.getInstance((Properties)this.props);
            }
        }
        if (overridePort) {
            while (this.imapSession.getProperty("mail.imaps.port") != port) {
                this.imapSession = Session.getInstance((Properties)this.props);
            }
        }
        report.comment = "Connecting to " + this.imapSession.getProperty("mail.imaps.host") + ":" + this.imapSession.getProperty("mail.imaps.port") + "as" + user + "/" + pass;
        try {
            this.imapStore = this.imapSession.getStore();
            timeStart = System.currentTimeMillis();
            this.imapStore.connect(user, pass);
        }
        catch (NoSuchProviderException e) {
            System.err.println("Invalid provider" + this.imapSession.getProperty("mail.store.protocol"));
            report.result = e.toString();
        }
        catch (AuthenticationFailedException afe) {
            System.err.println("Unable to log on with user=" + user + ", password=" + pass);
            report.result = afe.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            report.result = e.toString();
        }
        if (report.result == null) {
            report.result = "OK";
            report.successful = true;
        } else {
            report.comment = "Connection failed";
            report.successful = false;
        }
        report.duration = timeStart > 0L ? (int)(System.currentTimeMillis() - timeStart) : 0;
        return report;
    }

    private ActionEvent doSelect(int number, Map params, ActionEvent report) {
        long timeStart = 0L;
        String folderName = (String)params.get(SAMPLE_SELECT_NAME);
        report.type = "SELECT";
        report.setDate(System.currentTimeMillis());
        report.result = null;
        report.comment = "Selected " + folderName;
        if (!this.imapStore.isConnected()) {
            report.duration = 0;
            report.successful = false;
            report.result = "Aborted";
            report.comment = "No connection";
            return report;
        }
        try {
            timeStart = System.currentTimeMillis();
            this.imapFolder = this.imapStore.getFolder(folderName);
            this.imapFolder.open(2);
        }
        catch (MessagingException me) {
            report.result = me.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            report.result = e.toString();
        }
        if (report.result == null) {
            report.result = "OK";
            report.successful = true;
        } else {
            report.comment = "Unable to get folder" + folderName;
            report.successful = false;
        }
        report.duration = timeStart > 0L ? (int)(System.currentTimeMillis() - timeStart) : 0;
        return report;
    }

    private ActionEvent doFetch(int number, Map params, ActionEvent report) {
        long timeStart = 0L;
        int messageID = Integer.valueOf((String)params.get("messageID"));
        Message imapMessage = null;
        report.type = "FETCH";
        report.setDate(System.currentTimeMillis());
        report.result = null;
        report.comment = "Retrieved message# " + messageID;
        if (!this.imapStore.isConnected()) {
            report.duration = 0;
            report.successful = false;
            report.result = "Aborted";
            report.comment = "No connection";
            return report;
        }
        try {
            timeStart = System.currentTimeMillis();
            imapMessage = this.imapFolder.getMessage(messageID);
        }
        catch (MessagingException me) {
            report.result = me.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            report.result = e.toString();
        }
        if (report.result == null) {
            report.result = "OK";
            report.successful = true;
        } else {
            report.comment = "Unable to get message" + messageID;
            report.successful = false;
        }
        report.duration = timeStart > 0L ? (int)(System.currentTimeMillis() - timeStart) : 0;
        if (imapMessage != null) {
            imapMessage = null;
        }
        return report;
    }

    private ActionEvent doSearch(int number, Map params, ActionEvent report) {
        long timeStart = 0L;
        BodyTerm imapSearchTerm = new BodyTerm((String)params.get(SAMPLE_SEARCH_CRITERIA));
        Message[] imapMessage = null;
        report.type = "SEARCH";
        report.setDate(System.currentTimeMillis());
        report.result = null;
        if (!this.imapStore.isConnected()) {
            report.duration = 0;
            report.successful = false;
            report.result = "Aborted";
            report.comment = "No connection";
            return report;
        }
        try {
            timeStart = System.currentTimeMillis();
            imapMessage = this.imapFolder.search((SearchTerm)imapSearchTerm);
            report.comment = "Found " + imapMessage.length + " messages";
            imapMessage = null;
        }
        catch (MessagingException me) {
            report.result = me.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            report.result = e.toString();
        }
        if (report.result == null) {
            report.result = "OK";
            report.successful = true;
        } else {
            report.comment = "Search for " + (String)params.get(SAMPLE_SEARCH_CRITERIA) + "failed.";
            report.successful = false;
        }
        report.duration = timeStart > 0L ? (int)(System.currentTimeMillis() - timeStart) : 0;
        return report;
    }

    private ActionEvent doLogoff(int number, Map params, ActionEvent report) {
        long timeStart = 0L;
        report.type = "LOGOFF";
        report.setDate(System.currentTimeMillis());
        report.result = null;
        report.comment = "Logged off";
        if (!this.imapStore.isConnected()) {
            report.duration = 0;
            report.successful = false;
            report.result = "Aborted";
            report.comment = "No connection";
            return report;
        }
        try {
            timeStart = System.currentTimeMillis();
            this.imapFolder.close(false);
            this.imapStore.close();
        }
        catch (MessagingException me) {
            report.result = me.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            report.result = e.toString();
        }
        if (report.result == null) {
            report.result = "OK";
            report.successful = true;
        } else {
            report.comment = "Problem closing the folder, or the store.";
            report.successful = false;
        }
        report.duration = timeStart > 0L ? (int)(System.currentTimeMillis() - timeStart) : 0;
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionEvent doMove(int number, Map params, ActionEvent report) {
        long timeStart = 0L;
        long timeStop = 0L;
        int messageID = Integer.valueOf((String)params.get("messageID"));
        Message imapMessage = null;
        Folder targetFolder = null;
        String folderName = (String)params.get(SAMPLE_MOVE_MAILBOX);
        report.type = "MOVE";
        report.setDate(System.currentTimeMillis());
        report.result = null;
        report.comment = "Moved message " + messageID + ".";
        if (!this.imapStore.isConnected()) {
            report.duration = 0;
            report.successful = false;
            report.result = "Aborted";
            report.comment = "No connection";
            return report;
        }
        try {
            timeStart = System.currentTimeMillis();
            targetFolder = this.imapStore.getFolder(folderName);
            targetFolder.open(2);
            imapMessage = this.imapFolder.getMessage(messageID);
            Message[] ImapMessages = this.imapFolder.getMessages(messageID, messageID);
            this.imapFolder.copyMessages(ImapMessages, targetFolder);
            imapMessage.setFlag(Flags.Flag.DELETED, true);
            timeStop = System.currentTimeMillis();
        }
        catch (MessagingException me) {
            report.result = me.toString();
        }
        catch (Exception e) {
            report.result = e.toString();
            e.printStackTrace();
        }
        finally {
            if (report.result != null) {
                report.comment = "Failed to copy message " + messageID + " to folder " + folderName;
            }
            try {
                imapMessage.setFlag(Flags.Flag.DELETED, false);
                if (!targetFolder.isOpen()) {
                    targetFolder = this.imapStore.getFolder(folderName);
                    targetFolder.open(2);
                }
                imapMessage = targetFolder.getMessage(messageID);
                imapMessage.setFlag(Flags.Flag.DELETED, true);
                targetFolder.close(true);
                imapMessage = null;
            }
            catch (Exception e) {
                report.result = e.toString();
                report.comment = report.comment + " A problem occured during clean up.";
            }
        }
        if (report.result == null) {
            report.result = "OK";
            report.successful = true;
        } else {
            report.successful = false;
        }
        report.duration = timeStart > 0L && timeStop > 0L ? (int)(timeStop - timeStart) : 0;
        return report;
    }
}

