/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.jdbcinjector;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SampleAction;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.storage.api.ActionEvent;
import org.ow2.clif.util.ClifClassLoader;
import org.ow2.isac.plugin.jdbcinjector.tools.IsolationLevel;
import org.ow2.isac.plugin.jdbcinjector.tools.JdbcTypes;
import org.ow2.isac.plugin.jdbcinjector.tools.PreparedStatementDefinition;
import org.ow2.isac.plugin.jdbcinjector.tools.ResultSetAtomizer;
import org.ow2.isac.plugin.jdbcinjector.tools.RsInteger;
import org.ow2.isac.plugin.jdbcinjector.tools.RsVarchar;
import org.ow2.isac.plugin.jdbcinjector.tools.ServerTypes;

public class SessionObject
implements SessionObjectAction,
ControlAction,
SampleAction,
DataProvider {
    static final int SAMPLE_EXECUTEQUERY = 7;
    static final String SAMPLE_EXECUTEQUERY_RESULTSETTYPES = "resultSetTypes";
    static final String SAMPLE_EXECUTEQUERY_USERESULTSET = "useResultSet";
    static final String SAMPLE_EXECUTEQUERY_SQLSTMT = "sqlStmt";
    static final int SAMPLE_EXECUTEUPDATE = 8;
    static final String SAMPLE_EXECUTEUPDATE_SQLSTMT = "sqlStmt";
    static final int SAMPLE_PREPARESTATEMENT = 9;
    static final String SAMPLE_PREPARESTATEMENT_RESULTSETTYPES = "resultSetTypes";
    static final String SAMPLE_PREPARESTATEMENT_USERESULTSET = "useResultSet";
    static final String SAMPLE_PREPARESTATEMENT_PLACEHOLDERS = "placeHolders";
    static final String SAMPLE_PREPARESTATEMENT_SQLSTMT = "sqlStmt";
    static final String SAMPLE_PREPARESTATEMENT_PREPAREDSTMTNAME = "preparedStmtName";
    static final int SAMPLE_EXECUTE = 10;
    static final String SAMPLE_EXECUTE_PLACEHOLDERSVALUES = "placeHoldersValues";
    static final String SAMPLE_EXECUTE_EXECUTEMETHOD = "executeMethod";
    static final String SAMPLE_EXECUTE_OBJECT = "object";
    static final String SAMPLE_EXECUTE_PREPAREDSTMTNAME = "preparedStmtName";
    static final int SAMPLE_CONNECT = 11;
    static final int SAMPLE_COMMIT = 12;
    static final int SAMPLE_ROLLBACK = 13;
    static final int CONTROL_SET_AUTOCOMMIT = 1;
    static final String CONTROL_SET_AUTOCOMMIT_AUTOCOMMIT = "autocommit";
    static final int CONTROL_SET_ISOLATIN_LEVEL = 2;
    static final String CONTROL_SET_ISOLATIN_LEVEL_ISOLATIONLEVEL = "isolationLevel";
    static final String PLUGIN_BASE_NAME = "base_name";
    static final String PLUGIN_PASSWD = "passwd";
    static final String PLUGIN_LOGIN = "login";
    static final String PLUGIN_DIRECTJDBC = "directJdbc";
    static final String PLUGIN_PORT = "port";
    static final String PLUGIN_HOST = "host";
    static final String PLUGIN_SERVERTYPE = "serverType";
    private static final Pattern pattern = Pattern.compile("\\[(\\d+)\\]");
    private String login = null;
    private String passwd = null;
    private int serverType = -1;
    private String url = null;
    private String baseUrl = null;
    private String driver = null;
    private String baseName = null;
    private String host = null;
    private String port = null;
    private Connection connection = null;
    private Map preparedStmtMap = null;
    private String[] resultSet = new String[8];

    public SessionObject(Hashtable params) {
        List directDriver = ParameterParser.getCheckBox((String)((String)params.get(PLUGIN_DIRECTJDBC)));
        this.serverType = ServerTypes.toServerMap.get(ParameterParser.getCombo((String)((String)params.get(PLUGIN_SERVERTYPE))));
        this.url = (String)ServerTypes.toUrlMap.get(this.serverType);
        this.driver = (String)ServerTypes.toDriverMap.get(this.serverType);
        this.baseName = (String)params.get(PLUGIN_BASE_NAME);
        this.host = (String)params.get(PLUGIN_HOST);
        this.port = (String)params.get(PLUGIN_PORT);
        this.login = (String)params.get(PLUGIN_LOGIN);
        this.passwd = (String)params.get(PLUGIN_PASSWD);
        switch (this.serverType) {
            case 2: {
                this.baseUrl = this.url + "//" + this.host + ":" + this.port;
                break;
            }
            case 3: {
                if (directDriver.contains("enabled")) {
                    this.baseUrl = this.url + "direct:dsn=" + this.baseName;
                    break;
                }
                this.baseUrl = this.url + "client:dsn=" + this.baseName;
                break;
            }
            default: {
                this.baseUrl = this.url + "//" + this.host + ":" + this.port + "/" + this.baseName;
            }
        }
    }

    private SessionObject(SessionObject so) {
        try {
            this.serverType = so.serverType;
            this.driver = so.driver;
            this.url = so.url;
            this.baseName = so.baseName;
            this.host = so.host;
            this.port = so.port;
            this.baseUrl = so.baseUrl;
            this.login = so.login;
            this.passwd = so.passwd;
            this.preparedStmtMap = new HashMap(8);
            this.initJDBCConnection();
        }
        catch (Exception e) {
            throw new IsacRuntimeException("error in copy constructor for " + this.baseUrl, e);
        }
    }

    private void initJDBCConnection() {
        try {
            ClifClassLoader.getClassLoader().loadClass(this.driver);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IsacRuntimeException(this.driver + " not found", (Exception)cnfe);
        }
        catch (Exception e) {
            throw new IsacRuntimeException("Can't instantiate JDBC driver", e);
        }
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)ClifClassLoader.getClassLoader());
            this.connection = DriverManager.getConnection(this.baseUrl, this.login, this.passwd);
            this.connection.setAutoCommit(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IsacRuntimeException("Could not connect to " + this.baseUrl, e);
        }
    }

    private void closeConnection() {
        try {
            this.connection.close();
        }
        catch (SQLException se) {
            throw new IsacRuntimeException("Unable to close the jdbc connection", (Exception)se);
        }
    }

    private void addPreparedStmt(String name, PreparedStatementDefinition pstmt) {
        this.preparedStmtMap.put(name, pstmt);
    }

    private PreparedStatementDefinition getPreparedStatement(String name) {
        return (PreparedStatementDefinition)this.preparedStmtMap.get(name);
    }

    private ActionEvent ExecuteQuery(Map params, ActionEvent report) {
        String query = (String)params.get("sqlStmt");
        ArrayList<ResultSetAtomizer> resultSetAtomizers = new ArrayList<ResultSetAtomizer>();
        long t1 = 0L;
        long t2 = 0L;
        long duration = 0L;
        ResultSet rs = null;
        Statement stmt = null;
        report.type = "executeQuery";
        report.setDate(System.currentTimeMillis());
        try {
            t1 = System.nanoTime();
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(query);
            t2 = System.nanoTime();
            duration = (t2 - t1) / 1000L;
            report.duration = (int)duration;
            report.successful = true;
            report.comment = "\"" + query + "\"";
            List parse_result = ParameterParser.getCheckBox((String)((String)params.get("useResultSet")));
            if (parse_result.contains("enabled")) {
                Iterator types = ParameterParser.getNField((String)((String)params.get("resultSetTypes"))).iterator();
                int jdbcType = 0;
                while (types.hasNext()) {
                    String type = (String)types.next();
                    jdbcType = (Integer)JdbcTypes.toJdbcMap.get(type);
                    switch (jdbcType) {
                        case 4: {
                            resultSetAtomizers.add(new RsInteger());
                            break;
                        }
                        case 12: {
                            resultSetAtomizers.add(new RsVarchar());
                        }
                    }
                }
                rs.next();
                int i = 0;
                Iterator it = resultSetAtomizers.iterator();
                while (it.hasNext()) {
                    this.resultSet[i] = ((ResultSetAtomizer)it.next()).get(rs, i + 1);
                    ++i;
                }
                report.result = this.resultSet[0];
                rs.close();
            }
            stmt.close();
        }
        catch (Exception se) {
            report.comment = "Unable to executeQuery " + se;
            report.successful = false;
            System.err.println(se);
        }
        return report;
    }

    private ActionEvent ExecuteUpdate(Map params, ActionEvent report) {
        String query = (String)params.get("sqlStmt");
        long t1 = 0L;
        long t2 = 0L;
        long duration = 0L;
        int s = -1;
        report.type = "executeUpdate";
        report.comment = "\"" + query + "\"";
        try {
            report.setDate(System.currentTimeMillis());
            t1 = System.nanoTime();
            Statement stmt = this.connection.createStatement();
            s = stmt.executeUpdate(query);
            t2 = System.nanoTime();
            stmt.close();
            duration = (t2 - t1) / 1000L;
            report.duration = (int)duration;
            report.successful = true;
            report.result = Integer.valueOf(s);
        }
        catch (Exception se) {
            report.comment = "Unable to executeUpdate " + se;
            report.successful = false;
        }
        return report;
    }

    private ActionEvent PrepareStatement(Map params, ActionEvent report) {
        String name = (String)params.get("preparedStmtName");
        String statement = (String)params.get("sqlStmt");
        List arguments = ParameterParser.getNField((String)((String)params.get(SAMPLE_PREPARESTATEMENT_PLACEHOLDERS)));
        List parse_result = ParameterParser.getCheckBox((String)((String)params.get("useResultSet")));
        List types = ParameterParser.getNField((String)((String)params.get("resultSetTypes")));
        report.type = "prepareStatement";
        long t1 = 0L;
        long t2 = 0L;
        long duration = 0L;
        PreparedStatementDefinition psd = new PreparedStatementDefinition(name);
        psd.setStatement(statement);
        Iterator argumentIter = arguments.iterator();
        while (argumentIter.hasNext()) {
            psd.addParam((String)argumentIter.next());
        }
        Iterator typeIter = types.iterator();
        while (typeIter.hasNext()) {
            psd.addResult((String)typeIter.next());
        }
        if (parse_result.contains("enabled")) {
            psd.parseResultSetOn();
        }
        try {
            report.setDate(System.currentTimeMillis());
            t1 = System.nanoTime();
            PreparedStatement ps = this.connection.prepareStatement(statement);
            t2 = System.nanoTime();
            duration = (t2 - t1) / 1000L;
            report.duration = (int)duration;
            report.successful = true;
            report.comment = name;
            report.result = "\"" + psd.toString() + "\"";
            psd.setPreparedStatement(ps);
            this.addPreparedStmt(name, psd);
        }
        catch (Exception se) {
            report.comment = psd.toString() + "/" + se;
            report.successful = false;
        }
        return report;
    }

    private ActionEvent Exec(Map params, ActionEvent report) {
        String name = (String)params.get("preparedStmtName");
        String executionType = ParameterParser.getCombo((String)((String)params.get(SAMPLE_EXECUTE_EXECUTEMETHOD)));
        List values = ParameterParser.getNField((String)((String)params.get(SAMPLE_EXECUTE_PLACEHOLDERSVALUES)));
        PreparedStatementDefinition psd = null;
        PreparedStatement ps = null;
        report.type = "ExecPrepStmt";
        long t1 = 0L;
        long t2 = 0L;
        long duration = 0L;
        psd = this.getPreparedStatement(name);
        if (psd == null) {
            report.setDate(System.currentTimeMillis());
            report.duration = 0;
            report.successful = false;
            report.comment = "no prepared statement definition found: " + name;
            return report;
        }
        ps = psd.getPreparedStatement();
        if (ps == null) {
            report.setDate(System.currentTimeMillis());
            report.duration = 0;
            report.successful = false;
            report.comment = "no prepared statement found: " + name;
            return report;
        }
        int capacity = psd.getCapacity();
        Iterator valueIter = values.iterator();
        try {
            for (int i = 0; i < capacity; ++i) {
                psd.setPlaceHolder(i, (String)valueIter.next());
            }
        }
        catch (Exception se) {
            report.setDate(System.currentTimeMillis());
            report.duration = 0;
            report.successful = false;
            report.comment = "Unable to set query object " + se;
            return report;
        }
        ResultSet rs = null;
        try {
            if (executionType.compareTo("Execute") == 0) {
                report.setDate(System.currentTimeMillis());
                t1 = System.nanoTime();
                ps.execute();
                t2 = System.nanoTime();
                duration = (t2 - t1) / 1000L;
                report.duration = (int)duration;
                report.comment = name;
            } else if (executionType.compareTo("ExecuteQuery") == 0) {
                report.setDate(System.currentTimeMillis());
                t1 = System.nanoTime();
                rs = ps.executeQuery();
                t2 = System.nanoTime();
                duration = (t2 - t1) / 1000L;
                report.duration = (int)duration;
                report.comment = name;
            } else if (executionType.compareTo("ExecuteUpdate") == 0) {
                report.setDate(System.currentTimeMillis());
                t1 = System.nanoTime();
                ps.executeUpdate();
                t2 = System.nanoTime();
                duration = (t2 - t1) / 1000L;
                report.duration = (int)duration;
                report.comment = name;
            }
            report.successful = true;
            if (psd.getParseResultSetState()) {
                rs.next();
                ArrayList resultTypes = psd.getResultTypes();
                int i = 0;
                Iterator it = resultTypes.iterator();
                while (it.hasNext()) {
                    this.resultSet[i] = ((ResultSetAtomizer)it.next()).get(rs, i + 1);
                    ++i;
                }
            }
        }
        catch (SQLException se) {
            report.successful = false;
            report.comment = executionType + " " + se;
        }
        return report;
    }

    private ActionEvent Commit(ActionEvent report) {
        report.type = "commit";
        long t1 = 0L;
        long t2 = 0L;
        long duration = 0L;
        try {
            report.setDate(System.currentTimeMillis());
            t1 = System.nanoTime();
            this.connection.commit();
            t2 = System.nanoTime();
            duration = (t2 - t1) / 1000L;
            report.duration = (int)duration;
        }
        catch (SQLException sqle) {
            report.successful = false;
            report.duration = 0;
        }
        report.successful = true;
        return report;
    }

    private ActionEvent Connect(ActionEvent report) {
        report.type = "connect";
        report.setDate(System.currentTimeMillis());
        long start_ns = System.nanoTime();
        try {
            this.initJDBCConnection();
            report.duration = (int)((System.nanoTime() - start_ns) / 1000L);
            report.successful = true;
        }
        catch (Exception e) {
            report.successful = false;
        }
        return report;
    }

    private ActionEvent Rollback(ActionEvent report) {
        report.type = "rollback";
        long t1 = 0L;
        long t2 = 0L;
        long duration = 0L;
        try {
            report.setDate(System.currentTimeMillis());
            t1 = System.nanoTime();
            this.connection.rollback();
            t2 = System.nanoTime();
            duration = (t2 - t1) / 1000L;
            report.duration = (int)duration;
        }
        catch (SQLException sqle) {
            report.successful = false;
            report.duration = 0;
        }
        report.successful = true;
        return report;
    }

    private void SetAutoCommit(boolean value) {
        try {
            this.connection.setAutoCommit(value);
        }
        catch (SQLException sqle) {
            throw new IsacRuntimeException("unable to setAutoCommit", (Exception)sqle);
        }
    }

    private void SetTxIsolation(int value) {
        try {
            this.connection.setTransactionIsolation(value);
        }
        catch (SQLException sqle) {
            System.err.println(sqle.toString());
            throw new IsacRuntimeException("unable to setTxIsolation", (Exception)sqle);
        }
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
        this.closeConnection();
    }

    public void reset() {
    }

    public void doControl(int number, Map params) {
        try {
            switch (number) {
                case 2: {
                    String requiredLevel = ParameterParser.getCombo((String)((String)params.get(CONTROL_SET_ISOLATIN_LEVEL_ISOLATIONLEVEL)));
                    int levelValue = (Integer)IsolationLevel.toJdbcMap.get(requiredLevel);
                    this.SetTxIsolation(levelValue);
                    return;
                }
                case 1: {
                    String requiredAutocommit = ParameterParser.getRadioGroup((String)((String)params.get(CONTROL_SET_AUTOCOMMIT_AUTOCOMMIT)));
                    if ("on".compareTo(requiredAutocommit) == 0) {
                        this.SetAutoCommit(true);
                    } else {
                        this.SetAutoCommit(false);
                    }
                    return;
                }
            }
            throw new Error("Unable to find this control in ~Jdbc_1.0~ ISAC plugin: " + number);
        }
        catch (Exception e) {
            throw new IsacRuntimeException(e + "thrown while processing control in ~Jdbc_1.0~ ISAC plugin: " + number, e);
        }
    }

    public ActionEvent doSample(int number, Map params, ActionEvent report) {
        switch (number) {
            case 13: {
                return this.Rollback(report);
            }
            case 12: {
                return this.Commit(report);
            }
            case 11: {
                return this.Connect(report);
            }
            case 10: {
                return this.Exec(params, report);
            }
            case 9: {
                return this.PrepareStatement(params, report);
            }
            case 8: {
                return this.ExecuteUpdate(params, report);
            }
            case 7: {
                return this.ExecuteQuery(params, report);
            }
        }
        throw new Error("Unable to find this sample in ~Jdbc_1.0~ ISAC plugin: " + number);
    }

    public String doGet(String var) {
        try {
            int i;
            Matcher m = pattern.matcher(var);
            return m.matches() && (i = Integer.parseInt(m.group(1))) < this.resultSet.length ? this.resultSet[i] : null;
        }
        catch (Exception e) {
            throw new IsacRuntimeException("Unknown parameter value in ~Plugin Name~ ISAC plugin: " + var, e);
        }
    }
}

