/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.jdbcinjector.tools;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import org.ow2.isac.plugin.jdbcinjector.tools.JdbcTypes;
import org.ow2.isac.plugin.jdbcinjector.tools.PhInteger;
import org.ow2.isac.plugin.jdbcinjector.tools.PhVarchar;
import org.ow2.isac.plugin.jdbcinjector.tools.PlaceHolder;
import org.ow2.isac.plugin.jdbcinjector.tools.RsInteger;
import org.ow2.isac.plugin.jdbcinjector.tools.RsVarchar;

public class PreparedStatementDefinition {
    String _name = null;
    String _stmt = null;
    boolean parseResultSet = false;
    PreparedStatement _ps = null;
    ArrayList _paramList = new ArrayList();
    ArrayList _resultTypes = new ArrayList();
    int capacity = 0;
    int resultset_capacity = 0;

    public PreparedStatementDefinition(String name) {
        this._name = name;
    }

    public void setPreparedStatement(PreparedStatement ps) {
        this._ps = ps;
    }

    public PreparedStatement getPreparedStatement() {
        return this._ps;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setStatement(String stmt) {
        this._stmt = stmt;
    }

    public void addParam(String type) {
        int t = (Integer)JdbcTypes.toJdbcMap.get(type);
        switch (t) {
            case 4: {
                this._paramList.add(new PhInteger());
                break;
            }
            case 12: {
                this._paramList.add(new PhVarchar());
            }
        }
    }

    public void addResult(String type) {
        int t = (Integer)JdbcTypes.toJdbcMap.get(type);
        switch (t) {
            case 4: {
                this._resultTypes.add(new RsInteger());
                break;
            }
            case 12: {
                this._resultTypes.add(new RsVarchar());
            }
        }
    }

    public void setPlaceHolder(int i, String value) {
        this.getParam(i).set(this._ps, i + 1, value);
    }

    public int getResultSetCapacity() {
        return this._resultTypes.size();
    }

    public ArrayList getResultTypes() {
        return this._resultTypes;
    }

    public PlaceHolder getParam(int index) {
        return (PlaceHolder)this._paramList.get(index);
    }

    public int getCapacity() {
        return this._paramList.size();
    }

    public void parseResultSetOn() {
        this.parseResultSet = true;
    }

    public void parseResultSetOff() {
        this.parseResultSet = false;
    }

    public boolean getParseResultSetState() {
        System.err.println(this.parseResultSet);
        return this.parseResultSet;
    }

    public String toString() {
        String s = this._stmt + " with ( ";
        Iterator it = this._paramList.iterator();
        while (it.hasNext()) {
            s = s + it.next().toString() + " ";
        }
        s = s + " )";
        return s;
    }
}

